/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

interface AutomatonIntExpr
extends AutomatonExpression {
    public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments var1);

    public static class Minus
    implements AutomatonIntExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;

        public Minus(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            return new AutomatonExpression.ResultValue<Integer>(resA.getValue() - resB.getValue());
        }

        public String toString() {
            return "(" + this.a + " - " + this.b + ")";
        }
    }

    public static class Plus
    implements AutomatonIntExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;

        public Plus(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            return new AutomatonExpression.ResultValue<Integer>(resA.getValue() + resB.getValue());
        }

        public String toString() {
            return "(" + this.a + " + " + this.b + ")";
        }
    }

    public static class CPAQuery
    implements AutomatonIntExpr {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Integer>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonIntExpr.CPAQuery");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (result instanceof NumericValue) {
                        result = ((NumericValue)result).getNumber();
                    }
                    if (result instanceof Integer) {
                        String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                        pArgs.getLogger().log(Level.FINER, new Object[]{message});
                        return new AutomatonExpression.ResultValue<Integer>((Integer)result);
                    }
                    if (result instanceof Long) {
                        String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe.toString() + "\"";
                        pArgs.getLogger().log(Level.FINER, new Object[]{message});
                        return new AutomatonExpression.ResultValue<Integer>(((Long)result).intValue());
                    }
                    pArgs.getLogger().log(Level.WARNING, new Object[]{"Automaton got a non-Numeric value during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + "."});
                    return new AutomatonExpression.ResultValue<Integer>("Automaton got a non-Numeric value during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ".", "AutomatonIntExpr.CPAQuery");
                }
                catch (InvalidQueryException e) {
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ".");
                    return new AutomatonExpression.ResultValue<Integer>("Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ".", "AutomatonIntExpr.CPAQuery");
                }
            }
            pArgs.getLogger().log(Level.WARNING, new Object[]{"Did not find the CPA to be queried " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + "."});
            return new AutomatonExpression.ResultValue<Integer>("Did not find the CPA to be queried " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ".", "AutomatonIntExpr.CPAQuery");
        }
    }

    public static class VarAccess
    implements AutomatonIntExpr {
        private final String varId;
        private static Pattern TRANSITION_VARS_PATTERN = Pattern.compile("\\$\\d+");

        public VarAccess(String pId) {
            if (pId.startsWith("$$")) {
                Integer.parseInt(pId.substring(2));
            }
            this.varId = pId;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            if (TRANSITION_VARS_PATTERN.matcher(this.varId).matches()) {
                int key = Integer.parseInt(this.varId.substring(1));
                String val = pArgs.getTransitionVariable(key);
                if (val == null) {
                    pArgs.getLogger().log(Level.WARNING, new Object[]{"could not find the transition variable $" + key + "."});
                    return new AutomatonExpression.ResultValue<Integer>("could not find the transition variable $" + key + ".", "AutomatonIntExpr.VarAccess");
                }
                try {
                    int value = Integer.parseInt(val);
                    return new AutomatonExpression.ResultValue<Integer>(value);
                }
                catch (NumberFormatException e) {
                    pArgs.getLogger().log(Level.WARNING, new Object[]{"could not parse the contents of transition variable $" + key + "=\"" + val + "\"."});
                    return new AutomatonExpression.ResultValue<Integer>("could not parse the contents of transition variable $" + key + "=\"" + val + "\".", "AutomatonIntExpr.VarAccess");
                }
            }
            if (this.varId.equals("$line")) {
                return new AutomatonExpression.ResultValue<Integer>(pArgs.getCfaEdge().getLineNumber());
            }
            AutomatonVariable variable = pArgs.getAutomatonVariables().get(this.varId);
            if (variable != null) {
                return new AutomatonExpression.ResultValue<Integer>(variable.getValue());
            }
            pArgs.getLogger().log(Level.WARNING, new Object[]{"could not find the automaton variable " + this.varId + "."});
            return new AutomatonExpression.ResultValue<Integer>("could not find the automaton variable " + this.varId + ".", "AutomatonIntExpr.VarAccess");
        }

        public String toString() {
            return this.varId;
        }
    }

    public static class Constant
    implements AutomatonIntExpr {
        private final AutomatonExpression.ResultValue<Integer> constantResult;

        public Constant(int pI) {
            this.constantResult = new AutomatonExpression.ResultValue<Integer>(pI);
        }

        public Constant(String pI) {
            this(Integer.parseInt(pI));
        }

        public int getIntValue() {
            return this.constantResult.getValue();
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            return this.constantResult;
        }
    }
}

