/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.io.CharStreams;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonScanner;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class AutomatonInternalTest {
    private final Configuration config;
    private final LogManager logger;
    private final CParser parser;
    private static final Path defaultSpec = Paths.get((String)"test/config/automata/defaultSpecification.spc", (String[])new String[0]);
    private final SubjectFactory<ASTMatcherSubject, String> astMatcher = new SubjectFactory<ASTMatcherSubject, String>(){

        public ASTMatcherSubject getSubject(FailureStrategy pFs, String pThat) {
            return new ASTMatcherSubject(pFs, pThat);
        }
    };

    public AutomatonInternalTest() throws InvalidConfigurationException {
        this.config = TestDataTools.configurationForTest().build();
        this.logger = TestLogManager.getInstance();
        CParser.ParserOptions options = CParser.Factory.getDefaultOptions();
        this.parser = CParser.Factory.getParser(this.config, this.logger, options, MachineModel.LINUX32);
    }

    @Test
    public void testScanner() throws InvalidConfigurationException, IOException {
        ComplexSymbolFactory sf1 = new ComplexSymbolFactory();
        try (InputStream input = defaultSpec.asByteSource().openStream();){
            AutomatonScanner s = new AutomatonScanner(input, defaultSpec, this.config, this.logger, sf1);
            Symbol symb = s.next_token();
            while (symb.sym != 0) {
                symb = s.next_token();
            }
        }
    }

    @Test
    public void testParser() throws Exception {
        ComplexSymbolFactory sf = new ComplexSymbolFactory();
        try (InputStream input = defaultSpec.asByteSource().openStream();){
            AutomatonScanner scanner = new AutomatonScanner(input, defaultSpec, this.config, this.logger, sf);
            Symbol symbol = new AutomatonParser(scanner, (SymbolFactory)sf, this.logger, this.parser, CProgramScope.empty()).parse();
            List as = (List)symbol.value;
            for (Automaton a : as) {
                a.writeDotFile(CharStreams.nullWriter());
            }
        }
    }

    @Test
    public void testAndOr() throws CPATransferException {
        AutomatonBoolExpr.CPAQuery cannot = new AutomatonBoolExpr.CPAQuery("none", "none");
        Map<String, AutomatonVariable> vars = Collections.emptyMap();
        List<AbstractState> elements = Collections.emptyList();
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, vars, elements, null, null);
        AutomatonBoolExpr myTrue = AutomatonBoolExpr.TRUE;
        AutomatonBoolExpr myFalse = AutomatonBoolExpr.FALSE;
        AutomatonBoolExpr ex = new AutomatonBoolExpr.And(myTrue, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)true);
        ex = new AutomatonBoolExpr.And(myTrue, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)false);
        ex = new AutomatonBoolExpr.And(myTrue, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.And(myFalse, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)false);
        ex = new AutomatonBoolExpr.And(myFalse, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)false);
        ex = new AutomatonBoolExpr.And(myFalse, cannot);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)false);
        ex = new AutomatonBoolExpr.And(cannot, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.And(cannot, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)false);
        ex = new AutomatonBoolExpr.And(cannot, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.Or(myTrue, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)true);
        ex = new AutomatonBoolExpr.Or(myTrue, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)true);
        ex = new AutomatonBoolExpr.Or(myTrue, cannot);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)true);
        ex = new AutomatonBoolExpr.Or(myFalse, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)true);
        ex = new AutomatonBoolExpr.Or(myFalse, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)false);
        ex = new AutomatonBoolExpr.Or(myFalse, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.Or(cannot, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isEqualTo((Object)true);
        ex = new AutomatonBoolExpr.Or(cannot, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.Or(cannot, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
    }

    @Test
    public void testJokerReplacementInPattern() {
        String result = AutomatonASTComparator.replaceJokersInPattern("$20 = $?");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Num20  =  CPAchecker_AutomatonAnalysis_JokerExpression");
        result = AutomatonASTComparator.replaceJokersInPattern("$1 = $?");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Num1  =  CPAchecker_AutomatonAnalysis_JokerExpression");
        result = AutomatonASTComparator.replaceJokersInPattern("$? = $?");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression  =  CPAchecker_AutomatonAnalysis_JokerExpression");
        result = AutomatonASTComparator.replaceJokersInPattern("$1 = $5");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Num1  =  CPAchecker_AutomatonAnalysis_JokerExpression_Num5 ");
    }

    @Test
    public void testJokerReplacementInAST() throws InvalidAutomatonException, InvalidConfigurationException {
        String pattern = "$20 = $5($1, $?);";
        String source = "var1 = function(var2, egal);";
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"$20 = $5($1, $?);")).matches("var1 = function(var2, egal);").withVariableValue(20, "var1");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"$20 = $5($1, $?);")).matches("var1 = function(var2, egal);").withVariableValue(1, "var2");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"$20 = $5($1, $?);")).matches("var1 = function(var2, egal);").withVariableValue(5, "function");
    }

    @Test
    public void transitionVariableReplacement() throws Exception {
        LogManager mockLogger = (LogManager)Mockito.mock(LogManager.class);
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, null, null, null, mockLogger);
        args.putTransitionVariable(1, "hi");
        args.putTransitionVariable(2, "hello");
        String result = args.replaceVariables("$1 == $2");
        Truth.assertThat((String)result).isEqualTo((Object)"hi == hello");
        result = args.replaceVariables("$1 == $1");
        Truth.assertThat((String)result).isEqualTo((Object)"hi == hi");
        result = args.replaceVariables("$1 == $5");
        Truth.assertThat((String)result).isNull();
        ((LogManager)Mockito.verify((Object)mockLogger)).log((Level)Mockito.eq((Object)Level.WARNING), new Object[]{Mockito.anyVararg()});
    }

    @Test
    public void testASTcomparison() throws InvalidAutomatonException, InvalidConfigurationException {
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"x= $?;")).matches("x=5;");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"x= 10;")).doesNotMatch("x=5;");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"$? =10;")).doesNotMatch("x=5;");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"$?=$?;")).matches("x  = 5;");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"b    = 5;")).doesNotMatch("a = 5;");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"init($?);")).matches("init(a);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"init($?);")).matches("init();");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"init($1);")).doesNotMatch("init();");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"init($?, b);")).matches("init(a, b);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"init($?, c);")).doesNotMatch("init(a, b);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"x=$?")).matches("x = 5;");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"x=$?;")).matches("x = 5");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"f($?);")).matches("f();");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"f($?);")).matches("f(x);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"f($?);")).matches("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"f(x, $?);")).doesNotMatch("f(x);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"f(x, $?);")).matches("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about(this.astMatcher).that((Object)"f(x, $?);")).doesNotMatch("f(x, y, z);");
    }

    private static interface Matches {
        public void withVariableValue(int var1, String var2);
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private class ASTMatcherSubject
    extends Subject<ASTMatcherSubject, String> {
        private final AutomatonExpressionArguments args;

        public ASTMatcherSubject(FailureStrategy pFailureStrategy, String pPattern) {
            super(pFailureStrategy, (Object)pPattern);
            this.args = new AutomatonExpressionArguments(null, null, null, null, null);
        }

        protected String getDisplaySubject() {
            if (this.internalCustomName() != null) {
                return super.getDisplaySubject();
            }
            return "ASTMatcher pattern " + super.getDisplaySubject();
        }

        private boolean matches0(String src) throws InvalidAutomatonException, InvalidConfigurationException {
            CStatement sourceAST = AutomatonASTComparator.generateSourceAST(src, AutomatonInternalTest.this.parser, CProgramScope.empty());
            AutomatonASTComparator.ASTMatcher matcher = AutomatonASTComparator.generatePatternAST((String)this.getSubject(), AutomatonInternalTest.this.parser, CProgramScope.empty());
            return matcher.matches(sourceAST, this.args);
        }

        public Matches matches(final String src) {
            boolean matches;
            try {
                matches = this.matches0(src);
            }
            catch (InvalidConfigurationException | InvalidAutomatonException e) {
                this.failureStrategy.fail("Cannot parse source or pattern", e);
                return new Matches(){

                    @Override
                    public void withVariableValue(int pVar, String pValue) {
                        ASTMatcherSubject.this.fail("Cannot test value of variable with failed parsing.");
                    }
                };
            }
            if (!matches) {
                this.fail("matches", src);
                return new Matches(){

                    @Override
                    public void withVariableValue(int pVar, String pValue) {
                        ASTMatcherSubject.this.fail("Cannot test value of variable if pattern does not match.");
                    }
                };
            }
            return new Matches(){

                @Override
                public void withVariableValue(int pVar, String pExpectedValue) {
                    String actualValue;
                    if (!ASTMatcherSubject.this.args.getTransitionVariables().containsKey(pVar)) {
                        ASTMatcherSubject.this.failWithBadResults("has variable", pVar, "has variables", ASTMatcherSubject.this.args.getTransitionVariables().keySet());
                    }
                    if (!(actualValue = ASTMatcherSubject.this.args.getTransitionVariable(pVar)).equals(pExpectedValue)) {
                        ASTMatcherSubject.this.failWithBadResults("matches <" + src + "> with value of variable $" + pVar + " being", pExpectedValue, "has value", actualValue);
                    }
                }
            };
        }

        public void doesNotMatch(String src) {
            try {
                if (this.matches0(src)) {
                    this.fail("does not match", src);
                }
            }
            catch (InvalidConfigurationException | InvalidAutomatonException e) {
                this.failureStrategy.fail("Cannot parse source or pattern", e);
            }
        }
    }
}

