/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class AutomatonState
implements AbstractQueryableState,
Targetable,
Serializable,
Partitionable,
AbstractStateWithAssumptions,
Graphable {
    private static final long serialVersionUID = -4665039439114057346L;
    private static final String AutomatonAnalysisNamePrefix = "AutomatonAnalysis_";
    static final String INTERNAL_STATE_IS_TARGET_PROPERTY = "internalStateIsTarget";
    private transient ControlAutomatonCPA automatonCPA;
    private final Map<String, AutomatonVariable> vars;
    private transient AutomatonInternalState internalState;
    private final ImmutableList<AStatement> assumptions;
    private int matches = 0;
    private int failedMatches = 0;
    private Set<Integer> tokensSinceLastMatch = null;
    private final String violatedPropertyDescription;

    static AutomatonState automatonStateFactory(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, ControlAutomatonCPA pAutomatonCPA, ImmutableList<AStatement> pAssumptions, int successfulMatches, int failedMatches, String violatedPropertyDescription) {
        if (pInternalState == AutomatonInternalState.BOTTOM) {
            return pAutomatonCPA.getBottomState();
        }
        return new AutomatonState(pVars, pInternalState, pAutomatonCPA, pAssumptions, successfulMatches, failedMatches, violatedPropertyDescription);
    }

    static AutomatonState automatonStateFactory(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, ControlAutomatonCPA pAutomatonCPA, int successfulMatches, int failedMatches, String violatedPropertyDescription) {
        return AutomatonState.automatonStateFactory(pVars, pInternalState, pAutomatonCPA, (ImmutableList<AStatement>)ImmutableList.of(), successfulMatches, failedMatches, violatedPropertyDescription);
    }

    private AutomatonState(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, ControlAutomatonCPA pAutomatonCPA, ImmutableList<AStatement> pAssumptions, int successfulMatches, int failedMatches, String pViolatedPropertyDescription) {
        this.vars = (Map)Preconditions.checkNotNull(pVars);
        this.internalState = (AutomatonInternalState)Preconditions.checkNotNull((Object)pInternalState);
        this.automatonCPA = (ControlAutomatonCPA)Preconditions.checkNotNull((Object)pAutomatonCPA);
        this.matches = successfulMatches;
        this.failedMatches = failedMatches;
        this.assumptions = pAssumptions;
        this.violatedPropertyDescription = pViolatedPropertyDescription;
        if (this.isTarget()) {
            Preconditions.checkNotNull((Object)this.violatedPropertyDescription);
        }
    }

    @Override
    public boolean isTarget() {
        return this.automatonCPA.isTreatingErrorsAsTargets() && this.internalState.isTarget();
    }

    @Override
    public String getViolatedPropertyDescription() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isTarget());
        return (String)Preconditions.checkNotNull((Object)this.violatedPropertyDescription);
    }

    @Override
    public Object getPartitionKey() {
        return this.internalState;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj == null) {
            return false;
        }
        if (!pObj.getClass().equals(this.getClass())) {
            return false;
        }
        AutomatonState otherState = (AutomatonState)pObj;
        return this.internalState.equals(otherState.internalState) && this.vars.equals(otherState.vars);
    }

    public int hashCode() {
        return this.internalState.hashCode();
    }

    public List<CStatementEdge> getAsStatementEdges(String cFunctionName) {
        if (this.assumptions.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<CStatementEdge> result = new ArrayList<CStatementEdge>(this.assumptions.size());
        for (AStatement statement : this.assumptions) {
            if (!(statement instanceof CAssignment)) continue;
            CAssignment assignment = (CAssignment)statement;
            if (assignment.getRightHandSide() instanceof CExpression) {
                result.add(new CStatementEdge(assignment.toASTString(), assignment, assignment.getFileLocation(), new CFANode(cFunctionName), new CFANode(cFunctionName)));
                continue;
            }
            if (!(assignment.getRightHandSide() instanceof CFunctionCall)) continue;
        }
        return result;
    }

    @Override
    public List<AssumeEdge> getAsAssumeEdges(String cFunctionName) {
        if (this.assumptions.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<AssumeEdge> result = new ArrayList<AssumeEdge>(this.assumptions.size());
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(this.automatonCPA.getMachineModel(), this.automatonCPA.getLogManager());
        for (AStatement statement : this.assumptions) {
            if (statement instanceof CAssignment) {
                CAssignment assignment = (CAssignment)statement;
                if (assignment.getRightHandSide() instanceof CExpression) {
                    CExpression expression = (CExpression)assignment.getRightHandSide();
                    CBinaryExpression assumeExp = expressionBuilder.buildBinaryExpressionUnchecked(assignment.getLeftHandSide(), expression, CBinaryExpression.BinaryOperator.EQUALS);
                    result.add(new CAssumeEdge(assignment.toASTString(), assignment.getFileLocation(), new CFANode(cFunctionName), new CFANode(cFunctionName), assumeExp, true));
                } else if (assignment.getRightHandSide() instanceof CFunctionCall) {
                    // empty if block
                }
            }
            if (!(statement instanceof CExpressionStatement) || !(((CExpressionStatement)statement).getExpression().getExpressionType() instanceof CSimpleType) || !((CSimpleType)((CExpressionStatement)statement).getExpression().getExpressionType()).getType().isIntegerType()) continue;
            result.add(new CAssumeEdge(statement.toASTString(), statement.getFileLocation(), new CFANode(cFunctionName), new CFANode(cFunctionName), ((CExpressionStatement)statement).getExpression(), true));
        }
        return result;
    }

    public String getOwningAutomatonName() {
        return this.automatonCPA.getAutomaton().getName();
    }

    public String toString() {
        return (this.automatonCPA != null ? this.automatonCPA.getAutomaton().getName() + ": " : "") + this.internalState.getName() + ' ' + Joiner.on((char)' ').withKeyValueSeparator("=").join(this.vars);
    }

    @Override
    public String toDOTLabel() {
        if (!this.internalState.getName().equals("Init")) {
            return (this.automatonCPA != null ? this.automatonCPA.getAutomaton().getName() + ": " : "") + this.internalState.getName();
        }
        return "";
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equalsIgnoreCase(INTERNAL_STATE_IS_TARGET_PROPERTY)) {
            return this.getInternalState().isTarget();
        }
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        String left = parts[0].trim();
        String right = parts[1].trim();
        if (left.equalsIgnoreCase("state")) {
            return this.getInternalState().getName().equals(right);
        }
        AutomatonVariable var = this.vars.get(left);
        if (var != null) {
            try {
                int val = Integer.parseInt(right);
                return var.getValue() == val;
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the int \"" + right + "\".");
            }
        }
        throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Only accepting \"State == something\" and \"varname = something\" queries so far.");
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        String[] parts = pModification.split(":=");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not split the string correctly.");
        }
        String left = parts[0].trim();
        String right = parts[1].trim();
        AutomatonVariable var = this.vars.get(left);
        if (var != null) {
            try {
                int val = Integer.parseInt(right);
                var.setValue(val);
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not parse the int \"" + right + "\".");
            }
        } else {
            throw new InvalidQueryException("Could not modify the variable \"" + left + "\" (Variable not found)");
        }
    }

    @Override
    public Boolean evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public String getCPAName() {
        return AutomatonAnalysisNamePrefix + this.automatonCPA.getAutomaton().getName();
    }

    public ImmutableList<AStatement> getAssumptions() {
        return this.assumptions;
    }

    AutomatonInternalState getInternalState() {
        return this.internalState;
    }

    public String getInternalStateName() {
        return this.internalState.getName();
    }

    Map<String, AutomatonVariable> getVars() {
        return this.vars;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.internalState.getStateId());
        out.writeObject(this.automatonCPA.getAutomaton().getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int stateId = in.readInt();
        this.internalState = GlobalInfo.getInstance().getAutomatonInfo().getStateById(stateId);
        this.automatonCPA = GlobalInfo.getInstance().getAutomatonInfo().getCPAForAutomaton((String)in.readObject());
    }

    public int getMatches() {
        return this.matches;
    }

    public int getFailedMatches() {
        return this.failedMatches;
    }

    public Set<Integer> getTokensSinceLastMatch() {
        if (this.tokensSinceLastMatch == null) {
            return Collections.emptySet();
        }
        return this.tokensSinceLastMatch;
    }

    public void addNoMatchTokens(Set<Integer> pTokens) {
        if (this.tokensSinceLastMatch == null) {
            this.tokensSinceLastMatch = Sets.newTreeSet();
        }
        this.tokensSinceLastMatch.addAll(pTokens);
    }

    public void setFailedMatches(int pFailedMatches) {
        this.failedMatches = pFailedMatches;
    }

    public void setMatches(int pMatches) {
        this.matches = pMatches;
    }

    static class AutomatonUnknownState
    extends AutomatonState {
        private static final long serialVersionUID = -2010032222354565037L;
        private final AutomatonState previousState;

        AutomatonUnknownState(AutomatonState pPreviousState) {
            super(pPreviousState.getVars(), pPreviousState.getInternalState(), pPreviousState.automatonCPA, pPreviousState.getAssumptions(), -1, -1, null);
            this.previousState = pPreviousState;
        }

        AutomatonState getPreviousState() {
            return this.previousState;
        }

        @Override
        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj == null) {
                return false;
            }
            if (!pObj.getClass().equals(this.getClass())) {
                return false;
            }
            AutomatonUnknownState otherState = (AutomatonUnknownState)pObj;
            return this.previousState.equals(otherState.previousState);
        }

        @Override
        public int hashCode() {
            return this.previousState.hashCode() + 724;
        }

        @Override
        public String toString() {
            return "AutomatonUnknownState<" + this.previousState.toString() + ">";
        }
    }

    static class BOTTOM
    extends AutomatonState {
        private static final long serialVersionUID = -401794748742705212L;

        public BOTTOM(ControlAutomatonCPA pAutomatonCPA) {
            super(Collections.emptyMap(), AutomatonInternalState.BOTTOM, pAutomatonCPA, ImmutableList.of(), 0, 0, null);
        }

        @Override
        public boolean checkProperty(String pProperty) throws InvalidQueryException {
            return pProperty.toLowerCase().equals("state == bottom");
        }

        @Override
        public String toString() {
            return "AutomatonState.BOTTOM";
        }
    }

    static class TOP
    extends AutomatonState {
        private static final long serialVersionUID = -7848577870312049023L;

        public TOP(ControlAutomatonCPA pAutomatonCPA) {
            super(Collections.emptyMap(), new AutomatonInternalState("_predefinedState_TOP", Collections.emptyList()), pAutomatonCPA, ImmutableList.of(), 0, 0, null);
        }

        @Override
        public boolean checkProperty(String pProperty) throws InvalidQueryException {
            return pProperty.toLowerCase().equals("state == top");
        }

        @Override
        public String toString() {
            return "AutomatonState.TOP";
        }
    }
}

