/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.io.PrintStream;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;

class AutomatonStatistics
extends AbstractStatistics {
    private final ControlAutomatonCPA mCpa;

    public AutomatonStatistics(ControlAutomatonCPA pCpa) {
        this.mCpa = pCpa;
    }

    @Override
    public String getName() {
        return "AutomatonAnalysis (" + this.mCpa.getAutomaton().getName() + ")";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        AutomatonTransferRelation trans = this.mCpa.getTransferRelation();
        this.put(out, 0, "Number of states", this.mCpa.getAutomaton().getNumberOfStates());
        this.put(out, 0, "Total time for successor computation", trans.totalPostTime);
        if (trans.totalPostTime.getSumTime().compareTo(TimeSpan.ofMillis((long)500L)) >= 0) {
            this.put(out, 1, "Time for transition matches", trans.matchTime);
            this.put(out, 1, "Time for transition assertions", trans.assertionsTime);
            this.put(out, 1, "Time for transition actions", trans.actionTime);
        }
        if (trans.totalStrengthenTime.getNumberOfIntervals() > 0) {
            this.put(out, 0, "Total time for strengthen operator", trans.totalStrengthenTime);
        }
        int stateBranchings = trans.automatonSuccessors.getValueCount() - trans.automatonSuccessors.getTimesWithValue(0) - trans.automatonSuccessors.getTimesWithValue(1);
        this.put(out, 0, "Automaton transfers with branching", stateBranchings);
        this.put(out, 0, "Automaton transfer successors", trans.automatonSuccessors);
    }
}

