/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableMap;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Test;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class AutomatonTest {
    private static final String CPAS_UNINITVARS = "cpa.location.LocationCPA, cpa.uninitvars.UninitializedVariablesCPA";
    private static final String OUTPUT_FILE = "output/AutomatonExport.dot";

    @Test
    public void cyclicInclusionTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)CPAS_UNINITVARS, (Object)"specification", (Object)"test/config/automata/tmpSpecification.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"FALSE");
        Path tmpSpc = Paths.get((String)"test/config/automata/tmpSpecification.spc", (String[])new String[0]);
        String content = "#include UninitializedVariablesTestAutomaton.txt \n#include tmpSpecification.spc \n";
        Files.writeFile((Path)tmpSpc, (Object)content);
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/UninitVarsErrors.c");
        results.assertIsSafe();
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"test/config/automata/tmpSpecification.spc\" was referenced multiple times.");
        ((BooleanSubject)Truth.assertThat((Boolean)tmpSpc.delete()).named("deletion of temporary specification successful")).isTrue();
    }

    @Test
    public void includeSpecificationTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)CPAS_UNINITVARS, (Object)"specification", (Object)"test/config/automata/defaultSpecificationForTesting.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/UninitVarsErrors.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Automaton: Uninitialized return value");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Automaton: Uninitialized variable used");
    }

    @Test
    public void specificationAndNoCompositeTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"cpa", (Object)"cpa.location.LocationCPA", (Object)"log.consoleLevel", (Object)"INFO", (Object)"specification", (Object)"test/config/automata/LockingAutomatonAll.txt");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Option specification gave specification automata, but no CompositeCPA was used");
        Truth.assertThat((Comparable)((Object)results.getCheckerResult().getResult())).isEqualTo((Object)CPAcheckerResult.Result.NOT_YET_STARTED);
    }

    @Test
    public void modificationTestWithSpecification() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.value.ValueAnalysisCPA", (Object)"specification", (Object)"test/config/automata/modifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.value.threshold", (Object)"10");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"MODIFIED");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Modification successful");
        results.assertIsSafe();
    }

    @Test
    public void matchEndOfProgramTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA", (Object)"specification", (Object)"test/config/automata/PrintLastStatementAutomaton.spc", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"TRUE");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/loop1.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Last statement is \"return (0);\"");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Last statement is \"return (-1);\"");
        results.assertIsSafe();
    }

    @Test
    public void failIfNoAutomatonGiven() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.value.ValueAnalysisCPA, cpa.automaton.ControlAutomatonCPA", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.value.threshold", (Object)"10");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Truth.assertThat((Comparable)((Object)results.getCheckerResult().getResult())).isEqualTo((Object)CPAcheckerResult.Result.NOT_YET_STARTED);
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Explicitly specified automaton CPA needs option cpa.automaton.inputFile!");
    }

    @Test
    public void modificationTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.value.ValueAnalysisCPA, cpa.automaton.ControlAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/modifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.value.threshold", (Object)"10");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"MODIFIED");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Modification successful");
        results.assertIsSafe();
    }

    @Test
    public void modification_in_Observer_throws_Test() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.value.ValueAnalysisCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/modifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"SEVERE", (Object)"cpa.value.threshold", (Object)"10");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/modificationExample.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Error: Invalid configuration (The transition \"MATCH ");
    }

    @Test
    public void setuidTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/simple_setuid.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/simple_setuid_test.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Systemcall in line 14 with userid 2");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"going to ErrorState on edge \"system(40);\"");
        results.assertIsUnsafe();
    }

    @Test
    public void uninitVarsTest() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA, cpa.uninitvars.UninitializedVariablesCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/UninitializedVariablesTestAutomaton.txt", (Object)"log.consoleLevel", (Object)"FINER", (Object)"cpa.automaton.dotExportFile", (Object)OUTPUT_FILE, (Object)"analysis.stopAfterError", (Object)"FALSE");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/UninitVarsErrors.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Automaton: Uninitialized return value");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"Automaton: Uninitialized variable used");
    }

    @Test
    public void locking_correct() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/LockingAutomatonAll.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.automaton.dotExportFile", (Object)OUTPUT_FILE);
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/locking_correct.c");
        results.assertIsSafe();
    }

    @Test
    public void locking_incorrect() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/LockingAutomatonAll.txt", (Object)"log.consoleLevel", (Object)"INFO");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/locking_incorrect.c");
        results.assertIsUnsafe();
    }

    @Test
    public void valueAnalysis_observing() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA, cpa.value.ValueAnalysisCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/ExplicitAnalysisObservingAutomaton.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.value.threshold", (Object)"2000");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/ex2.cil.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"st==3 after Edge st = 3;");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"st==1 after Edge st = 1;");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"st==2 after Edge st = 2;");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"st==4 after Edge st = 4;");
        results.assertIsSafe();
    }

    @Test
    public void functionIdentifying() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA", (Object)"cpa.automaton.inputFile", (Object)"test/config/automata/FunctionIdentifyingAutomaton.txt", (Object)"log.consoleLevel", (Object)"FINER");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/functionCall.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"i'm in Main after Edge int y;");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"i'm in f after Edge y = f()");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"i'm in f after Edge int x;");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"i'm in Main after Edge return");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"i'm in Main after Edge ERROR:");
    }

    @Test
    public void interacting_Automata() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA, cpa.automaton.ObserverAutomatonCPA automatonA, cpa.automaton.ObserverAutomatonCPA automatonB, cpa.value.ValueAnalysisCPA", (Object)"automatonA.cpa.automaton.inputFile", (Object)"test/config/automata/InteractionAutomatonA.txt", (Object)"automatonB.cpa.automaton.inputFile", (Object)"test/config/automata/InteractionAutomatonB.txt", (Object)"log.consoleLevel", (Object)"INFO", (Object)"cpa.value.threshold", (Object)"2000");
        TestResults results = CPATestRunner.run((Map<String, String>)prop, "test/programs/simple/loop1.c");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"A: Matched i in line 13 x=2");
        Truth.assertThat((String)results.getLog()).contains((CharSequence)"B: A increased to 2 And i followed ");
        results.assertIsSafe();
    }
}

