/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.SourceLocationMapper;
import org.sosy_lab.cpachecker.util.statistics.StatIntHist;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

@Options(prefix="cpa.automaton")
class AutomatonTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, description="Collect information about matched (and traversed) tokens.")
    private boolean collectTokenInformation = false;
    private final ControlAutomatonCPA cpa;
    private final LogManager logger;
    Timer totalPostTime = new Timer();
    Timer matchTime = new Timer();
    Timer assertionsTime = new Timer();
    Timer actionTime = new Timer();
    Timer totalStrengthenTime = new Timer();
    StatIntHist automatonSuccessors = new StatIntHist(StatKind.AVG, "Automaton transfer successors");

    public AutomatonTransferRelation(ControlAutomatonCPA pCpa, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cpa = pCpa;
        this.logger = pLogger;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        int edgeIndex;
        Preconditions.checkArgument((boolean)(pElement instanceof AutomatonState));
        if (pElement instanceof AutomatonState.AutomatonUnknownState) {
            AutomatonState top = this.cpa.getTopState();
            return Collections.singleton(top);
        }
        if (!(pCfaEdge instanceof MultiEdge)) {
            Collection<AutomatonState> result = this.getAbstractSuccessors0((AutomatonState)pElement, pPrecision, pCfaEdge);
            this.automatonSuccessors.setNextValue(result.size());
            return result;
        }
        ImmutableList<CFAEdge> edges = ((MultiEdge)pCfaEdge).getEdges();
        Preconditions.checkArgument((!edges.isEmpty() ? 1 : 0) != 0);
        AutomatonState currentState = (AutomatonState)pElement;
        Collection<AutomatonState> currentSuccessors = null;
        for (edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
            CFAEdge edge = (CFAEdge)edges.get(edgeIndex);
            currentSuccessors = this.getAbstractSuccessors0(currentState, pPrecision, edge);
            if (currentSuccessors.isEmpty()) {
                this.automatonSuccessors.setNextValue(0);
                return currentSuccessors;
            }
            if (currentSuccessors.size() != 1) break;
            this.automatonSuccessors.setNextValue(1);
            currentState = (AutomatonState)Iterables.getOnlyElement(currentSuccessors);
        }
        if (edgeIndex == edges.size()) {
            this.automatonSuccessors.setNextValue(currentSuccessors.size());
            return currentSuccessors;
        }
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>(1);
        for (AutomatonState successor : currentSuccessors) {
            queue.addLast(Pair.of((Object)successor, (Object)edgeIndex));
        }
        currentSuccessors.clear();
        ArrayList<AutomatonState> results = new ArrayList<AutomatonState>();
        while (!queue.isEmpty()) {
            Pair entry = (Pair)queue.pollFirst();
            AutomatonState state = (AutomatonState)entry.getFirst();
            edgeIndex = (Integer)entry.getSecond();
            CFAEdge edge = (CFAEdge)edges.get(edgeIndex);
            Integer successorIndex = edgeIndex + 1;
            if (successorIndex.intValue() == edges.size()) {
                results.addAll(this.getAbstractSuccessors0(state, pPrecision, edge));
                continue;
            }
            for (AutomatonState successor : this.getAbstractSuccessors0(state, pPrecision, edge)) {
                queue.addLast(Pair.of((Object)successor, (Object)successorIndex));
            }
        }
        this.automatonSuccessors.setNextValue(results.size());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AutomatonState> getAbstractSuccessors0(AutomatonState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        this.totalPostTime.start();
        try {
            if (pElement instanceof AutomatonState.AutomatonUnknownState) {
                pElement = ((AutomatonState.AutomatonUnknownState)pElement).getPreviousState();
            }
            Collection<AutomatonState> collection = this.getFollowStates(pElement, null, pCfaEdge, false);
            return collection;
        }
        finally {
            this.totalPostTime.stop();
        }
    }

    private Collection<AutomatonState> getFollowStates(AutomatonState state, List<AbstractState> otherElements, CFAEdge edge, boolean failOnUnknownMatch) throws CPATransferException {
        Preconditions.checkArgument((!(state instanceof AutomatonState.AutomatonUnknownState) ? 1 : 0) != 0);
        if (state == this.cpa.getBottomState()) {
            return Collections.emptySet();
        }
        if (this.collectTokenInformation) {
            SourceLocationMapper.getKnownToEdge(edge);
        }
        if (state.getInternalState().getTransitions().isEmpty()) {
            return Collections.singleton(state);
        }
        HashSet lSuccessors = Sets.newHashSetWithExpectedSize((int)2);
        AutomatonExpressionArguments exprArgs = new AutomatonExpressionArguments(state, state.getVars(), otherElements, edge, this.logger);
        boolean edgeMatched = false;
        int failedMatches = 0;
        boolean nonDetState = state.getInternalState().isNonDetState();
        ArrayList<Pair> transitionsToBeTaken = new ArrayList<Pair>(2);
        for (AutomatonTransition t : state.getInternalState().getTransitions()) {
            exprArgs.clearTransitionVariables();
            this.matchTime.start();
            AutomatonExpression.ResultValue<Boolean> match = t.match(exprArgs);
            this.matchTime.stop();
            if (match.canNotEvaluate()) {
                if (failOnUnknownMatch) {
                    throw new CPATransferException("Automaton transition condition could not be evaluated: " + match.getFailureMessage());
                }
                return Collections.singleton(new AutomatonState.AutomatonUnknownState(state));
            }
            if (match.getValue().booleanValue()) {
                edgeMatched = true;
                this.assertionsTime.start();
                AutomatonExpression.ResultValue<Boolean> assertionsHold = t.assertionsHold(exprArgs);
                this.assertionsTime.stop();
                if (assertionsHold.canNotEvaluate()) {
                    if (failOnUnknownMatch) {
                        throw new CPATransferException("Automaton transition assertions could not be evaluated: " + assertionsHold.getFailureMessage());
                    }
                    return Collections.singleton(new AutomatonState.AutomatonUnknownState(state));
                }
                if (assertionsHold.getValue().booleanValue()) {
                    if (!t.canExecuteActionsOn(exprArgs)) {
                        if (failOnUnknownMatch) {
                            throw new CPATransferException("Automaton transition action could not be executed");
                        }
                        return Collections.singleton(new AutomatonState.AutomatonUnknownState(state));
                    }
                    ImmutableMap transitionVariables = ImmutableMap.copyOf(exprArgs.getTransitionVariables());
                    transitionsToBeTaken.add(Pair.of((Object)t, (Object)transitionVariables));
                } else {
                    AutomatonState errorState = AutomatonState.automatonStateFactory(Collections.emptyMap(), AutomatonInternalState.ERROR, this.cpa, 0, 0, "");
                    this.logger.log(Level.INFO, new Object[]{"Automaton going to ErrorState on edge \"" + edge.getDescription() + "\""});
                    lSuccessors.add(errorState);
                }
                if (nonDetState) continue;
                break;
            }
            ++failedMatches;
        }
        if (edgeMatched) {
            for (Pair pair : transitionsToBeTaken) {
                AutomatonState lSuccessor;
                AutomatonTransition t = (AutomatonTransition)pair.getFirst();
                Map transitionVariables = (Map)pair.getSecond();
                this.actionTime.start();
                Map<String, AutomatonVariable> newVars = AutomatonTransferRelation.deepCloneVars(state.getVars());
                exprArgs.setAutomatonVariables(newVars);
                exprArgs.putTransitionVariables(transitionVariables);
                t.executeActions(exprArgs);
                this.actionTime.stop();
                String violatedPropertyDescription = null;
                if (t.getFollowState().isTarget()) {
                    violatedPropertyDescription = t.getViolatedPropertyDescription(exprArgs);
                }
                if ((lSuccessor = AutomatonState.automatonStateFactory(newVars, t.getFollowState(), this.cpa, t.getAssumptions(), state.getMatches() + 1, state.getFailedMatches(), violatedPropertyDescription)) instanceof AutomatonState.BOTTOM) continue;
                lSuccessors.add(lSuccessor);
            }
            return lSuccessors;
        }
        AutomatonState stateNewCounters = AutomatonState.automatonStateFactory(state.getVars(), state.getInternalState(), this.cpa, state.getMatches(), state.getFailedMatches() + failedMatches, null);
        if (this.collectTokenInformation) {
            stateNewCounters.addNoMatchTokens(state.getTokensSinceLastMatch());
            if (edge.getEdgeType() != CFAEdgeType.DeclarationEdge) {
                stateNewCounters.addNoMatchTokens(SourceLocationMapper.getAbsoluteTokensFromCFAEdge(edge, true));
            }
        }
        return Collections.singleton(stateNewCounters);
    }

    private static Map<String, AutomatonVariable> deepCloneVars(Map<String, AutomatonVariable> pOld) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)pOld.size());
        for (Map.Entry<String, AutomatonVariable> e : pOld.entrySet()) {
            result.put(e.getKey(), e.getValue().clone());
        }
        return result;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, List<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        if (!(pElement instanceof AutomatonState.AutomatonUnknownState)) {
            return null;
        }
        this.totalStrengthenTime.start();
        AutomatonState.AutomatonUnknownState lUnknownState = (AutomatonState.AutomatonUnknownState)pElement;
        Collection<AutomatonState> lSuccessors = this.getFollowStates(lUnknownState.getPreviousState(), pOtherElements, pCfaEdge, true);
        this.totalStrengthenTime.stop();
        assert (!FluentIterable.from(lSuccessors).anyMatch(Predicates.instanceOf(AutomatonState.AutomatonUnknownState.class)));
        return lSuccessors;
    }
}

