/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonAction;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class AutomatonTransition {
    private final AutomatonBoolExpr trigger;
    private final AutomatonBoolExpr assertion;
    private final ImmutableList<AStatement> assumption;
    private final ImmutableList<AutomatonAction> actions;
    private final AutomatonExpression.StringExpression violatedPropertyDescription;
    private final String followStateName;
    private AutomatonInternalState followState = null;

    public AutomatonTransition(AutomatonBoolExpr pTrigger, List<AutomatonBoolExpr> pAssertions, List<AutomatonAction> pActions, String pFollowStateName) {
        this(pTrigger, pAssertions, (List<CStatement>)ImmutableList.copyOf(new ArrayList()), pActions, pFollowStateName, null, null);
    }

    public AutomatonTransition(AutomatonBoolExpr pTrigger, List<AutomatonBoolExpr> pAssertions, List<AutomatonAction> pActions, AutomatonInternalState pFollowState) {
        this(pTrigger, pAssertions, (List<CStatement>)ImmutableList.copyOf(new ArrayList()), pActions, pFollowState.getName(), pFollowState, null);
    }

    public AutomatonTransition(AutomatonBoolExpr pTrigger, List<AutomatonBoolExpr> pAssertions, List<CStatement> pAssumption, List<AutomatonAction> pActions, String pFollowStateName) {
        this(pTrigger, pAssertions, pAssumption, pActions, pFollowStateName, null, null);
    }

    public AutomatonTransition(AutomatonBoolExpr pTrigger, List<AutomatonBoolExpr> pAssertions, List<CStatement> pAssumption, List<AutomatonAction> pActions, AutomatonInternalState pFollowState, AutomatonExpression.StringExpression pViolatedPropertyDescription) {
        this(pTrigger, pAssertions, pAssumption, pActions, pFollowState.getName(), pFollowState, pViolatedPropertyDescription);
    }

    private AutomatonTransition(AutomatonBoolExpr pTrigger, List<AutomatonBoolExpr> pAssertions, List<CStatement> pAssumption, List<AutomatonAction> pActions, String pFollowStateName, AutomatonInternalState pFollowState, AutomatonExpression.StringExpression pViolatedPropertyDescription) {
        this.trigger = (AutomatonBoolExpr)Preconditions.checkNotNull((Object)pTrigger);
        this.assumption = pAssumption == null ? ImmutableList.of() : ImmutableList.copyOf(pAssumption);
        this.actions = ImmutableList.copyOf(pActions);
        this.followStateName = (String)Preconditions.checkNotNull((Object)pFollowStateName);
        this.followState = pFollowState;
        this.violatedPropertyDescription = pViolatedPropertyDescription;
        if (pAssertions.isEmpty()) {
            this.assertion = AutomatonBoolExpr.TRUE;
        } else {
            AutomatonBoolExpr lAssertion = null;
            for (AutomatonBoolExpr nextAssertion : pAssertions) {
                if (lAssertion == null) {
                    lAssertion = nextAssertion;
                    continue;
                }
                lAssertion = new AutomatonBoolExpr.And(lAssertion, nextAssertion);
            }
            this.assertion = lAssertion;
        }
    }

    void setFollowState(Map<String, AutomatonInternalState> pAllStates) throws InvalidAutomatonException {
        if (this.followState == null) {
            this.followState = pAllStates.get(this.followStateName);
            if (this.followState == null) {
                throw new InvalidAutomatonException("No Follow-State with name " + this.followStateName + " found.");
            }
        }
    }

    public AutomatonExpression.ResultValue<Boolean> match(AutomatonExpressionArguments pArgs) throws CPATransferException {
        return this.trigger.eval(pArgs);
    }

    public AutomatonExpression.ResultValue<Boolean> assertionsHold(AutomatonExpressionArguments pArgs) throws CPATransferException {
        return this.assertion.eval(pArgs);
    }

    public void executeActions(AutomatonExpressionArguments pArgs) throws CPATransferException {
        for (AutomatonAction action : this.actions) {
            AutomatonExpression.ResultValue<? extends Object> res = action.eval(pArgs);
            if (!res.canNotEvaluate()) continue;
            pArgs.getLogger().log(Level.SEVERE, new Object[]{res.getFailureMessage() + " in " + res.getFailureOrigin()});
        }
        if (pArgs.getLogMessage() != null && pArgs.getLogMessage().length() > 0) {
            pArgs.getLogger().log(Level.INFO, new Object[]{pArgs.getLogMessage()});
            pArgs.clearLogMessage();
        }
    }

    public boolean canExecuteActionsOn(AutomatonExpressionArguments pArgs) throws CPATransferException {
        for (AutomatonAction action : this.actions) {
            if (action.canExecuteOn(pArgs)) continue;
            return false;
        }
        return true;
    }

    public AutomatonInternalState getFollowState() {
        return this.followState;
    }

    public AutomatonBoolExpr getTrigger() {
        return this.trigger;
    }

    public String getViolatedPropertyDescription(AutomatonExpressionArguments pArgs) {
        return (String)this.violatedPropertyDescription.eval(pArgs).getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(this.trigger);
        sb.append(" -> ");
        if (!this.assertion.equals(AutomatonBoolExpr.TRUE)) {
            sb.append("ASSERT ");
            sb.append(this.assertion);
        }
        if (!this.actions.isEmpty()) {
            Joiner.on((char)' ').appendTo(sb, this.actions);
            sb.append(" ");
        }
        sb.append(this.followState);
        sb.append(";\"");
        return sb.toString();
    }

    boolean meetsObserverRequirements() {
        if (this.followState.equals(AutomatonInternalState.BOTTOM)) {
            return false;
        }
        for (AutomatonAction action : this.actions) {
            if (!(action instanceof AutomatonAction.CPAModification)) continue;
            return false;
        }
        return true;
    }

    public ImmutableList<AStatement> getAssumptions() {
        return this.assumption;
    }
}

