/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.io.Serializable;

class AutomatonVariable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6765794863680244559L;
    private int value;
    private String name;

    public AutomatonVariable(String type, String name) {
        if (!type.toLowerCase().equals("int") && !type.toLowerCase().equals("integer")) {
            throw new IllegalArgumentException("Only Type int supported");
        }
        this.value = 0;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.value = v;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public AutomatonVariable clone() {
        try {
            return (AutomatonVariable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object pObj) {
        if (super.equals(pObj)) {
            return true;
        }
        if (!(pObj instanceof AutomatonVariable)) {
            return false;
        }
        AutomatonVariable otherVar = (AutomatonVariable)pObj;
        return this.value == otherVar.value && this.name.equals(otherVar.name);
    }

    public int hashCode() {
        return this.value + this.name.hashCode();
    }
}

