/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.BreakOnTargetsPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonStatistics;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="cpa.automaton")
public class ControlAutomatonCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    @Option(secure=true, name="dotExport", description="export automaton to file")
    private boolean export = false;
    @Option(secure=true, name="dotExportFile", description="file for saving the automaton in DOT format (%s will be replaced with automaton name)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate exportFile = PathTemplate.ofFormatString((String)"%s.dot");
    @Option(secure=true, required=false, description="file with automaton specification for ObserverAutomatonCPA and ControlAutomatonCPA")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path inputFile = null;
    @Option(secure=true, description="signal the analysis to break in case the given number of error state is reached ")
    private int breakOnTargetState = 1;
    @Option(secure=true, description="the maximum number of iterations performed after the initial error is found, despite the limitgiven as cpa.automaton.breakOnTargetState is not yet reached")
    private int extraIterationsLimit = -1;
    @Option(secure=true, description="Whether to treat automaton states with an internal error state as targets. This should be the standard use case.")
    private boolean treatErrorsAsTargets = true;
    private final Automaton automaton;
    private final AutomatonState topState = new AutomatonState.TOP(this);
    private final AutomatonState bottomState = new AutomatonState.BOTTOM(this);
    private final AbstractDomain automatonDomain = new FlatLatticeDomain(this.topState);
    private final StopOperator stopOperator = new StopSepOperator(this.automatonDomain);
    private final AutomatonTransferRelation transferRelation;
    private final PrecisionAdjustment precisionAdjustment;
    private final Statistics stats = new AutomatonStatistics(this);
    private final CFA cfa;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ControlAutomatonCPA.class);
    }

    protected ControlAutomatonCPA(@AutomaticCPAFactory.Optional Automaton pAutomaton, Configuration pConfig, LogManager pLogger, CFA pCFA) throws InvalidConfigurationException {
        pConfig.inject((Object)this, ControlAutomatonCPA.class);
        this.cfa = pCFA;
        this.logger = pLogger;
        this.transferRelation = new AutomatonTransferRelation(this, pConfig, pLogger);
        final PrecisionAdjustment lPrecisionAdjustment = this.breakOnTargetState > 0 ? BreakOnTargetsPrecisionAdjustment.getInstance(this.breakOnTargetState, this.extraIterationsLimit) : StaticPrecisionAdjustment.getInstance();
        this.precisionAdjustment = new PrecisionAdjustment(){

            @Override
            public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, AbstractState fullState) throws CPAException, InterruptedException {
                PrecisionAdjustment.PrecisionAdjustmentResult wrappedPrec = lPrecisionAdjustment.prec(pState, pPrecision, pStates, fullState);
                if (((AutomatonState)pState).getInternalStateName().equals("_predefinedState_BREAK")) {
                    return wrappedPrec.withAction(PrecisionAdjustment.Action.BREAK);
                }
                return wrappedPrec;
            }
        };
        if (pAutomaton != null) {
            this.automaton = pAutomaton;
        } else {
            Scope scope;
            if (this.inputFile == null) {
                throw new InvalidConfigurationException("Explicitly specified automaton CPA needs option cpa.automaton.inputFile!");
            }
            Language language = pCFA.getLanguage();
            switch (language) {
                case C: {
                    scope = new CProgramScope(pCFA, pLogger);
                    break;
                }
                default: {
                    scope = DummyScope.getInstance();
                }
            }
            List<Automaton> lst = AutomatonParser.parseAutomatonFile(this.inputFile, pConfig, pLogger, pCFA.getMachineModel(), scope, language);
            if (lst.isEmpty()) {
                throw new InvalidConfigurationException("Could not find automata in the file " + this.inputFile.toAbsolutePath());
            }
            if (lst.size() > 1) {
                throw new InvalidConfigurationException("Found " + lst.size() + " automata in the File " + this.inputFile.toAbsolutePath() + " The CPA can only handle ONE Automaton!");
            }
            this.automaton = lst.get(0);
        }
        pLogger.log(Level.FINEST, new Object[]{"Automaton", this.automaton.getName(), "loaded."});
        if (this.export && this.exportFile != null) {
            try (Writer w = Files.openOutputFile((Path)this.exportFile.getPath(new Object[]{this.automaton.getName()}), (FileWriteMode[])new FileWriteMode[0]);){
                this.automaton.writeDotFile(w);
            }
            catch (IOException e) {
                pLogger.logUserException(Level.WARNING, (Throwable)e, "Could not write the automaton to DOT file");
            }
        }
        GlobalInfo.getInstance().storeAutomaton(this.automaton, this);
    }

    Automaton getAutomaton() {
        return this.automaton;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.automatonDomain;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return AutomatonState.automatonStateFactory(this.automaton.getInitialVariables(), this.automaton.getInitialState(), this, 0, 0, null);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public AutomatonTransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public Reducer getReducer() {
        return NoOpReducer.getInstance();
    }

    public AutomatonState getBottomState() {
        return this.bottomState;
    }

    public AutomatonState getTopState() {
        return this.topState;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        return pSuccessors.equals(this.getTransferRelation().getAbstractSuccessorsForEdge(pElement, SingletonPrecision.getInstance(), pCfaEdge));
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        return this.getAbstractDomain().isLessOrEqual(pElement, pOtherElement);
    }

    MachineModel getMachineModel() {
        return this.cfa.getMachineModel();
    }

    LogManager getLogManager() {
        return this.logger;
    }

    boolean isTreatingErrorsAsTargets() {
        return this.treatErrorsAsTargets;
    }
}

