/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Precisions;

public class ARGSubtreeRemover {
    private final BlockPartitioning partitioning;
    private final Reducer wrappedReducer;
    private final BAMCache bamCache;
    private final ReachedSetFactory reachedSetFactory;
    private final Map<AbstractState, ReachedSet> abstractStateToReachedSet;
    private final Timer removeCachedSubtreeTimer;
    private final LogManager logger;

    public ARGSubtreeRemover(BlockPartitioning partitioning, Reducer reducer, BAMCache bamCache, ReachedSetFactory reachedSetFactory, Map<AbstractState, ReachedSet> abstractStateToReachedSet, Timer removeCachedSubtreeTimer, LogManager logger) {
        this.partitioning = partitioning;
        this.wrappedReducer = reducer;
        this.bamCache = bamCache;
        this.reachedSetFactory = reachedSetFactory;
        this.abstractStateToReachedSet = abstractStateToReachedSet;
        this.removeCachedSubtreeTimer = removeCachedSubtreeTimer;
        this.logger = logger;
    }

    void removeSubtree(ARGReachedSet mainReachedSet, ARGPath pPath, ARGState element, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pNewPrecisionTypes, Map<ARGState, ARGState> pPathElementToReachedState) {
        List<ARGState> path = ARGSubtreeRemover.trimPath(pPath, element);
        assert (path.get(path.size() - 1).equals(element));
        assert (path.size() >= 2);
        List<ARGState> relevantCallNodes = this.getRelevantDefinitionNodes(path);
        assert (path.containsAll(relevantCallNodes)) : "only nodes of path are relevant";
        assert (relevantCallNodes.get(0) == path.get(0)) : "root should be relevant";
        assert (relevantCallNodes.size() >= 1) : "at least the main-function should be open at the target-state";
        LinkedHashSet<Pair<ARGState, ARGState>> neededRemoveCachedSubtreeCalls = new LinkedHashSet<Pair<ARGState, ARGState>>();
        for (int i = 0; i < relevantCallNodes.size() - 1; ++i) {
            ARGState pathElement = relevantCallNodes.get(i);
            ARGState nextElement = relevantCallNodes.get(i + 1);
            neededRemoveCachedSubtreeCalls.add((Pair<ARGState, ARGState>)Pair.of((Object)pPathElementToReachedState.get(pathElement), (Object)pPathElementToReachedState.get(nextElement)));
        }
        if (this.bamCache.doesAggressiveCaching()) {
            this.ensureExactCacheHitsOnPath(mainReachedSet, pPath, element, pNewPrecisions, pPathElementToReachedState, neededRemoveCachedSubtreeCalls);
        }
        ARGState lastRelevantNode = pPathElementToReachedState.get(Iterables.getLast(relevantCallNodes));
        ARGState target = pPathElementToReachedState.get(element);
        for (Pair pair : neededRemoveCachedSubtreeCalls) {
            List<Precision> newPrecisions;
            if (pair.getSecond() == lastRelevantNode) {
                newPrecisions = pNewPrecisions;
            } else {
                ReachedSet nextReachedSet = this.abstractStateToReachedSet.get(pair.getSecond());
                assert (nextReachedSet != null) : "call-state does not match reachedset";
                newPrecisions = target.getParents().contains(nextReachedSet.getFirstState()) ? pNewPrecisions : null;
            }
            this.removeCachedSubtree((ARGState)pair.getFirst(), (ARGState)pair.getSecond(), newPrecisions, pNewPrecisionTypes);
        }
        this.removeCachedSubtree(pPathElementToReachedState.get(Iterables.getLast(relevantCallNodes)), pPathElementToReachedState.get(element), pNewPrecisions, pNewPrecisionTypes);
        ARGState lastState = (ARGState)mainReachedSet.asReachedSet().getLastState();
        assert (lastState.isTarget());
        mainReachedSet.removeSubtree(lastState);
    }

    private static boolean removeSubtree(ReachedSet reachedSet, ARGState argElement, List<Precision> newPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) {
        ARGReachedSet argReachSet = new ARGReachedSet(reachedSet);
        boolean updateCacheNeeded = argElement.getParents().contains(reachedSet.getFirstState());
        ARGSubtreeRemover.removeSubtree(argReachSet, argElement, newPrecisions, pPrecisionTypes);
        return updateCacheNeeded;
    }

    static void removeSubtree(ARGReachedSet reachedSet, ARGState argElement) {
        if (BAMTransferRelation.isHeadOfMainFunction(AbstractStates.extractLocation(argElement))) {
            reachedSet.removeSubtree((ARGState)reachedSet.asReachedSet().getLastState());
        } else {
            reachedSet.removeSubtree(argElement);
        }
    }

    private static void removeSubtree(ARGReachedSet reachedSet, ARGState argElement, List<Precision> newPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) {
        if (newPrecisions == null || newPrecisions.size() == 0) {
            ARGSubtreeRemover.removeSubtree(reachedSet, argElement);
        } else {
            reachedSet.removeSubtree(argElement, newPrecisions, pPrecisionTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedSubtree(ARGState rootState, ARGState removeElement, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) {
        this.removeCachedSubtreeTimer.start();
        try {
            CFANode rootNode = AbstractStates.extractLocation(rootState);
            Block rootSubtree = this.partitioning.getBlockForCallNode(rootNode);
            this.logger.log(Level.FINER, new Object[]{"Remove cached subtree for", removeElement, "(rootNode: ", rootNode, ") issued with precision", pNewPrecisions});
            AbstractState reducedRootState = this.wrappedReducer.getVariableReducedState(rootState, rootSubtree, rootNode);
            ReachedSet reachedSet = this.abstractStateToReachedSet.get(rootState);
            if (removeElement.isDestroyed()) {
                this.logger.log(Level.FINER, new Object[]{"state was destroyed before"});
                return;
            }
            assert (reachedSet.contains(removeElement)) : "removing state from wrong reachedSet: " + removeElement;
            Precision removePrecision = reachedSet.getPrecision(removeElement);
            ArrayList<Precision> newReducedRemovePrecision = null;
            if (pNewPrecisions != null) {
                newReducedRemovePrecision = new ArrayList<Precision>(1);
                for (int i = 0; i < pNewPrecisions.size(); ++i) {
                    removePrecision = Precisions.replaceByType(removePrecision, pNewPrecisions.get(i), pPrecisionTypes.get(i));
                }
                newReducedRemovePrecision.add(this.wrappedReducer.getVariableReducedPrecision(removePrecision, rootSubtree));
                pPrecisionTypes = new ArrayList<Predicate<? super Precision>>();
                pPrecisionTypes.add((Predicate<? super Precision>)Predicates.instanceOf(((Precision)newReducedRemovePrecision.get(0)).getClass()));
            }
            assert (!removeElement.getParents().isEmpty());
            Precision reducedRootPrecision = reachedSet.getPrecision(reachedSet.getFirstState());
            this.bamCache.removeReturnEntry(reducedRootState, reducedRootPrecision, rootSubtree);
            this.bamCache.removeBlockEntry(reducedRootState, reducedRootPrecision, rootSubtree);
            this.logger.log(Level.FINEST, new Object[]{"Removing subtree, adding a new cached entry, and removing the former cached entries"});
            if (ARGSubtreeRemover.removeSubtree(reachedSet, removeElement, newReducedRemovePrecision, pPrecisionTypes)) {
                this.logger.log(Level.FINER, new Object[]{"updating cache"});
                this.bamCache.updatePrecisionForEntry(reducedRootState, reducedRootPrecision, rootSubtree, newReducedRemovePrecision.get(0));
            }
        }
        finally {
            this.removeCachedSubtreeTimer.stop();
        }
    }

    private List<ARGState> getRelevantDefinitionNodes(List<ARGState> path) {
        ArrayDeque<ARGState> openCallElements = new ArrayDeque<ARGState>();
        ArrayDeque<Block> openSubtrees = new ArrayDeque<Block>();
        ARGState lastState = path.get(path.size() - 1);
        for (ARGState pathState : path) {
            assert (openSubtrees.size() == openCallElements.size());
            CFANode node = AbstractStates.extractLocation(pathState);
            while (!openSubtrees.isEmpty() && ((Block)openSubtrees.getLast()).isReturnNode(node) && pathState != lastState) {
                openCallElements.removeLast();
                Block lastBlock = (Block)openSubtrees.removeLast();
                if (!BAMTransferRelation.isFunctionBlock(lastBlock)) continue;
                break;
            }
            if (!this.partitioning.isCallNode(node) || this.partitioning.getBlockForCallNode(node).equals(openSubtrees.peek())) continue;
            openCallElements.addLast(pathState);
            openSubtrees.addLast(this.partitioning.getBlockForCallNode(node));
        }
        return new ArrayList<ARGState>(openCallElements);
    }

    private void ensureExactCacheHitsOnPath(ARGReachedSet mainReachedSet, ARGPath pPath, ARGState pElement, List<Precision> pNewPrecisions, Map<ARGState, ARGState> pPathElementToReachedState, Set<Pair<ARGState, ARGState>> neededRemoveCachedSubtreeCalls) {
        HashMap<ARGState, UnmodifiableReachedSet> pathElementToOuterReachedSet = new HashMap<ARGState, UnmodifiableReachedSet>();
        Pair<Set<ARGState>, Set<ARGState>> pair = this.getCallAndReturnNodes(pPath, pathElementToOuterReachedSet, mainReachedSet.asReachedSet(), pPathElementToReachedState);
        Set callNodes = (Set)pair.getFirst();
        Set returnNodes = (Set)pair.getSecond();
        LinkedList<ARGState> remainingPathElements = new LinkedList<ARGState>((Collection<ARGState>)pPath.asStatesList());
        boolean starting = false;
        while (!remainingPathElements.isEmpty()) {
            ARGState currentElement = (ARGState)remainingPathElements.pop();
            if (currentElement.equals(pElement)) {
                starting = true;
            }
            if (!starting || !callNodes.contains(currentElement)) continue;
            ARGState currentReachedState = pPathElementToReachedState.get(currentElement);
            CFANode node = AbstractStates.extractLocation(currentReachedState);
            Block currentBlock = this.partitioning.getBlockForCallNode(node);
            AbstractState reducedState = this.wrappedReducer.getVariableReducedState(currentReachedState, currentBlock, node);
            this.removeUnpreciseCacheEntriesOnPath(currentElement, reducedState, pNewPrecisions, currentBlock, remainingPathElements, pPathElementToReachedState, callNodes, returnNodes, pathElementToOuterReachedSet, neededRemoveCachedSubtreeCalls);
        }
    }

    private Pair<Set<ARGState>, Set<ARGState>> getCallAndReturnNodes(ARGPath path, Map<ARGState, UnmodifiableReachedSet> pathElementToOuterReachedSet, UnmodifiableReachedSet mainReachedSet, Map<ARGState, ARGState> pPathElementToReachedState) {
        HashSet<ARGState> callNodes = new HashSet<ARGState>();
        HashSet<ARGState> returnNodes = new HashSet<ARGState>();
        ArrayDeque<Block> openSubtrees = new ArrayDeque<Block>();
        ArrayDeque<UnmodifiableReachedSet> openReachedSets = new ArrayDeque<UnmodifiableReachedSet>();
        openReachedSets.push(mainReachedSet);
        for (ARGState pathState : path.asStatesList()) {
            CFANode node = AbstractStates.extractLocation(pathState);
            while (!openSubtrees.isEmpty() && ((Block)openSubtrees.peek()).isReturnNode(node)) {
                openSubtrees.pop();
                openReachedSets.pop();
                returnNodes.add(pathState);
            }
            pathElementToOuterReachedSet.put(pathState, (UnmodifiableReachedSet)openReachedSets.peek());
            if (!this.partitioning.isCallNode(node) || this.partitioning.getBlockForCallNode(node).equals(openSubtrees.peek())) continue;
            openSubtrees.push(this.partitioning.getBlockForCallNode(node));
            openReachedSets.push(this.abstractStateToReachedSet.get(pPathElementToReachedState.get(pathState)));
            callNodes.add(pathState);
        }
        return Pair.of(callNodes, returnNodes);
    }

    private boolean removeUnpreciseCacheEntriesOnPath(ARGState rootState, AbstractState reducedRootState, List<Precision> pNewPrecisions, Block rootBlock, Deque<ARGState> remainingPathElements, Map<ARGState, ARGState> pPathElementToReachedState, Set<ARGState> callNodes, Set<ARGState> returnNodes, Map<ARGState, UnmodifiableReachedSet> pathElementToOuterReachedSet, Set<Pair<ARGState, ARGState>> neededRemoveCachedSubtreeCalls) {
        UnmodifiableReachedSet outerReachedSet = pathElementToOuterReachedSet.get(rootState);
        Precision rootPrecision = outerReachedSet.getPrecision(pPathElementToReachedState.get(rootState));
        for (Precision pNewPrecision : pNewPrecisions) {
            rootPrecision = Precisions.replaceByType(rootPrecision, pNewPrecision, (Predicate<? super Precision>)Predicates.instanceOf(pNewPrecision.getClass()));
        }
        Precision reducedNewPrecision = this.wrappedReducer.getVariableReducedPrecision(rootPrecision, rootBlock);
        UnmodifiableReachedSet innerReachedSet = this.abstractStateToReachedSet.get(pPathElementToReachedState.get(rootState));
        Precision usedPrecision = innerReachedSet.getPrecision(innerReachedSet.getFirstState());
        if (!this.bamCache.containsPreciseKey(reducedRootState, reducedNewPrecision, rootBlock)) {
            ReachedSet reachedSet = this.createInitialReachedSet(reducedRootState, reducedNewPrecision);
            this.bamCache.put(reducedRootState, reducedNewPrecision, rootBlock, reachedSet);
        }
        boolean isNewPrecisionEntry = usedPrecision.equals(reducedNewPrecision);
        boolean foundInnerUnpreciseEntries = false;
        while (!remainingPathElements.isEmpty()) {
            CFANode node;
            Block currentBlock;
            ARGState currentReachedState;
            AbstractState reducedState;
            boolean removedUnpreciseInnerBlock;
            ARGState currentElement = remainingPathElements.pop();
            if (callNodes.contains(currentElement) && (removedUnpreciseInnerBlock = this.removeUnpreciseCacheEntriesOnPath(currentElement, reducedState = this.wrappedReducer.getVariableReducedState(currentReachedState = pPathElementToReachedState.get(currentElement), currentBlock = this.partitioning.getBlockForCallNode(node = AbstractStates.extractLocation(currentReachedState)), node), pNewPrecisions, currentBlock, remainingPathElements, pPathElementToReachedState, callNodes, returnNodes, pathElementToOuterReachedSet, neededRemoveCachedSubtreeCalls)) && isNewPrecisionEntry && !foundInnerUnpreciseEntries) {
                neededRemoveCachedSubtreeCalls.add((Pair<ARGState, ARGState>)Pair.of((Object)pPathElementToReachedState.get(rootState), (Object)currentReachedState));
                foundInnerUnpreciseEntries = true;
            }
            if (!returnNodes.contains(currentElement)) continue;
            return foundInnerUnpreciseEntries || !isNewPrecisionEntry;
        }
        return foundInnerUnpreciseEntries || !isNewPrecisionEntry;
    }

    private ReachedSet createInitialReachedSet(AbstractState initialState, Precision initialPredicatePrecision) {
        ReachedSet reached = this.reachedSetFactory.create();
        reached.add(initialState, initialPredicatePrecision);
        return reached;
    }

    private static List<ARGState> trimPath(ARGPath pPath, ARGState pState) {
        ArrayList<ARGState> result = new ArrayList<ARGState>();
        for (ARGState state : pPath.asStatesList()) {
            result.add(state);
            if (!state.equals(pState)) continue;
            return result;
        }
        throw new IllegalArgumentException("State " + pState + " could not be found in path " + pPath + ".");
    }
}

