/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.bam.BAMCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public abstract class AbstractBAMBasedRefiner
extends AbstractARGBasedRefiner {
    final Timer computePathTimer = new Timer();
    final Timer computeSubtreeTimer = new Timer();
    final Timer computeCounterexampleTimer = new Timer();
    private final BAMTransferRelation transfer;
    private final Map<ARGState, ARGState> pathStateToReachedState = new HashMap<ARGState, ARGState>();
    static final BAMCEXSubgraphComputer.BackwardARGState DUMMY_STATE_FOR_MISSING_BLOCK = new BAMCEXSubgraphComputer.BackwardARGState(new ARGState(null, null));

    protected AbstractBAMBasedRefiner(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        super(pCpa);
        BAMCPA bamCpa = (BAMCPA)pCpa;
        this.transfer = bamCpa.getTransferRelation();
        bamCpa.getStatistics().addRefiner(this);
    }

    protected abstract CounterexampleInfo performRefinement0(ARGReachedSet var1, ARGPath var2) throws CPAException, InterruptedException;

    @Override
    protected final CounterexampleInfo performRefinement(ARGReachedSet pReached, ARGPath pPath) throws CPAException, InterruptedException {
        assert (pPath == null || pPath.size() > 0);
        if (pPath == null) {
            return CounterexampleInfo.spurious();
        }
        return this.performRefinement0(new BAMReachedSet(this.transfer, pReached, pPath, this.pathStateToReachedState), pPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ARGPath computePath(ARGState pLastElement, ARGReachedSet pReachedSet) throws InterruptedException, CPATransferException {
        assert (pLastElement.isTarget());
        this.pathStateToReachedState.clear();
        this.computePathTimer.start();
        try {
            ARGPath aRGPath;
            ARGState subgraph;
            this.computeSubtreeTimer.start();
            try {
                subgraph = this.transfer.computeCounterexampleSubgraph(pLastElement, pReachedSet, this.pathStateToReachedState);
                if (subgraph == DUMMY_STATE_FOR_MISSING_BLOCK) {
                    ARGPath aRGPath2 = null;
                    return aRGPath2;
                }
            }
            finally {
                this.computeSubtreeTimer.stop();
            }
            this.computeCounterexampleTimer.start();
            try {
                aRGPath = ARGUtils.getRandomPath(subgraph);
            }
            catch (Throwable throwable) {
                this.computeCounterexampleTimer.stop();
                throw throwable;
            }
            this.computeCounterexampleTimer.stop();
            return aRGPath;
        }
        finally {
            this.computePathTimer.stop();
        }
    }

    private static class BAMReachedSet
    extends ARGReachedSet.ForwardingARGReachedSet {
        private final BAMTransferRelation transfer;
        private final ARGPath path;
        private final Map<ARGState, ARGState> pathStateToReachedState;

        private BAMReachedSet(BAMTransferRelation pTransfer, ARGReachedSet pReached, ARGPath pPath, Map<ARGState, ARGState> pPathElementToReachedState) {
            super(pReached);
            this.transfer = pTransfer;
            this.path = pPath;
            this.pathStateToReachedState = pPathElementToReachedState;
        }

        @Override
        public void removeSubtree(ARGState element, Precision newPrecision, Predicate<? super Precision> pPrecisionType) {
            ArrayList<Precision> listP = new ArrayList<Precision>();
            listP.add(newPrecision);
            ArrayList<Predicate<? super Precision>> listPT = new ArrayList<Predicate<? super Precision>>();
            listPT.add(pPrecisionType);
            this.removeSubtree(element, listP, listPT);
        }

        @Override
        public void removeSubtree(ARGState element, List<Precision> newPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) {
            Preconditions.checkArgument((newPrecisions.size() == pPrecisionTypes.size() ? 1 : 0) != 0);
            this.transfer.removeSubtree(this.delegate, this.path, element, newPrecisions, pPrecisionTypes, this.pathStateToReachedState);
        }

        @Override
        public void removeSubtree(ARGState pE) {
            throw new UnsupportedOperationException();
        }
    }
}

