/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGBlockStartState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;

class BAMARGUtils {
    private BAMARGUtils() {
    }

    public static Multimap<Block, ReachedSet> gatherReachedSets(BAMCPA cpa, ReachedSet finalReachedSet) {
        HashMultimap result = HashMultimap.create();
        BAMARGUtils.gatherReachedSets(cpa, cpa.getBlockPartitioning().getMainBlock(), finalReachedSet, (Multimap<Block, ReachedSet>)result);
        return result;
    }

    private static void gatherReachedSets(BAMCPA cpa, Block block, ReachedSet reachedSet, Multimap<Block, ReachedSet> blockToReachedSet) {
        if (blockToReachedSet.containsEntry((Object)block, (Object)reachedSet)) {
            return;
        }
        blockToReachedSet.put((Object)block, (Object)reachedSet);
        ARGState firstElement = (ARGState)reachedSet.getFirstState();
        LinkedList<ARGState> worklist = new LinkedList<ARGState>();
        HashSet<ARGState> processed = new HashSet<ARGState>();
        worklist.add(firstElement);
        while (worklist.size() != 0) {
            ARGState currentElement = (ARGState)worklist.removeLast();
            assert (reachedSet.contains(currentElement));
            if (processed.contains(currentElement)) continue;
            processed.add(currentElement);
            for (ARGState child : currentElement.getChildren()) {
                CFAEdge edge = currentElement.getEdgeToChild(child);
                if (edge == null) {
                    Pair<Block, ReachedSet> pair = cpa.getTransferRelation().getCachedReachedSet(currentElement, reachedSet.getPrecision(currentElement));
                    BAMARGUtils.gatherReachedSets(cpa, (Block)pair.getFirst(), (ReachedSet)pair.getSecond(), blockToReachedSet);
                }
                if (worklist.contains(child) || !reachedSet.contains(child)) continue;
                worklist.add(child);
            }
        }
    }

    public static ARGState copyARG(ARGState pRoot) {
        HashMap<ARGState, ARGState> stateToCopyElem = new HashMap<ARGState, ARGState>();
        HashSet<ARGState> visited = new HashSet<ARGState>();
        Stack<ARGState> toVisit = new Stack<ARGState>();
        visited.add(pRoot);
        toVisit.add(pRoot);
        while (!toVisit.isEmpty()) {
            ARGState copyStateInner;
            ARGState copyState;
            ARGState current = (ARGState)toVisit.pop();
            if (stateToCopyElem.get(current) == null) {
                copyState = BAMARGUtils.copyNode(current);
                stateToCopyElem.put(current, copyState);
            } else {
                copyState = (ARGState)stateToCopyElem.get(current);
            }
            for (ARGState c : current.getChildren()) {
                if (stateToCopyElem.get(c) == null) {
                    copyStateInner = BAMARGUtils.copyNode(c);
                    stateToCopyElem.put(c, copyStateInner);
                } else {
                    copyStateInner = (ARGState)stateToCopyElem.get(c);
                }
                copyStateInner.addParent(copyState);
                if (visited.contains(c)) continue;
                visited.add(c);
                toVisit.add(c);
            }
            if (!current.isCovered()) continue;
            if (stateToCopyElem.get(current.getCoveringState()) == null) {
                copyStateInner = BAMARGUtils.copyNode(current.getCoveringState());
                stateToCopyElem.put(current.getCoveringState(), copyStateInner);
            } else {
                copyStateInner = (ARGState)stateToCopyElem.get(current.getCoveringState());
            }
            if (!visited.contains(current.getCoveringState())) {
                visited.add(current.getCoveringState());
                toVisit.add(current.getCoveringState());
            }
            copyState.setCovered(copyStateInner);
        }
        return (ARGState)stateToCopyElem.get(pRoot);
    }

    private static ARGState copyNode(ARGState toCopy) {
        ARGState copyState;
        if (toCopy instanceof BAMARGBlockStartState) {
            copyState = new BAMARGBlockStartState(toCopy.getWrappedState(), null);
            ((BAMARGBlockStartState)copyState).setAnalyzedBlock(((BAMARGBlockStartState)toCopy).getAnalyzedBlock());
        } else {
            copyState = new ARGState(toCopy.getWrappedState(), null);
        }
        return copyState;
    }
}

