/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.ARGSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMBasedRefiner;
import org.sosy_lab.cpachecker.cpa.bam.BAMCache;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class BAMCEXSubgraphComputer {
    private final BlockPartitioning partitioning;
    private final Reducer reducer;
    private final BAMCache bamCache;
    private final Map<ARGState, ARGState> pathStateToReachedState;
    private final Map<AbstractState, ReachedSet> abstractStateToReachedSet;
    private final Map<AbstractState, AbstractState> expandedToReducedCache;
    private final LogManager logger;

    BAMCEXSubgraphComputer(BlockPartitioning partitioning, Reducer reducer, BAMCache bamCache, Map<ARGState, ARGState> pathStateToReachedState, Map<AbstractState, ReachedSet> abstractStateToReachedSet, Map<AbstractState, AbstractState> expandedToReducedCache, LogManager logger) {
        this.partitioning = partitioning;
        this.reducer = reducer;
        this.bamCache = bamCache;
        this.pathStateToReachedState = pathStateToReachedState;
        this.abstractStateToReachedSet = abstractStateToReachedSet;
        this.expandedToReducedCache = expandedToReducedCache;
        this.logger = logger;
    }

    BackwardARGState computeCounterexampleSubgraph(ARGState target, ARGReachedSet reachedSet, BackwardARGState newTreeTarget) {
        assert (reachedSet.asReachedSet().contains(target));
        HashMap<ARGState, BackwardARGState> finishedStates = new HashMap<ARGState, BackwardARGState>();
        TreeSet<ARGState> waitlist = new TreeSet<ARGState>();
        BackwardARGState root = null;
        this.pathStateToReachedState.put(newTreeTarget, target);
        finishedStates.put(target, newTreeTarget);
        waitlist.addAll(target.getParents());
        while (!waitlist.isEmpty()) {
            ARGState currentState = (ARGState)waitlist.pollLast();
            assert (reachedSet.asReachedSet().contains(currentState));
            if (finishedStates.containsKey(currentState)) continue;
            BackwardARGState newCurrentState = new BackwardARGState(currentState);
            finishedStates.put(currentState, newCurrentState);
            this.pathStateToReachedState.put(newCurrentState, currentState);
            waitlist.addAll(currentState.getParents());
            for (ARGState child : currentState.getChildren()) {
                if (!finishedStates.containsKey(child)) continue;
                BackwardARGState newChild = (BackwardARGState)finishedStates.get(child);
                if (this.expandedToReducedCache.containsKey(child)) {
                    ARGState reducedTarget = (ARGState)this.expandedToReducedCache.get(child);
                    BackwardARGState innerTree = this.computeCounterexampleSubgraphForBlock(currentState, reducedTarget, newChild);
                    if (innerTree == AbstractBAMBasedRefiner.DUMMY_STATE_FOR_MISSING_BLOCK) {
                        ARGSubtreeRemover.removeSubtree(reachedSet, currentState);
                        return AbstractBAMBasedRefiner.DUMMY_STATE_FOR_MISSING_BLOCK;
                    }
                    for (ARGState innerChild : innerTree.getChildren()) {
                        innerChild.addParent(newCurrentState);
                    }
                    innerTree.removeFromARG();
                    assert (this.pathStateToReachedState.containsKey(innerTree)) : "root of subgraph was not finished";
                    this.pathStateToReachedState.remove(innerTree);
                    assert (this.pathStateToReachedState.containsKey(newChild)) : "end of subgraph was not handled";
                    assert (this.pathStateToReachedState.get(newCurrentState) == currentState) : "callstate must be from outer reachedset";
                    continue;
                }
                assert (currentState.getEdgeToChild(child) != null) : "unexpected ARG state: parent has no edge to child.";
                newChild.addParent(newCurrentState);
            }
            if (!currentState.getParents().isEmpty()) continue;
            assert (root == null) : "root should not be set before";
            root = newCurrentState;
        }
        assert (root != null);
        return root;
    }

    private BackwardARGState computeCounterexampleSubgraphForBlock(ARGState expandedRoot, ARGState reducedTarget, BackwardARGState newTreeTarget) {
        if (reducedTarget.isDestroyed()) {
            this.logger.log(Level.FINE, new Object[]{"Target state refers to a destroyed ARGState, i.e., the cached subtree is outdated. Updating it."});
            return AbstractBAMBasedRefiner.DUMMY_STATE_FOR_MISSING_BLOCK;
        }
        ReachedSet reachedSet = this.abstractStateToReachedSet.get(expandedRoot);
        assert (reachedSet.contains(reducedTarget));
        BackwardARGState result = this.computeCounterexampleSubgraph(reducedTarget, new ARGReachedSet(reachedSet), newTreeTarget);
        if (result == AbstractBAMBasedRefiner.DUMMY_STATE_FOR_MISSING_BLOCK) {
            this.logger.log(Level.FINE, new Object[]{"Target state refers to a destroyed ARGState, i.e., the cached subtree will be removed."});
            CFANode rootNode = AbstractStates.extractLocation(expandedRoot);
            Block rootBlock = this.partitioning.getBlockForCallNode(rootNode);
            AbstractState reducedRootState = this.reducer.getVariableReducedState(expandedRoot, rootBlock, rootNode);
            this.bamCache.removeReturnEntry(reducedRootState, reachedSet.getPrecision(reachedSet.getFirstState()), rootBlock);
        }
        return result;
    }

    static class BackwardARGState
    extends ARGState {
        private static final long serialVersionUID = -3279533907385516993L;
        private int decreasingStateID = nextDecreaseID--;
        private static int nextDecreaseID = Integer.MAX_VALUE;

        public BackwardARGState(ARGState originalState) {
            super(originalState.getWrappedState(), null);
        }

        @Override
        public boolean isOlderThan(ARGState other) {
            if (other instanceof BackwardARGState) {
                return this.decreasingStateID < ((BackwardARGState)other).decreasingStateID;
            }
            return super.isOlderThan(other);
        }

        void updateDecreaseId() {
            this.decreasingStateID = nextDecreaseID--;
        }
    }
}

