/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.BlockToDotWriter;
import org.sosy_lab.cpachecker.cfa.blocks.builder.FunctionAndLoopPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAStatistics;
import org.sosy_lab.cpachecker.cpa.bam.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.BAMMergeOperator;
import org.sosy_lab.cpachecker.cpa.bam.BAMPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.bam.BAMStopOperator;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.TimedReducer;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.bam")
public class BAMCPA
extends AbstractSingleWrapperCPA
implements StatisticsProvider,
ProofChecker {
    private BlockPartitioning blockPartitioning;
    private final LogManager logger;
    private final TimedReducer reducer;
    private final BAMTransferRelation transfer;
    private final BAMPrecisionAdjustment prec;
    private final BAMMergeOperator merge;
    private final BAMStopOperator stop;
    private final BAMCPAStatistics stats;
    private final PartitioningHeuristic heuristic;
    private final CFA cfa;
    private final ProofChecker wrappedProofChecker;
    @Option(secure=true, description="Type of partitioning (FunctionAndLoopPartitioning or DelayedFunctionAndLoopPartitioning)\nor any class that implements a PartitioningHeuristic")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker.cfa.blocks.builder"})
    private Class<? extends PartitioningHeuristic> blockHeuristic = FunctionAndLoopPartitioning.class;
    @Option(secure=true, description="export blocks")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportBlocksPath = Paths.get((String)"block_cfa.dot", (String[])new String[0]);

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(BAMCPA.class);
    }

    public BAMCPA(ConfigurableProgramAnalysis pCpa, Configuration config, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException, CPAException {
        super(pCpa);
        config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCfa;
        if (!(pCpa instanceof ConfigurableProgramAnalysisWithBAM)) {
            throw new InvalidConfigurationException("BAM needs CPAs that are capable for BAM");
        }
        Reducer wrappedReducer = ((ConfigurableProgramAnalysisWithBAM)pCpa).getReducer();
        if (wrappedReducer == null) {
            throw new InvalidConfigurationException("BAM needs CPAs that are capable for BAM");
        }
        this.wrappedProofChecker = pCpa instanceof ProofChecker ? (ProofChecker)((Object)pCpa) : null;
        this.reducer = new TimedReducer(wrappedReducer);
        BAMCache cache = new BAMCache(config, this.reducer);
        this.transfer = new BAMTransferRelation(config, this.logger, this, this.wrappedProofChecker, cache, pReachedSetFactory, pShutdownNotifier);
        this.prec = new BAMPrecisionAdjustment(pCpa.getPrecisionAdjustment(), this.transfer, this.logger);
        this.merge = new BAMMergeOperator(pCpa.getMergeOperator(), this.transfer);
        this.stop = new BAMStopOperator(pCpa.getStopOperator(), this.transfer);
        this.stats = new BAMCPAStatistics(this, cache, config, this.logger);
        this.heuristic = this.getPartitioningHeuristic();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        if (this.blockPartitioning == null) {
            this.blockPartitioning = this.heuristic.buildPartitioning(pNode);
            if (this.exportBlocksPath != null) {
                BlockToDotWriter writer = new BlockToDotWriter(this.blockPartitioning);
                writer.dump(this.exportBlocksPath, this.logger);
            }
            this.transfer.setBlockPartitioning(this.blockPartitioning);
            BAMPredicateCPA predicateCpa = ((WrapperCPA)((Object)this.getWrappedCpa())).retrieveWrappedCpa(BAMPredicateCPA.class);
            if (predicateCpa != null) {
                predicateCpa.setPartitioning(this.blockPartitioning);
            }
            HashMap<AbstractState, Precision> forwardPrecisionToExpandedPrecision = new HashMap<AbstractState, Precision>();
            this.transfer.setForwardPrecisionToExpandedPrecision(forwardPrecisionToExpandedPrecision);
            this.prec.setForwardPrecisionToExpandedPrecision(forwardPrecisionToExpandedPrecision);
        }
        return this.getWrappedCpa().getInitialState(pNode, pPartition);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.getWrappedCpa().getInitialPrecision(pNode, pPartition);
    }

    private PartitioningHeuristic getPartitioningHeuristic() throws CPAException, InvalidConfigurationException {
        return (PartitioningHeuristic)Classes.createInstance(PartitioningHeuristic.class, this.blockHeuristic, (Class[])new Class[]{LogManager.class, CFA.class}, (Object[])new Object[]{this.logger, this.cfa}, CPAException.class);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.getWrappedCpa().getAbstractDomain();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public BAMPrecisionAdjustment getPrecisionAdjustment() {
        return this.prec;
    }

    @Override
    public BAMTransferRelation getTransferRelation() {
        return this.transfer;
    }

    TimedReducer getReducer() {
        return this.reducer;
    }

    @Override
    protected ConfigurableProgramAnalysis getWrappedCpa() {
        return super.getWrappedCpa();
    }

    BlockPartitioning getBlockPartitioning() {
        Preconditions.checkState((this.blockPartitioning != null ? 1 : 0) != 0);
        return this.blockPartitioning;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        super.collectStatistics(pStatsCollection);
    }

    BAMCPAStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.transfer.areAbstractSuccessors(pState, pCfaEdge, pSuccessors);
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.wrappedProofChecker.isCoveredBy(pState, pOtherState);
    }
}

