/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMBasedRefiner;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGUtils;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.TimedReducer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cpa.bam")
class BAMCPAStatistics
implements Statistics {
    @Option(secure=true, description="export blocked ARG as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path argFile = Paths.get((String)"BlockedARG.dot", (String[])new String[0]);
    @Option(secure=true, description="export single blocked ARG as .dot files, should contain '%d'")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate indexedArgFile = PathTemplate.ofFormatString((String)"ARGs/ARG_%d.dot");
    @Option(secure=true, description="export used parts of blocked ARG as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path simplifiedArgFile = Paths.get((String)"BlockedARGSimplified.dot", (String[])new String[0]);
    private final Predicate<Pair<ARGState, ARGState>> highlightSummaryEdge = new Predicate<Pair<ARGState, ARGState>>(){

        public boolean apply(Pair<ARGState, ARGState> input) {
            CFAEdge edge = ((ARGState)input.getFirst()).getEdgeToChild((ARGState)input.getSecond());
            return edge instanceof FunctionSummaryEdge;
        }
    };
    private final BAMCPA cpa;
    private final BAMCache cache;
    private AbstractBAMBasedRefiner refiner = null;
    private final LogManager logger;

    public BAMCPAStatistics(BAMCPA cpa, BAMCache cache, Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cpa = cpa;
        this.cache = cache;
        this.logger = logger;
    }

    @Override
    public String getName() {
        return "BAMCPA";
    }

    public void addRefiner(AbstractBAMBasedRefiner pRefiner) {
        Preconditions.checkState((this.refiner == null ? 1 : 0) != 0);
        this.refiner = pRefiner;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        BAMTransferRelation transferRelation = this.cpa.getTransferRelation();
        TimedReducer reducer = this.cpa.getReducer();
        int sumCalls = this.cache.cacheMisses + this.cache.partialCacheHits + this.cache.fullCacheHits;
        int sumARTElemets = 0;
        for (ReachedSet subreached : BAMARGUtils.gatherReachedSets(this.cpa, reached).values()) {
            sumARTElemets += subreached.size();
        }
        out.println("Total size of all ARGs:                                         " + sumARTElemets);
        out.println("Maximum block depth:                                            " + transferRelation.maxRecursiveDepth);
        out.println("Total number of recursive CPA calls:                            " + sumCalls);
        out.println("  Number of cache misses:                                       " + this.cache.cacheMisses + " (" + StatisticsUtils.toPercent(this.cache.cacheMisses, sumCalls) + " of all calls)");
        out.println("  Number of partial cache hits:                                 " + this.cache.partialCacheHits + " (" + StatisticsUtils.toPercent(this.cache.partialCacheHits, sumCalls) + " of all calls)");
        out.println("  Number of full cache hits:                                    " + this.cache.fullCacheHits + " (" + StatisticsUtils.toPercent(this.cache.fullCacheHits, sumCalls) + " of all calls)");
        if (this.cache.gatherCacheMissStatistics) {
            out.println("Cause for cache misses:                                         ");
            out.println("  Number of abstraction caused misses:                          " + this.cache.abstractionCausedMisses + " (" + StatisticsUtils.toPercent(this.cache.abstractionCausedMisses, this.cache.cacheMisses) + " of all misses)");
            out.println("  Number of precision caused misses:                            " + this.cache.precisionCausedMisses + " (" + StatisticsUtils.toPercent(this.cache.precisionCausedMisses, this.cache.cacheMisses) + " of all misses)");
            out.println("  Number of misses with no similar elements:                    " + this.cache.noSimilarCausedMisses + " (" + StatisticsUtils.toPercent(this.cache.noSimilarCausedMisses, this.cache.cacheMisses) + " of all misses)");
        }
        out.println("Time for reducing abstract states:                            " + reducer.reduceTime + " (Calls: " + reducer.reduceTime.getNumberOfIntervals() + ")");
        out.println("Time for expanding abstract states:                           " + reducer.expandTime + " (Calls: " + reducer.expandTime.getNumberOfIntervals() + ")");
        out.println("Time for checking equality of abstract states:                " + this.cache.equalsTimer + " (Calls: " + this.cache.equalsTimer.getNumberOfIntervals() + ")");
        out.println("Time for computing the hashCode of abstract states:           " + this.cache.hashingTimer + " (Calls: " + this.cache.hashingTimer.getNumberOfIntervals() + ")");
        out.println("Time for searching for similar cache entries:                   " + this.cache.searchingTimer + " (Calls: " + this.cache.searchingTimer.getNumberOfIntervals() + ")");
        out.println("Time for reducing precisions:                                   " + reducer.reducePrecisionTime + " (Calls: " + reducer.reducePrecisionTime.getNumberOfIntervals() + ")");
        out.println("Time for expanding precisions:                                  " + reducer.expandPrecisionTime + " (Calls: " + reducer.expandPrecisionTime.getNumberOfIntervals() + ")");
        out.println("Time for removing cached subtrees for refinement:               " + transferRelation.removeCachedSubtreeTimer);
        out.println("Time for recomputing ARGs during counterexample analysis:       " + transferRelation.recomputeARTTimer);
        if (this.refiner != null) {
            out.println("Compute path for refinement:                                    " + this.refiner.computePathTimer);
            out.println("  Constructing flat ARG:                                        " + this.refiner.computeSubtreeTimer);
            out.println("  Searching path to error location:                             " + this.refiner.computeCounterexampleTimer);
        }
        Collection<ReachedSet> cachedStates = this.cache.getAllCachedReachedStates();
        for (ReachedSet set : cachedStates) {
            for (AbstractState state : set.asCollection()) {
                reached.add(state, set.getPrecision(state));
                reached.removeOnlyFromWaitlist(state);
            }
        }
        this.exportAllReachedSets(this.argFile, this.indexedArgFile, reached);
        this.exportUsedReachedSets(this.simplifiedArgFile, reached);
    }

    private void exportAllReachedSets(Path superArgFile, PathTemplate indexedFile, UnmodifiableReachedSet mainReachedSet) {
        if (superArgFile != null) {
            HashSet<UnmodifiableReachedSet> allReachedSets = new HashSet<UnmodifiableReachedSet>();
            allReachedSets.addAll(this.cache.getAllCachedReachedStates());
            allReachedSets.add(mainReachedSet);
            HashSet<ARGState> rootStates = new HashSet<ARGState>();
            HashMultimap connections = HashMultimap.create();
            for (UnmodifiableReachedSet reachedSet : allReachedSets) {
                ARGState rootState = (ARGState)reachedSet.getFirstState();
                rootStates.add(rootState);
                HashMultimap localConnections = HashMultimap.create();
                this.getConnections(rootState, (Multimap<ARGState, ARGState>)localConnections);
                connections.putAll((Multimap)localConnections);
                this.writeArg(indexedFile.getPath(new Object[]{((ARGState)reachedSet.getFirstState()).getStateId()}), (Multimap<ARGState, ARGState>)localConnections, Collections.singleton((ARGState)reachedSet.getFirstState()));
            }
            this.writeArg(superArgFile, (Multimap<ARGState, ARGState>)connections, rootStates);
        }
    }

    private void exportUsedReachedSets(Path superArgFile, UnmodifiableReachedSet mainReachedSet) {
        if (superArgFile != null) {
            HashMultimap connections = HashMultimap.create();
            Set<ARGState> rootStates = this.getUsedRootStates(mainReachedSet, (Multimap<ARGState, ARGState>)connections);
            this.writeArg(superArgFile, (Multimap<ARGState, ARGState>)connections, rootStates);
        }
    }

    private void writeArg(Path file, Multimap<ARGState, ARGState> connections, Set<ARGState> rootStates) {
        try (Writer w = Files.openOutputFile((Path)file, (FileWriteMode[])new FileWriteMode[0]);){
            ARGToDotWriter.write(w, rootStates, connections, ARGUtils.CHILDREN_OF_STATE, (Predicate<? super ARGState>)Predicates.alwaysTrue(), this.highlightSummaryEdge);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, String.format("Could not write ARG to file: %s", file));
        }
    }

    private Set<ARGState> getUsedRootStates(UnmodifiableReachedSet mainReachedSet, Multimap<ARGState, ARGState> connections) {
        HashSet<UnmodifiableReachedSet> finished = new HashSet<UnmodifiableReachedSet>();
        ArrayDeque<UnmodifiableReachedSet> waitlist = new ArrayDeque<UnmodifiableReachedSet>();
        waitlist.add(mainReachedSet);
        while (!waitlist.isEmpty()) {
            UnmodifiableReachedSet reachedSet = (UnmodifiableReachedSet)waitlist.pop();
            if (!finished.add(reachedSet)) continue;
            ARGState rootState = (ARGState)reachedSet.getFirstState();
            Set<ReachedSet> referencedReachedSets = this.getConnections(rootState, connections);
            waitlist.addAll(referencedReachedSets);
        }
        HashSet<ARGState> rootStates = new HashSet<ARGState>();
        for (UnmodifiableReachedSet reachedSet : finished) {
            rootStates.add((ARGState)reachedSet.getFirstState());
        }
        return rootStates;
    }

    private Set<ReachedSet> getConnections(ARGState rootState, Multimap<ARGState, ARGState> connections) {
        HashSet<ReachedSet> referencedReachedSets = new HashSet<ReachedSet>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(rootState);
        while (!waitlist.isEmpty()) {
            ARGState state = (ARGState)waitlist.pop();
            if (!finished.add(state)) continue;
            if (this.cpa.getTransferRelation().abstractStateToReachedSet.containsKey(state)) {
                ReachedSet target = this.cpa.getTransferRelation().abstractStateToReachedSet.get(state);
                referencedReachedSets.add(target);
                ARGState targetState = (ARGState)target.getFirstState();
                connections.put((Object)state, (Object)targetState);
            }
            if (this.cpa.getTransferRelation().expandedToReducedCache.containsKey(state)) {
                AbstractState sourceState = this.cpa.getTransferRelation().expandedToReducedCache.get(state);
                connections.put((Object)((ARGState)sourceState), (Object)state);
            }
            waitlist.addAll(state.getChildren());
        }
        return referencedReachedSets;
    }
}

