/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;

@Options(prefix="cpa.bam")
public class BAMCache {
    @Option(secure=true, description="if enabled, cache queries also consider blocks with non-matching precision for reuse.")
    private boolean aggressiveCaching = true;
    @Option(secure=true, description="if enabled, the reached set cache is analysed for each cache miss to find the cause of the miss.")
    boolean gatherCacheMissStatistics = false;
    final Timer hashingTimer = new Timer();
    final Timer equalsTimer = new Timer();
    final Timer searchingTimer = new Timer();
    int cacheMisses = 0;
    int partialCacheHits = 0;
    int fullCacheHits = 0;
    int abstractionCausedMisses = 0;
    int precisionCausedMisses = 0;
    int noSimilarCausedMisses = 0;
    private final Map<AbstractStateHash, ReachedSet> preciseReachedCache = new HashMap<AbstractStateHash, ReachedSet>();
    private final Map<AbstractStateHash, ReachedSet> unpreciseReachedCache = new HashMap<AbstractStateHash, ReachedSet>();
    private final Map<AbstractStateHash, Collection<AbstractState>> returnCache = new HashMap<AbstractStateHash, Collection<AbstractState>>();
    private final Map<AbstractStateHash, ARGState> blockARGCache = new HashMap<AbstractStateHash, ARGState>();
    private ARGState lastAnalyzedBlock = null;
    private final Reducer reducer;

    public BAMCache(Configuration config, Reducer reducer) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.reducer = reducer;
    }

    public boolean doesAggressiveCaching() {
        return this.aggressiveCaching;
    }

    private AbstractStateHash getHashCode(AbstractState stateKey, Precision precisionKey, Block context) {
        return new AbstractStateHash(stateKey, precisionKey, context);
    }

    public void put(AbstractState stateKey, Precision precisionKey, Block context, ReachedSet item) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        assert (!this.preciseReachedCache.containsKey(hash));
        this.preciseReachedCache.put(hash, item);
    }

    public void put(AbstractState stateKey, Precision precisionKey, Block context, Collection<AbstractState> item, ARGState rootOfBlock) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        assert (this.preciseReachedCache.get(hash) != null) : "key not found in cache";
        assert (this.allStatesContainedInReachedSet(item, this.preciseReachedCache.get(hash))) : "output-states must be in reached-set";
        this.returnCache.put(hash, item);
        this.blockARGCache.put(hash, rootOfBlock);
        this.setLastAnalyzedBlock(hash);
    }

    private boolean allStatesContainedInReachedSet(Collection<AbstractState> pElements, ReachedSet reached) {
        for (AbstractState e : pElements) {
            if (reached.contains(e)) continue;
            return false;
        }
        return true;
    }

    public void removeReturnEntry(AbstractState stateKey, Precision precisionKey, Block context) {
        this.returnCache.remove(this.getHashCode(stateKey, precisionKey, context));
    }

    public void removeBlockEntry(AbstractState stateKey, Precision precisionKey, Block context) {
        this.blockARGCache.remove(this.getHashCode(stateKey, precisionKey, context));
    }

    public Pair<ReachedSet, Collection<AbstractState>> get(AbstractState stateKey, Precision precisionKey, Block context) {
        Pair<ReachedSet, Collection<AbstractState>> pair = this.get0(stateKey, precisionKey, context);
        Preconditions.checkNotNull(pair);
        ReachedSet reached = (ReachedSet)pair.getFirst();
        Collection returnStates = (Collection)pair.getSecond();
        if (reached != null && returnStates != null) {
            ++this.fullCacheHits;
        } else if (reached != null) {
            ++this.partialCacheHits;
        } else if (returnStates == null) {
            ++this.cacheMisses;
            if (this.gatherCacheMissStatistics) {
                this.findCacheMissCause(stateKey, precisionKey, context);
            }
        } else {
            throw new AssertionError((Object)("invalid return-value for BAMCache.get(): " + pair));
        }
        return pair;
    }

    private Pair<ReachedSet, Collection<AbstractState>> get0(AbstractState stateKey, Precision precisionKey, Block context) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        ReachedSet result = this.preciseReachedCache.get(hash);
        if (result != null) {
            this.setLastAnalyzedBlock(hash);
            return Pair.of((Object)result, this.returnCache.get(hash));
        }
        if (this.aggressiveCaching) {
            result = this.unpreciseReachedCache.get(hash);
            if (result != null) {
                AbstractStateHash unpreciseHash = this.getHashCode(stateKey, result.getPrecision(result.getFirstState()), context);
                this.setLastAnalyzedBlock(unpreciseHash);
                return Pair.of((Object)result, this.returnCache.get(unpreciseHash));
            }
            Pair<ReachedSet, Collection<AbstractState>> pair = this.lookForSimilarState(stateKey, precisionKey, context);
            if (pair != null) {
                this.unpreciseReachedCache.put(hash, (ReachedSet)pair.getFirst());
                this.setLastAnalyzedBlock(this.getHashCode(stateKey, ((ReachedSet)pair.getFirst()).getPrecision(((ReachedSet)pair.getFirst()).getFirstState()), context));
                return pair;
            }
        }
        this.lastAnalyzedBlock = null;
        return Pair.of(null, null);
    }

    private void setLastAnalyzedBlock(AbstractStateHash pHash) {
        if (BAMTransferRelation.PCCInformation.isPCCEnabled()) {
            this.lastAnalyzedBlock = this.blockARGCache.get(pHash);
        }
    }

    public ARGState getLastAnalyzedBlock() {
        return this.lastAnalyzedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ReachedSet, Collection<AbstractState>> lookForSimilarState(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
        this.searchingTimer.start();
        try {
            int min = Integer.MAX_VALUE;
            Pair result = null;
            for (AbstractStateHash cacheKey : this.preciseReachedCache.keySet()) {
                int distance;
                AbstractStateHash ignorePrecisionSearchKey = this.getHashCode(pStateKey, cacheKey.precisionKey, pContext);
                if (!ignorePrecisionSearchKey.equals(cacheKey) || (distance = this.reducer.measurePrecisionDifference(pPrecisionKey, cacheKey.precisionKey)) >= min) continue;
                min = distance;
                result = Pair.of((Object)this.preciseReachedCache.get(ignorePrecisionSearchKey), this.returnCache.get(ignorePrecisionSearchKey));
            }
            Pair pair = result;
            return pair;
        }
        finally {
            this.searchingTimer.stop();
        }
    }

    private void findCacheMissCause(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
        AbstractStateHash searchKey = this.getHashCode(pStateKey, pPrecisionKey, pContext);
        for (AbstractStateHash cacheKey : this.preciseReachedCache.keySet()) {
            assert (!searchKey.equals(cacheKey));
            AbstractStateHash ignorePrecisionSearchKey = this.getHashCode(pStateKey, cacheKey.precisionKey, pContext);
            if (ignorePrecisionSearchKey.equals(cacheKey)) {
                ++this.precisionCausedMisses;
                return;
            }
            AbstractStateHash ignoreAbsSearchKey = this.getHashCode(cacheKey.stateKey, pPrecisionKey, pContext);
            if (!ignoreAbsSearchKey.equals(cacheKey)) continue;
            ++this.abstractionCausedMisses;
            return;
        }
        ++this.noSimilarCausedMisses;
    }

    public void clear() {
        this.preciseReachedCache.clear();
        this.unpreciseReachedCache.clear();
        this.returnCache.clear();
    }

    public boolean containsPreciseKey(AbstractState stateKey, Precision precisionKey, Block context) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        return this.preciseReachedCache.containsKey(hash);
    }

    public void updatePrecisionForEntry(AbstractState stateKey, Precision precisionKey, Block context, Precision newPrecisionKey) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        ReachedSet reachedSet = this.preciseReachedCache.get(hash);
        if (reachedSet != null) {
            this.preciseReachedCache.remove(hash);
            this.preciseReachedCache.put(this.getHashCode(stateKey, newPrecisionKey, context), reachedSet);
        }
    }

    public Collection<ReachedSet> getAllCachedReachedStates() {
        return this.preciseReachedCache.values();
    }

    private class AbstractStateHash {
        private final Object wrappedHash;
        private final Block context;
        private final AbstractState stateKey;
        private final Precision precisionKey;

        public AbstractStateHash(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
            this.wrappedHash = BAMCache.this.reducer.getHashCodeForState(pStateKey, pPrecisionKey);
            this.context = (Block)Preconditions.checkNotNull((Object)pContext);
            this.stateKey = pStateKey;
            this.precisionKey = pPrecisionKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object pObj) {
            if (!(pObj instanceof AbstractStateHash)) {
                return false;
            }
            AbstractStateHash other = (AbstractStateHash)pObj;
            BAMCache.this.equalsTimer.start();
            try {
                boolean bl = this.context.equals(other.context) && this.wrappedHash.equals(other.wrappedHash);
                return bl;
            }
            finally {
                BAMCache.this.equalsTimer.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            BAMCache.this.hashingTimer.start();
            try {
                int n = this.wrappedHash.hashCode() * 17 + this.context.hashCode();
                return n;
            }
            finally {
                BAMCache.this.hashingTimer.stop();
            }
        }

        public String toString() {
            return "AbstractStateHash [hash=" + this.hashCode() + ", wrappedHash=" + this.wrappedHash + ", context=" + this.context + ", predicateKey=" + this.stateKey + ", precisionKey=" + this.precisionKey + "]";
        }
    }
}

