/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class BAMPrecisionAdjustment
implements PrecisionAdjustment {
    private Map<AbstractState, Precision> forwardPrecisionToExpandedPrecision;
    private final PrecisionAdjustment wrappedPrecisionAdjustment;
    private final BAMTransferRelation trans;
    private final LogManager logger;

    public BAMPrecisionAdjustment(PrecisionAdjustment pWrappedPrecisionAdjustment, BAMTransferRelation pTransfer, LogManager pLogger) {
        this.wrappedPrecisionAdjustment = pWrappedPrecisionAdjustment;
        this.trans = pTransfer;
        this.logger = pLogger;
    }

    void setForwardPrecisionToExpandedPrecision(Map<AbstractState, Precision> pForwardPrecisionToExpandedPrecision) {
        this.forwardPrecisionToExpandedPrecision = pForwardPrecisionToExpandedPrecision;
    }

    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, AbstractState fullState) throws CPAException, InterruptedException {
        Precision validPrecision;
        if (this.trans.breakAnalysis) {
            return PrecisionAdjustment.PrecisionAdjustmentResult.create(pElement, pPrecision, PrecisionAdjustment.Action.BREAK);
        }
        if (this.forwardPrecisionToExpandedPrecision.containsKey(pElement)) {
            assert (AbstractStates.isTargetState(pElement) || this.trans.getBlockPartitioning().isReturnNode(AbstractStates.extractLocation(pElement)));
            validPrecision = this.forwardPrecisionToExpandedPrecision.get(pElement);
        } else {
            validPrecision = pPrecision;
        }
        PrecisionAdjustment.PrecisionAdjustmentResult result = this.wrappedPrecisionAdjustment.prec(pElement, validPrecision, pElements, fullState);
        result = result.withAbstractState(this.trans.attachAdditionalInfoToCallNode(result.abstractState()));
        if (pElement != result.abstractState()) {
            this.logger.log(Level.ALL, new Object[]{"before PREC:", pElement});
            this.logger.log(Level.ALL, new Object[]{"after PREC:", result.abstractState()});
            this.trans.replaceStateInCaches(pElement, result.abstractState(), false);
        }
        return result;
    }
}

