/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.ARGSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGBlockStartState;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGUtils;
import org.sosy_lab.cpachecker.cpa.bam.BAMCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.RecursiveAnalysisFailedException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="cpa.bam")
public class BAMTransferRelation
implements TransferRelation {
    @Option(name="handleRecursiveProcedures", secure=true, description="BAM allows to analyse recursive procedures depending on the underlying CPA.")
    private boolean handleRecursiveProcedures = false;
    private final BAMCache argCache;
    final Map<AbstractState, ReachedSet> abstractStateToReachedSet = new HashMap<AbstractState, ReachedSet>();
    final Map<AbstractState, AbstractState> expandedToReducedCache = new HashMap<AbstractState, AbstractState>();
    final Map<AbstractState, Block> expandedToBlockCache = new HashMap<AbstractState, Block>();
    private Block currentBlock;
    private BlockPartitioning partitioning;
    private int depth = 0;
    private final List<Triple<AbstractState, Precision, Block>> stack = new ArrayList<Triple<AbstractState, Precision, Block>>();
    private final LogManager logger;
    private final CPAAlgorithm.CPAAlgorithmFactory algorithmFactory;
    private final TransferRelation wrappedTransfer;
    private final ReachedSetFactory reachedSetFactory;
    private final Reducer wrappedReducer;
    private final BAMCPA bamCPA;
    private final ProofChecker wrappedProofChecker;
    private Map<AbstractState, Precision> forwardPrecisionToExpandedPrecision;
    private Map<Pair<ARGState, Block>, Collection<ARGState>> correctARGsForBlocks = null;
    int maxRecursiveDepth = 0;
    final Timer recomputeARTTimer = new Timer();
    final Timer removeCachedSubtreeTimer = new Timer();
    final Timer removeSubtreeTimer = new Timer();
    boolean breakAnalysis = false;
    private boolean recursionSeen = false;
    private boolean resultStatesChanged = false;
    private boolean targetFound = false;
    final Map<AbstractState, Triple<AbstractState, Precision, Block>> potentialRecursionUpdateStates = new HashMap<AbstractState, Triple<AbstractState, Precision, Block>>();

    public BAMTransferRelation(Configuration pConfig, LogManager pLogger, BAMCPA bamCpa, ProofChecker wrappedChecker, BAMCache cache, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.algorithmFactory = new CPAAlgorithm.CPAAlgorithmFactory(bamCpa, this.logger, pConfig, pShutdownNotifier, null);
        this.reachedSetFactory = pReachedSetFactory;
        this.wrappedTransfer = bamCpa.getWrappedCpa().getTransferRelation();
        this.wrappedReducer = bamCpa.getReducer();
        PCCInformation.instantiate(pConfig);
        this.bamCPA = bamCpa;
        this.wrappedProofChecker = wrappedChecker;
        this.argCache = cache;
        assert (this.wrappedReducer != null);
    }

    void setForwardPrecisionToExpandedPrecision(Map<AbstractState, Precision> pForwardPrecisionToExpandedPrecision) {
        this.forwardPrecisionToExpandedPrecision = pForwardPrecisionToExpandedPrecision;
    }

    void setBlockPartitioning(BlockPartitioning pManager) {
        this.partitioning = pManager;
    }

    public BlockPartitioning getBlockPartitioning() {
        assert (this.partitioning != null);
        return this.partitioning;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        try {
            Collection<? extends AbstractState> successors = this.getAbstractSuccessorsWithoutWrapping(pState, pPrecision);
            assert (!Iterables.any(successors, AbstractStates.IS_TARGET_STATE) || successors.size() == 1) : "target-state should be returned as single-element-collection";
            return this.attachAdditionalInfoToCallNodes(successors);
        }
        catch (CPAException e) {
            throw new RecursiveAnalysisFailedException(e);
        }
    }

    private Collection<? extends AbstractState> getAbstractSuccessorsWithoutWrapping(AbstractState pState, Precision pPrecision) throws CPAException, InterruptedException {
        this.forwardPrecisionToExpandedPrecision.clear();
        CFANode node = AbstractStates.extractLocation(pState);
        if (this.handleRecursiveProcedures && this.stack.isEmpty() && BAMTransferRelation.isHeadOfMainFunction(node)) {
            return this.doFixpointIterationForRecursion(pState, pPrecision, node);
        }
        if (this.currentBlock != null && this.currentBlock.isReturnNode(node) && !this.alreadyReturnedFromSameBlock(pState, this.currentBlock)) {
            return Collections.emptySet();
        }
        if (this.partitioning.isCallNode(node) && (!this.handleRecursiveProcedures || !((ARGState)pState).getParents().isEmpty()) && (!this.partitioning.getBlockForCallNode(node).equals(this.currentBlock) || this.handleRecursiveProcedures && BAMTransferRelation.isFunctionBlock(this.partitioning.getBlockForCallNode(node)))) {
            this.logger.log(Level.FINEST, new Object[]{"Starting recursive analysis of depth", ++this.depth});
            this.maxRecursiveDepth = Math.max(this.depth, this.maxRecursiveDepth);
            Collection<? extends AbstractState> resultStates = this.doRecursiveAnalysis(pState, pPrecision, node);
            this.logger.log(Level.FINEST, new Object[]{"Finished recursive analysis of depth", this.depth--});
            return resultStates;
        }
        return this.wrappedTransfer.getAbstractSuccessors(pState, pPrecision);
    }

    private Collection<? extends AbstractState> doFixpointIterationForRecursion(AbstractState pHeadOfMainFunctionState, Precision pPrecision, CFANode pHeadOfMainFunction) throws CPAException, InterruptedException {
        Collection<? extends AbstractState> resultStates;
        assert (BAMTransferRelation.isHeadOfMainFunction(pHeadOfMainFunction) && this.stack.isEmpty());
        int iterationCounter = 0;
        while (true) {
            if (!this.targetFound) {
                this.recursionSeen = false;
                this.resultStatesChanged = false;
                this.potentialRecursionUpdateStates.clear();
            }
            this.logger.log(Level.FINE, new Object[]{"Starting recursive analysis of main-block"});
            resultStates = this.doRecursiveAnalysis(pHeadOfMainFunctionState, pPrecision, pHeadOfMainFunction);
            this.logger.log(Level.FINE, new Object[]{"Finished recursive analysis of main-block"});
            this.targetFound = Iterables.any(resultStates, AbstractStates.IS_TARGET_STATE);
            if (this.targetFound) {
                this.logger.log(Level.INFO, new Object[]{"fixpoint-iteration aborted, because there was a target state."});
                break;
            }
            if (!this.resultStatesChanged) {
                this.logger.log(Level.INFO, new Object[]{"fixpoint-iteration aborted, because we did not get new states (fixpoint reached)."});
                break;
            }
            this.logger.log(Level.INFO, new Object[]{"fixpoint was not reached, starting new iteration", ++iterationCounter});
            this.reAddStatesForFixPointIteration(pHeadOfMainFunctionState);
        }
        return resultStates;
    }

    private void reAddStatesForFixPointIteration(AbstractState pHeadOfMainFunctionState) {
        for (AbstractState recursionUpdateState : this.potentialRecursionUpdateStates.keySet()) {
            for (ReachedSet reachedSet : this.argCache.getAllCachedReachedStates()) {
                if (!reachedSet.contains(recursionUpdateState)) continue;
                reachedSet.reAddToWaitlist(recursionUpdateState);
            }
        }
    }

    private Triple<AbstractState, Precision, Block> getCoveringLevel(List<Triple<AbstractState, Precision, Block>> stack, Triple<AbstractState, Precision, Block> currentLevel) throws CPAException, InterruptedException {
        for (Triple<AbstractState, Precision, Block> level : stack.subList(0, stack.size() - 1)) {
            if (level.getThird() != currentLevel.getThird() || !this.bamCPA.isCoveredBy((AbstractState)currentLevel.getFirst(), (AbstractState)level.getFirst())) continue;
            return level;
        }
        return null;
    }

    private Collection<AbstractState> getStatesNotCoveredBy(@Nonnull Collection<AbstractState> baseStates, @Nonnull Collection<AbstractState> coveringStates) throws CPAException, InterruptedException {
        ArrayList<AbstractState> notCoveredStates = new ArrayList<AbstractState>();
        for (AbstractState baseState : baseStates) {
            if (this.isCoveredByAny(baseState, coveringStates)) continue;
            notCoveredStates.add(baseState);
        }
        return notCoveredStates;
    }

    private boolean isCoveredByAny(@Nonnull AbstractState baseState, @Nonnull Collection<AbstractState> coveringStates) throws CPAException, InterruptedException {
        if (coveringStates.contains(baseState)) {
            return true;
        }
        for (AbstractState coveringState : coveringStates) {
            if (!this.bamCPA.isCoveredBy(baseState, coveringState)) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends AbstractState> doRecursiveAnalysis(AbstractState initialState, Precision pPrecision, CFANode node) throws CPAException, InterruptedException {
        Collection<AbstractState> resultStates;
        Block outerSubtree = this.currentBlock;
        this.currentBlock = this.partitioning.getBlockForCallNode(node);
        this.logger.log(Level.ALL, new Object[]{"Reducing state", initialState});
        AbstractState reducedInitialState = this.wrappedReducer.getVariableReducedState(initialState, this.currentBlock, node);
        Precision reducedInitialPrecision = this.wrappedReducer.getVariableReducedPrecision(pPrecision, this.currentBlock);
        Triple currentLevel = Triple.of((Object)reducedInitialState, (Object)reducedInitialPrecision, (Object)this.currentBlock);
        this.stack.add((Triple<AbstractState, Precision, Block>)currentLevel);
        this.logger.log(Level.FINEST, new Object[]{"current Stack:", this.stack});
        if (!this.handleRecursiveProcedures || !(node instanceof FunctionEntryNode) || BAMTransferRelation.isHeadOfMainFunction(node)) {
            resultStates = this.analyseBlockAndExpand(initialState, pPrecision, outerSubtree, reducedInitialState, reducedInitialPrecision);
        } else {
            Collection<AbstractState> expandedFunctionReturnStates;
            assert (!((ARGState)initialState).getParents().isEmpty());
            Collection<ARGState> possibleRootStates = ((ARGState)initialState).getParents();
            assert (possibleRootStates.size() == 1) : "too many functioncalls: " + possibleRootStates;
            AbstractState rootState = possibleRootStates.iterator().next();
            Triple<AbstractState, Precision, Block> coveringLevel = this.getCoveringLevel(this.stack, (Triple<AbstractState, Precision, Block>)currentLevel);
            if (coveringLevel != null) {
                this.logger.logf(Level.FINEST, "recursion will cause endless unrolling (with current precision), aborting call of function '%s' at state %s", new Object[]{node.getFunctionName(), reducedInitialState});
                expandedFunctionReturnStates = this.analyseRecursiveBlockAndExpand(initialState, pPrecision, outerSubtree, reducedInitialState, coveringLevel);
            } else {
                expandedFunctionReturnStates = this.analyseBlockAndExpand(initialState, pPrecision, outerSubtree, reducedInitialState, reducedInitialPrecision);
            }
            if (this.breakAnalysis) {
                assert (expandedFunctionReturnStates.size() == 1);
                return expandedFunctionReturnStates;
            }
            ArrayList<AbstractState> rebuildStates = new ArrayList<AbstractState>(expandedFunctionReturnStates.size());
            for (AbstractState expandedState : expandedFunctionReturnStates) {
                rebuildStates.add(this.getRebuildState(rootState, initialState, expandedState));
            }
            this.logger.log(Level.ALL, new Object[]{"finished rebuilding of", rebuildStates.size(), "states"});
            resultStates = rebuildStates;
        }
        if (this.recursionSeen) {
            this.potentialRecursionUpdateStates.put(initialState, (Triple<AbstractState, Precision, Block>)currentLevel);
        }
        Triple<AbstractState, Precision, Block> lastLevel = this.stack.remove(this.stack.size() - 1);
        assert (lastLevel.equals((Object)currentLevel));
        this.currentBlock = outerSubtree;
        return resultStates;
    }

    private Collection<AbstractState> analyseRecursiveBlockAndExpand(AbstractState initialState, Precision pPrecision, Block pOuterSubtree, AbstractState pReducedInitialState, Triple<AbstractState, Precision, Block> pCoveringLevel) throws CPATransferException {
        Set<Pair<AbstractState, Precision>> reducedResult;
        this.recursionSeen = true;
        Pair<ReachedSet, Collection<AbstractState>> pair = this.argCache.get((AbstractState)pCoveringLevel.getFirst(), (Precision)pCoveringLevel.getSecond(), (Block)pCoveringLevel.getThird());
        ReachedSet reached = (ReachedSet)pair.getFirst();
        Collection previousResult = (Collection)pair.getSecond();
        assert (reached != null) : "cached entry has no reached set";
        if (previousResult == null) {
            reducedResult = Collections.emptySet();
            this.logger.logf(Level.FINEST, "skipping recursive call with new empty result", new Object[0]);
        } else {
            reducedResult = this.imbueAbstractStatesWithPrecision(reached, previousResult);
            this.logger.logf(Level.FINEST, "skipping recursive call with cached result", new Object[0]);
        }
        this.abstractStateToReachedSet.put(initialState, reached);
        this.addBlockAnalysisInfo(pReducedInitialState);
        return this.expandResultStates(reducedResult, pOuterSubtree, initialState, pPrecision);
    }

    static boolean isHeadOfMainFunction(CFANode currentNode) {
        return currentNode instanceof FunctionEntryNode && currentNode.getNumEnteringEdges() == 0;
    }

    static boolean isFunctionBlock(Block block) {
        return block.getCallNodes().size() == 1 && block.getCallNode() instanceof FunctionEntryNode;
    }

    private Collection<AbstractState> analyseBlockAndExpand(AbstractState entryState, Precision precision, Block outerSubtree, AbstractState reducedInitialState, Precision reducedInitialPrecision) throws CPAException, InterruptedException {
        Collection<Pair<AbstractState, Precision>> reducedResult = this.getReducedResult(entryState, reducedInitialState, reducedInitialPrecision);
        this.logger.log(Level.ALL, new Object[]{"Resulting states:", reducedResult});
        this.addBlockAnalysisInfo(reducedInitialState);
        if (this.breakAnalysis) {
            assert (reducedResult.size() == 1);
            return Collections.singleton(((Pair)Iterables.getOnlyElement(reducedResult)).getFirst());
        }
        return this.expandResultStates(reducedResult, outerSubtree, entryState, precision);
    }

    private List<AbstractState> expandResultStates(Collection<Pair<AbstractState, Precision>> reducedResult, Block outerSubtree, AbstractState state, Precision precision) {
        this.logger.log(Level.ALL, new Object[]{"Expanding states with initial state", state});
        this.logger.log(Level.ALL, new Object[]{"Expanding states", reducedResult});
        ArrayList<AbstractState> expandedResult = new ArrayList<AbstractState>(reducedResult.size());
        for (Pair<AbstractState, Precision> reducedPair : reducedResult) {
            AbstractState reducedState = (AbstractState)reducedPair.getFirst();
            Precision reducedPrecision = (Precision)reducedPair.getSecond();
            AbstractState expandedState = this.wrappedReducer.getVariableExpandedState(state, this.currentBlock, reducedState);
            this.expandedToReducedCache.put(expandedState, reducedState);
            this.expandedToBlockCache.put(expandedState, this.currentBlock);
            Precision expandedPrecision = outerSubtree == null ? reducedPrecision : this.wrappedReducer.getVariableExpandedPrecision(precision, outerSubtree, reducedPrecision);
            ((ARGState)expandedState).addParent((ARGState)state);
            expandedResult.add(expandedState);
            this.forwardPrecisionToExpandedPrecision.put(expandedState, expandedPrecision);
        }
        this.logger.log(Level.ALL, new Object[]{"Expanded results:", expandedResult});
        return expandedResult;
    }

    private Collection<Pair<AbstractState, Precision>> getReducedResult(AbstractState initialState, AbstractState reducedInitialState, Precision reducedInitialPrecision) throws InterruptedException, CPAException {
        Collection<AbstractState> statesForFurtherAnalysis;
        Collection<AbstractState> reducedResult;
        Pair<ReachedSet, Collection<AbstractState>> pair = this.argCache.get(reducedInitialState, reducedInitialPrecision, this.currentBlock);
        ReachedSet reached = (ReachedSet)pair.getFirst();
        Collection<AbstractState> cachedReturnStates = (Collection<AbstractState>)pair.getSecond();
        assert (cachedReturnStates == null || reached != null) : "there cannot be result-states without reached-states";
        if (cachedReturnStates != null && !reached.hasWaitingState()) {
            this.logger.log(Level.FINEST, new Object[]{"Cache hit with finished reachedset."});
            statesForFurtherAnalysis = reducedResult = cachedReturnStates;
        } else if (cachedReturnStates != null && cachedReturnStates.size() == 1 && ((ARGState)reached.getLastState()).isTarget()) {
            assert (Iterables.getOnlyElement((Iterable)cachedReturnStates) == reached.getLastState()) : "cache hit only allowed for finished reached-sets or target-states";
            this.logger.log(Level.FINEST, new Object[]{"Cache hit with target-state."});
            statesForFurtherAnalysis = reducedResult = cachedReturnStates;
        } else {
            if (reached == null) {
                reached = this.createInitialReachedSet(reducedInitialState, reducedInitialPrecision);
                this.argCache.put(reducedInitialState, reducedInitialPrecision, this.currentBlock, reached);
                this.logger.log(Level.FINEST, new Object[]{"Cache miss: starting recursive CPAAlgorithm with new initial reached-set."});
            } else {
                this.logger.log(Level.FINEST, new Object[]{"Partial cache hit: starting recursive CPAAlgorithm with partial reached-set."});
            }
            reducedResult = this.performCompositeAnalysisWithCPAAlgorithm(reached);
            assert (reducedResult != null);
            if (cachedReturnStates == null) {
                this.logger.log(Level.FINEST, new Object[]{"there was no cache-entry for result-states."});
                this.resultStatesChanged = true;
                statesForFurtherAnalysis = reducedResult;
            } else {
                Collection<AbstractState> newStates = this.getStatesNotCoveredBy(reducedResult, cachedReturnStates);
                if (newStates.isEmpty()) {
                    this.logger.log(Level.FINEST, new Object[]{"all previous return-states are covering the current new states, no new states found."});
                } else {
                    this.logger.log(Level.FINEST, new Object[]{"some cached result-states are not covered. returning new result-states."});
                    this.resultStatesChanged = true;
                }
                statesForFurtherAnalysis = newStates;
            }
        }
        assert (reached != null);
        this.abstractStateToReachedSet.put(initialState, reached);
        ARGState rootOfBlock = null;
        if (PCCInformation.isPCCEnabled()) {
            if (!(reached.getFirstState() instanceof ARGState)) {
                throw new CPATransferException("Cannot build proof, ARG, for BAM analysis.");
            }
            rootOfBlock = BAMARGUtils.copyARG((ARGState)reached.getFirstState());
        }
        this.argCache.put(reducedInitialState, reached.getPrecision(reached.getFirstState()), this.currentBlock, reducedResult, rootOfBlock);
        return this.imbueAbstractStatesWithPrecision(reached, statesForFurtherAnalysis);
    }

    private AbstractState getRebuildState(AbstractState rootState, AbstractState entryState, AbstractState expandedState) {
        this.logger.log(Level.ALL, new Object[]{"rebuilding state with root state", rootState});
        this.logger.log(Level.ALL, new Object[]{"rebuilding state with entry state", entryState});
        this.logger.log(Level.ALL, new Object[]{"rebuilding state with expanded state", expandedState});
        AbstractState rebuildState = this.wrappedReducer.rebuildStateAfterFunctionCall(rootState, entryState, expandedState, AbstractStates.extractLocation(expandedState));
        this.logger.log(Level.ALL, new Object[]{"rebuilding finished with state", rebuildState});
        assert (((ARGState)expandedState).getChildren().isEmpty() && ((ARGState)expandedState).getParents().size() == 1) : "unexpected expanded state: " + expandedState;
        assert (((ARGState)entryState).getChildren().contains(expandedState)) : "successor of entry state " + entryState + " must be expanded state " + expandedState;
        ((ARGState)expandedState).removeFromARG();
        ((ARGState)rebuildState).addParent((ARGState)entryState);
        assert (this.expandedToBlockCache.get(expandedState) == this.currentBlock) : "returning from wrong block?";
        this.replaceStateInCaches(expandedState, rebuildState, true);
        return rebuildState;
    }

    void replaceStateInCaches(AbstractState oldState, AbstractState newState, boolean oldStateMustExist) {
        if (oldStateMustExist || this.expandedToReducedCache.containsKey(oldState)) {
            AbstractState reducedState = this.expandedToReducedCache.remove(oldState);
            this.expandedToReducedCache.put(newState, reducedState);
        }
        if (oldStateMustExist || this.expandedToBlockCache.containsKey(oldState)) {
            Block innerBlock = this.expandedToBlockCache.remove(oldState);
            this.expandedToBlockCache.put(newState, innerBlock);
        }
        if (oldStateMustExist || this.forwardPrecisionToExpandedPrecision.containsKey(oldState)) {
            Precision expandedPrecision = this.forwardPrecisionToExpandedPrecision.remove(oldState);
            this.forwardPrecisionToExpandedPrecision.put(newState, expandedPrecision);
        }
    }

    private boolean alreadyReturnedFromSameBlock(AbstractState state, Block block) {
        while (this.expandedToReducedCache.containsKey(state)) {
            if (this.expandedToBlockCache.containsKey(state) && block == this.expandedToBlockCache.get(state)) {
                return true;
            }
            state = this.expandedToReducedCache.get(state);
        }
        return false;
    }

    private Collection<AbstractState> performCompositeAnalysisWithCPAAlgorithm(ReachedSet reached) throws InterruptedException, CPAException {
        List<AbstractState> returnStates;
        CPAAlgorithm algorithm = this.algorithmFactory.newInstance();
        algorithm.run(reached);
        AbstractState lastState = reached.getLastState();
        if (AbstractStates.isTargetState(lastState)) {
            returnStates = Collections.singletonList(lastState);
        } else if (reached.hasWaitingState()) {
            this.breakAnalysis = true;
            returnStates = Collections.singletonList(lastState);
        } else {
            returnStates = new ArrayList<AbstractState>();
            for (AbstractState returnState : AbstractStates.filterLocations(reached, this.currentBlock.getReturnNodes())) {
                if (!((ARGState)returnState).getChildren().isEmpty()) continue;
                returnStates.add(returnState);
            }
        }
        return returnStates;
    }

    private List<Pair<AbstractState, Precision>> imbueAbstractStatesWithPrecision(ReachedSet pReached, Collection<AbstractState> pElements) {
        ArrayList<Pair<AbstractState, Precision>> result = new ArrayList<Pair<AbstractState, Precision>>();
        for (AbstractState ele : pElements) {
            result.add((Pair<AbstractState, Precision>)Pair.of((Object)ele, (Object)pReached.getPrecision(ele)));
        }
        return result;
    }

    private Collection<? extends AbstractState> attachAdditionalInfoToCallNodes(Collection<? extends AbstractState> pSuccessors) {
        if (PCCInformation.isPCCEnabled()) {
            ArrayList<AbstractState> successorsWithExtendedInfo = new ArrayList<AbstractState>(pSuccessors.size());
            for (AbstractState abstractState : pSuccessors) {
                if (!(abstractState instanceof ARGState)) {
                    return pSuccessors;
                }
                if (!(abstractState instanceof BAMARGBlockStartState)) {
                    successorsWithExtendedInfo.add(this.createAdditionalInfo((ARGState)abstractState));
                    continue;
                }
                successorsWithExtendedInfo.add(abstractState);
            }
            return successorsWithExtendedInfo;
        }
        return pSuccessors;
    }

    protected AbstractState attachAdditionalInfoToCallNode(AbstractState pElem) {
        if (!(pElem instanceof BAMARGBlockStartState) && PCCInformation.isPCCEnabled() && pElem instanceof ARGState) {
            return this.createAdditionalInfo((ARGState)pElem);
        }
        return pElem;
    }

    private ARGState createAdditionalInfo(ARGState pElem) {
        CFANode node = AbstractStates.extractLocation(pElem);
        if (this.partitioning.isCallNode(node) && !this.partitioning.getBlockForCallNode(node).equals(this.currentBlock)) {
            BAMARGBlockStartState replaceWith = new BAMARGBlockStartState(pElem.getWrappedState(), null);
            this.replaceInARG(pElem, replaceWith);
            return replaceWith;
        }
        return pElem;
    }

    private void replaceInARG(ARGState toReplace, ARGState replaceWith) {
        if (toReplace.isCovered()) {
            replaceWith.setCovered(toReplace.getCoveringState());
        }
        toReplace.uncover();
        toReplace.replaceInARGWith(replaceWith);
    }

    private void addBlockAnalysisInfo(AbstractState pElement) throws CPATransferException {
        if (PCCInformation.isPCCEnabled()) {
            if (this.argCache.getLastAnalyzedBlock() == null || !(pElement instanceof BAMARGBlockStartState)) {
                throw new CPATransferException("Cannot build proof, ARG, for BAM analysis.");
            }
            ((BAMARGBlockStartState)pElement).setAnalyzedBlock(this.argCache.getLastAnalyzedBlock());
        }
    }

    private ReachedSet createInitialReachedSet(AbstractState initialState, Precision initialPredicatePrecision) {
        ReachedSet reached = this.reachedSetFactory.create();
        reached.add(initialState, initialPredicatePrecision);
        return reached;
    }

    void removeSubtree(ARGReachedSet mainReachedSet, ARGPath pPath, ARGState element, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pNewPrecisionTypes, Map<ARGState, ARGState> pPathElementToReachedState) {
        this.removeSubtreeTimer.start();
        ARGSubtreeRemover argSubtreeRemover = new ARGSubtreeRemover(this.partitioning, this.wrappedReducer, this.argCache, this.reachedSetFactory, this.abstractStateToReachedSet, this.removeCachedSubtreeTimer, this.logger);
        argSubtreeRemover.removeSubtree(mainReachedSet, pPath, element, pNewPrecisions, pNewPrecisionTypes, pPathElementToReachedState);
        this.removeSubtreeTimer.stop();
    }

    ARGState computeCounterexampleSubgraph(ARGState target, ARGReachedSet reachedSet, Map<ARGState, ARGState> pPathElementToReachedState) throws InterruptedException, RecursiveAnalysisFailedException {
        assert (reachedSet.asReachedSet().contains(target));
        BAMCEXSubgraphComputer cexSubgraphComputer = new BAMCEXSubgraphComputer(this.partitioning, this.wrappedReducer, this.argCache, pPathElementToReachedState, this.abstractStateToReachedSet, this.expandedToReducedCache, this.logger);
        return cexSubgraphComputer.computeCounterexampleSubgraph(target, reachedSet, new BAMCEXSubgraphComputer.BackwardARGState(target));
    }

    void clearCaches() {
        this.argCache.clear();
        this.abstractStateToReachedSet.clear();
    }

    Pair<Block, ReachedSet> getCachedReachedSet(ARGState root, Precision rootPrecision) {
        CFANode rootNode = AbstractStates.extractLocation(root);
        Block rootSubtree = this.partitioning.getBlockForCallNode(rootNode);
        ReachedSet reachSet = this.abstractStateToReachedSet.get(root);
        assert (reachSet != null);
        return Pair.of((Object)rootSubtree, (Object)reachSet);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, List<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return this.attachAdditionalInfoToCallNodes(this.wrappedTransfer.strengthen(pElement, pOtherElements, pCfaEdge, pPrecision));
    }

    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        if (pCfaEdge != null) {
            return this.wrappedProofChecker.areAbstractSuccessors(pState, pCfaEdge, pSuccessors);
        }
        return this.areAbstractSuccessors0(pState, pSuccessors, this.partitioning.getMainBlock());
    }

    private boolean areAbstractSuccessors0(AbstractState pState, Collection<? extends AbstractState> pSuccessors, Block currentBlock) throws CPATransferException, InterruptedException {
        block15: {
            CFANode node = AbstractStates.extractLocation(pState);
            if (this.partitioning.isCallNode(node) && !this.partitioning.getBlockForCallNode(node).equals(currentBlock)) {
                Block analyzedBlock = this.partitioning.getBlockForCallNode(node);
                try {
                    if (!(pState instanceof BAMARGBlockStartState) || ((BAMARGBlockStartState)pState).getAnalyzedBlock() == null || !this.bamCPA.isCoveredBy(this.wrappedReducer.getVariableReducedStateForProofChecking(pState, analyzedBlock, node), ((BAMARGBlockStartState)pState).getAnalyzedBlock())) {
                        return false;
                    }
                }
                catch (CPAException e) {
                    throw new CPATransferException("Missing information about block whose analysis is expected to be started at " + pState);
                }
                try {
                    Collection endOfBlock;
                    Pair pair = Pair.of((Object)((BAMARGBlockStartState)pState).getAnalyzedBlock(), (Object)analyzedBlock);
                    if (this.correctARGsForBlocks != null && this.correctARGsForBlocks.containsKey(pair)) {
                        endOfBlock = this.correctARGsForBlocks.get(pair);
                    } else {
                        Pair<Boolean, Collection<ARGState>> result = this.checkARGBlock(((BAMARGBlockStartState)pState).getAnalyzedBlock(), analyzedBlock);
                        if (!((Boolean)result.getFirst()).booleanValue()) {
                            return false;
                        }
                        endOfBlock = (Collection)result.getSecond();
                        this.setCorrectARG((Pair<ARGState, Block>)pair, endOfBlock);
                    }
                    HashSet<? extends AbstractState> notFoundSuccessors = new HashSet<AbstractState>(pSuccessors);
                    HashMultimap blockSuccessors = HashMultimap.create();
                    for (AbstractState abstractState : pSuccessors) {
                        ARGState successorElem = (ARGState)abstractState;
                        blockSuccessors.put((Object)AbstractStates.extractLocation(abstractState), (Object)successorElem);
                    }
                    for (ARGState aRGState : endOfBlock) {
                        boolean successorExists = false;
                        AbstractState expandedState = this.wrappedReducer.getVariableExpandedStateForProofChecking(pState, analyzedBlock, aRGState);
                        for (AbstractState next : blockSuccessors.get((Object)AbstractStates.extractLocation(aRGState))) {
                            if (!this.bamCPA.isCoveredBy(expandedState, next)) continue;
                            successorExists = true;
                            notFoundSuccessors.remove(next);
                        }
                        if (successorExists) continue;
                        return false;
                    }
                    if (!notFoundSuccessors.isEmpty()) {
                        return false;
                    }
                    break block15;
                }
                catch (CPAException e) {
                    throw new CPATransferException("Checking ARG with root " + ((BAMARGBlockStartState)pState).getAnalyzedBlock() + " for block " + currentBlock + "failed.");
                }
            }
            HashSet<CFAEdge> usedEdges = new HashSet<CFAEdge>();
            for (AbstractState abstractState : pSuccessors) {
                ARGState successorElem = (ARGState)abstractState;
                usedEdges.add(((ARGState)pState).getEdgeToChild(successorElem));
            }
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                Block block = this.partitioning.getBlockForReturnNode(node);
                if (!(block != null && !currentBlock.equals(block) && block.getNodes().contains(node.getLeavingEdge(i).getSuccessor()) ? usedEdges.contains(node.getLeavingEdge(i)) : (!currentBlock.isCallNode(node) && currentBlock.isReturnNode(node) && !currentBlock.getNodes().contains(node.getLeavingEdge(i).getSuccessor()) ? usedEdges.contains(node.getLeavingEdge(i)) : !this.wrappedProofChecker.areAbstractSuccessors(pState, node.getLeavingEdge(i), pSuccessors)))) continue;
                return false;
            }
        }
        return true;
    }

    private Pair<Boolean, Collection<ARGState>> checkARGBlock(ARGState rootNode, Block currentBlock) throws CPAException, InterruptedException {
        List<Object> returnNodes = new ArrayList();
        HashSet<ARGState> waitingForUnexploredParents = new HashSet<ARGState>();
        Stack<ARGState> waitlist = new Stack<ARGState>();
        HashSet<ARGState> visited = new HashSet<ARGState>();
        HashSet<ARGState> coveredNodes = new HashSet<ARGState>();
        waitlist.add(rootNode);
        visited.add(rootNode);
        while (!waitlist.isEmpty()) {
            boolean unexploredParent;
            ARGState current = (ARGState)waitlist.pop();
            if (current.isTarget()) {
                returnNodes.add(current);
            }
            if (current.isCovered()) {
                coveredNodes.clear();
                coveredNodes.add(current);
                do {
                    if (!this.bamCPA.isCoveredBy(current, current.getCoveringState())) {
                        returnNodes = Collections.emptyList();
                        return Pair.of((Object)false, returnNodes);
                    }
                    coveredNodes.add(current);
                    if (!coveredNodes.contains(current.getCoveringState())) continue;
                    returnNodes = Collections.emptyList();
                    return Pair.of((Object)false, returnNodes);
                } while ((current = current.getCoveringState()).isCovered());
                if (visited.contains(current)) continue;
                unexploredParent = false;
                for (ARGState p : current.getParents()) {
                    if (visited.contains(p) && !waitlist.contains(p)) continue;
                    waitingForUnexploredParents.add(current);
                    unexploredParent = true;
                    break;
                }
                if (unexploredParent) continue;
                visited.add(current);
                waitlist.add(current);
                continue;
            }
            CFANode node = AbstractStates.extractLocation(current);
            if (currentBlock.isReturnNode(node)) {
                returnNodes.add(current);
            }
            if (!this.areAbstractSuccessors0(current, current.getChildren(), currentBlock)) {
                returnNodes = Collections.emptyList();
                return Pair.of((Object)false, returnNodes);
            }
            for (ARGState child : current.getChildren()) {
                unexploredParent = false;
                for (ARGState p : child.getParents()) {
                    if (visited.contains(p) && !waitlist.contains(p)) continue;
                    waitingForUnexploredParents.add(child);
                    unexploredParent = true;
                    break;
                }
                if (unexploredParent) continue;
                if (visited.contains(child)) {
                    returnNodes = Collections.emptyList();
                    return Pair.of((Object)false, returnNodes);
                }
                waitingForUnexploredParents.remove(child);
                visited.add(child);
                waitlist.add(child);
            }
        }
        if (!waitingForUnexploredParents.isEmpty()) {
            returnNodes = Collections.emptyList();
            return Pair.of((Object)false, returnNodes);
        }
        return Pair.of((Object)true, returnNodes);
    }

    public void setCorrectARG(Pair<ARGState, Block> pKey, Collection<ARGState> pEndOfBlock) {
        if (this.correctARGsForBlocks == null) {
            this.correctARGsForBlocks = new HashMap<Pair<ARGState, Block>, Collection<ARGState>>();
        }
        this.correctARGsForBlocks.put(pKey, pEndOfBlock);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) {
        throw new UnsupportedOperationException("BAMCPA needs to be used as the outer-most CPA, thus it does not support returning successors for a single edge.");
    }

    @Options
    static class PCCInformation {
        @Option(secure=true, name="pcc.proofgen.doPCC", description="Generate and dump a proof")
        private boolean doPCC = false;
        private static PCCInformation instance = null;

        private PCCInformation(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }

        public static void instantiate(Configuration pConfig) throws InvalidConfigurationException {
            instance = new PCCInformation(pConfig);
        }

        public static boolean isPCCEnabled() {
            return PCCInformation.instance.doPCC;
        }
    }
}

