/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

public class BDDBooleanExpressionVisitor
extends DefaultCExpressionVisitor<Region, RuntimeException> {
    private static final int BOOLEAN_SIZE = 1;
    private final PredicateManager predMgr;
    private final VariableTrackingPrecision precision;
    protected final RegionManager rmgr;
    private final CFANode location;

    protected BDDBooleanExpressionVisitor(PredicateManager pPredMgr, RegionManager pRmgr, VariableTrackingPrecision pPrecision, CFANode pLocation) {
        this.predMgr = pPredMgr;
        this.rmgr = pRmgr;
        this.precision = pPrecision;
        this.location = pLocation;
    }

    @Override
    protected Region visitDefault(CExpression pExp) {
        return null;
    }

    @Override
    public Region visit(CBinaryExpression pE) {
        Region lVal = pE.getOperand1().accept(this);
        Region rVal = pE.getOperand2().accept(this);
        if (lVal == null || rVal == null) {
            return null;
        }
        return BDDBooleanExpressionVisitor.calculateBinaryOperation(lVal, rVal, this.rmgr, pE);
    }

    public static Region calculateBinaryOperation(Region l, Region r, RegionManager rmgr, CBinaryExpression binaryExpr) {
        CBinaryExpression.BinaryOperator binaryOperator = binaryExpr.getOperator();
        switch (binaryOperator) {
            case BINARY_AND: {
                return rmgr.makeAnd(l, r);
            }
            case BINARY_OR: {
                return rmgr.makeOr(l, r);
            }
            case BINARY_XOR: 
            case NOT_EQUALS: {
                return rmgr.makeUnequal(l, r);
            }
            case EQUALS: {
                return rmgr.makeEqual(l, r);
            }
        }
        throw new AssertionError((Object)"unhandled binary operator");
    }

    @Override
    public Region visit(CCharLiteralExpression pE) {
        return this.getNum(pE.getCharacter());
    }

    @Override
    public Region visit(CIntegerLiteralExpression pE) {
        return this.getNum(pE.asLong());
    }

    @Override
    public Region visit(CImaginaryLiteralExpression pE) {
        return pE.getValue().accept(this);
    }

    @Override
    public Region visit(CIdExpression idExp) {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            if (enumerator.hasValue()) {
                return this.getNum(enumerator.getValue());
            }
            return null;
        }
        Region[] result = this.predMgr.createPredicate(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.location, 1, this.precision);
        if (result == null) {
            return null;
        }
        assert (result.length == 1);
        return result[0];
    }

    private Region getNum(long num) {
        if (num == 0L) {
            return this.rmgr.makeFalse();
        }
        if (num == 1L) {
            return this.rmgr.makeTrue();
        }
        throw new AssertionError((Object)("no boolean value: " + num));
    }
}

