/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.io.PrintStream;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.bdd.BDDReducer;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.cpa.bdd.BDDTransferRelation;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

@Options(prefix="cpa.bdd")
public class BDDCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider {
    private final NamedRegionManager manager;
    private final BitvectorManager bvmgr;
    private final PredicateManager predmgr;
    private final AbstractDomain abstractDomain;
    private VariableTrackingPrecision precision;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final BDDTransferRelation transferRelation;
    private final BDDReducer reducer;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    @Option(secure=true, description="mergeType")
    private String merge = "join";

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(BDDCPA.class);
    }

    private BDDCPA(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdownNotifier = pShutdownNotifier;
        RegionManager rmgr = new BDDManagerFactory(this.config, this.logger).createRegionManager();
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.mergeOperator = this.merge.equals("sep") ? MergeSepOperator.getInstance() : new MergeJoinOperator(this.abstractDomain);
        this.precision = VariableTrackingPrecision.createStaticPrecision(this.config, this.cfa.getVarClassification(), this.getClass());
        this.manager = new NamedRegionManager(rmgr);
        this.bvmgr = new BitvectorManager(this.config, rmgr);
        this.predmgr = new PredicateManager(this.config, this.manager, this.cfa);
        this.transferRelation = new BDDTransferRelation(this.manager, this.bvmgr, this.predmgr, this.logger, this.config, this.cfa);
        this.reducer = new BDDReducer(this.manager, this.predmgr);
    }

    public void injectRefinablePrecision() throws InvalidConfigurationException {
        this.precision = VariableTrackingPrecision.createRefineablePrecision(this.config, this.precision);
    }

    public NamedRegionManager getManager() {
        return this.manager;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new BDDState(this.manager, this.bvmgr, this.manager.makeTrue());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
                BDDCPA.this.transferRelation.printStatistics(out);
            }

            @Override
            public String getName() {
                return "BDDCPA";
            }
        });
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }
}

