/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.VariableClassification;

public class BDDPartitionOrderer {
    private Multimap<VariableClassification.Partition, VariableClassification.Partition> graph = LinkedHashMultimap.create();
    private VariableClassification varClass;

    public BDDPartitionOrderer(CFA cfa) {
        assert (cfa.getVarClassification().isPresent());
        this.varClass = (VariableClassification)cfa.getVarClassification().get();
        CFAAssumptionCollector aCol = new CFAAssumptionCollector();
        CFATraversal.dfs().ignoreSummaryEdges().traverseOnce(cfa.getMainFunction(), aCol);
        Collection<CAssumeEdge> assumptions = aCol.getAssumptions();
        for (CAssumeEdge ass : assumptions) {
            this.collectDependentPartitions(ass);
        }
    }

    private void collectDependentPartitions(CAssumeEdge assumption) {
        CFANode root = assumption.getPredecessor();
        assert (root.getNumLeavingEdges() == 2) : "assumption must have 2 branches.";
        CFAEdge ass1 = root.getLeavingEdge(0);
        CFAEdge ass2 = root.getLeavingEdge(1);
        assert (ass1 == assumption || ass2 == assumption);
        VariableClassification.Partition assPartition = this.varClass.getPartitionForEdge(ass1);
        assert (this.varClass.getPartitionForEdge(ass2) == assPartition);
        if (assPartition == null) {
            return;
        }
        CFAUntilSplitCollector fCol1 = new CFAUntilSplitCollector();
        CFATraversal.dfs().ignoreSummaryEdges().traverseOnce(ass1.getSuccessor(), fCol1);
        Set<CFAEdge> reachable1 = fCol1.getEdges();
        CFAUntilSplitCollector fCol2 = new CFAUntilSplitCollector();
        CFATraversal.dfs().ignoreSummaryEdges().traverseOnce(ass2.getSuccessor(), fCol2);
        Set<CFAEdge> reachable2 = fCol2.getEdges();
        Sets.SetView distinctEdges = Sets.symmetricDifference(reachable1, reachable2);
        for (CFAEdge edge : distinctEdges) {
            if (edge instanceof FunctionCallEdge) {
                FunctionCallEdge funcCall = (FunctionCallEdge)edge;
                for (int i = 0; i < funcCall.getArguments().size(); ++i) {
                    VariableClassification.Partition part = this.varClass.getPartitionForParameterOfEdge(funcCall, i);
                    if (part == null) continue;
                    this.graph.put((Object)assPartition, (Object)part);
                }
                continue;
            }
            VariableClassification.Partition part = this.varClass.getPartitionForEdge(edge);
            if (part == null) continue;
            this.graph.put((Object)assPartition, (Object)part);
        }
    }

    public List<VariableClassification.Partition> getOrderedPartitions() {
        LinkedHashSet partitions = Sets.newLinkedHashSet();
        for (VariableClassification.Partition p : this.graph.keySet()) {
            this.addToPartitions(p, partitions);
        }
        LinkedList orderedPartitions = Lists.newLinkedList((Iterable)partitions);
        for (VariableClassification.Partition p : this.varClass.getPartitions()) {
            if (partitions.contains(p)) continue;
            orderedPartitions.add(0, p);
        }
        return orderedPartitions;
    }

    private void addToPartitions(VariableClassification.Partition father, Collection<VariableClassification.Partition> partitions) {
        if (!partitions.contains(father)) {
            partitions.add(father);
            for (VariableClassification.Partition child : this.graph.get((Object)father)) {
                this.addToPartitions(child, partitions);
            }
        }
    }

    private class CFAAssumptionCollector
    extends CFATraversal.DefaultCFAVisitor {
        private Collection<CAssumeEdge> assumptions = new ArrayList<CAssumeEdge>();

        private CFAAssumptionCollector() {
        }

        public Collection<CAssumeEdge> getAssumptions() {
            return this.assumptions;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            CAssumeEdge assumption;
            if (pEdge.getEdgeType() == CFAEdgeType.AssumeEdge && (assumption = (CAssumeEdge)pEdge).getTruthAssumption()) {
                this.assumptions.add(assumption);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }

    private static class CFAUntilSplitCollector
    implements CFATraversal.CFAVisitor {
        private Set<CFAEdge> edges = new LinkedHashSet<CFAEdge>();

        private CFAUntilSplitCollector() {
        }

        public Set<CFAEdge> getEdges() {
            return this.edges;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            this.edges.add(pEdge);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            int numChildren = pNode.getNumLeavingEdges();
            if (numChildren > 1) {
                CFAUtils.leavingEdges(pNode).copyInto(this.edges);
                return CFATraversal.TraversalProcess.SKIP;
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

