/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

public class BDDReducer
implements Reducer {
    private final NamedRegionManager mgr;
    private final PredicateManager predmgr;

    BDDReducer(NamedRegionManager pMgr, PredicateManager pPredmgr) {
        this.mgr = pMgr;
        this.predmgr = pPredmgr;
    }

    private Set<String> getVarsOfBlock(Block pBlock) {
        HashSet<String> vars = new HashSet<String>();
        for (ReferencedVariable referencedVar : pBlock.getReferencedVariables()) {
            vars.add(referencedVar.getName());
        }
        return vars;
    }

    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pBlock, CFANode pCallNode) {
        BDDState state = (BDDState)pExpandedState;
        Set<String> trackedVars = this.predmgr.getTrackedVars().keySet();
        Set<String> blockVars = this.getVarsOfBlock(pBlock);
        for (String var : trackedVars) {
            if (blockVars.contains(var)) continue;
            int size = this.predmgr.getTrackedVars().get(var);
            Region[] toRemove = this.predmgr.createPredicateWithoutPrecisionCheck(var, size);
            state = state.forget(toRemove);
        }
        return state;
    }

    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootState, Block reducedContext, AbstractState pReducedState) {
        BDDState state = (BDDState)pRootState;
        BDDState reducedState = (BDDState)pReducedState;
        Set<Region> usedVars = this.mgr.extractPredicates(state.getRegion());
        state = state.forget(usedVars.toArray(new Region[usedVars.size()]));
        state = state.addConstraint(reducedState.getRegion());
        return state;
    }

    @Override
    public Precision getVariableReducedPrecision(Precision precision, Block context) {
        return precision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        return reducedPrecision;
    }

    @Override
    public Object getHashCodeForState(AbstractState stateKey, Precision precisionKey) {
        return Pair.of((Object)((BDDState)stateKey).getRegion(), (Object)precisionKey);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        return 0;
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        return this.getVariableReducedState(pExpandedState, pContext, pCallNode);
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        return this.getVariableExpandedState(pRootState, pReducedContext, pReducedState);
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState rootState, AbstractState entryState, AbstractState expandedState, CFANode exitLocation) {
        throw new UnsupportedOperationException("not implemented");
    }
}

