/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDBooleanExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDCompressExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.cpa.bdd.BDDVectorCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

@Options(prefix="cpa.bdd")
public class BDDTransferRelation
extends ForwardingTransferRelation<BDDState, BDDState, VariableTrackingPrecision> {
    @Option(secure=true, name="logfile", description="Dump tracked variables to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path dumpfile = Paths.get((String)"BDDCPA_tracked_variables.log", (String[])new String[0]);
    @Option(secure=true, description="max bitsize for values and vars, initial value")
    private int bitsize = 64;
    @Option(secure=true, description="use a smaller bitsize for all vars, that have only intEqual values")
    private boolean compressIntEqual = true;
    private final LogManager logger;
    private final VariableClassification varClass;
    private final BitvectorManager bvmgr;
    private final NamedRegionManager rmgr;
    private final PredicateManager predmgr;
    private final MachineModel machineModel;

    public BDDTransferRelation(NamedRegionManager manager, BitvectorManager bvmgr, PredicateManager pPredmgr, LogManager pLogger, Configuration config, CFA cfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.machineModel = cfa.getMachineModel();
        this.rmgr = manager;
        this.bvmgr = bvmgr;
        this.predmgr = pPredmgr;
        assert (cfa.getVarClassification().isPresent());
        this.varClass = (VariableClassification)cfa.getVarClassification().get();
    }

    @Override
    protected Collection<BDDState> preCheck() {
        if (((VariableTrackingPrecision)this.precision).isEmpty()) {
            return Collections.singleton(this.state);
        }
        if (((BDDState)this.state).getRegion().isFalse()) {
            return Collections.emptyList();
        }
        return null;
    }

    @Override
    protected BDDState handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) {
        BDDState result = (BDDState)this.state;
        if (statement instanceof CAssignment) {
            result = this.handleAssignment((CAssignment)statement, cfaEdge.getSuccessor());
        } else if (statement instanceof CFunctionCallStatement) {
            result = this.handleExternalFunctionCall(result, cfaEdge.getSuccessor(), ((CFunctionCallStatement)statement).getFunctionCallExpression().getParameterExpressions());
        }
        assert (!result.getRegion().isFalse());
        return result;
    }

    private BDDState handleAssignment(CAssignment assignment, CFANode successor) {
        CLeftHandSide lhs = assignment.getLeftHandSide();
        if (!(lhs instanceof CIdExpression)) {
            return (BDDState)this.state;
        }
        CType targetType = lhs.getExpressionType();
        String varName = ((CIdExpression)lhs).getDeclaration().getQualifiedName();
        if (!((VariableTrackingPrecision)this.precision).isTracking(ValueAnalysisState.MemoryLocation.valueOf(varName), targetType, successor)) {
            return (BDDState)this.state;
        }
        BDDState newState = (BDDState)this.state;
        CRightHandSide rhs = assignment.getRightHandSide();
        if (rhs instanceof CExpression) {
            CExpression exp = (CExpression)rhs;
            VariableClassification.Partition partition = this.varClass.getPartitionForEdge(this.edge);
            if (BDDTransferRelation.isUsedInExpression(varName, exp)) {
                String tmpVarName = this.predmgr.getTmpVariableForVars(partition.getVars());
                Region[] tmp = this.predmgr.createPredicateWithoutPrecisionCheck(tmpVarName, this.getBitsize(partition, targetType));
                Region[] regRHS = this.evaluateVectorExpression(partition, exp, targetType, successor);
                newState = newState.addAssignment(tmp, regRHS);
                Region[] var = this.predmgr.createPredicate(BDDTransferRelation.scopeVar(lhs), targetType, successor, this.getBitsize(partition, targetType), (VariableTrackingPrecision)this.precision);
                newState = newState.forget(var);
                newState = newState.addAssignment(var, tmp);
                newState = newState.forget(tmp);
            } else {
                Region[] var = this.predmgr.createPredicate(BDDTransferRelation.scopeVar(lhs), targetType, successor, this.getBitsize(partition, targetType), (VariableTrackingPrecision)this.precision);
                newState = newState.forget(var);
                Region[] regRHS = this.evaluateVectorExpression(partition, (CExpression)rhs, targetType, successor);
                newState = newState.addAssignment(var, regRHS);
            }
            return newState;
        }
        if (rhs instanceof CFunctionCallExpression) {
            newState = this.handleExternalFunctionCall(newState, successor, ((CFunctionCallExpression)rhs).getParameterExpressions());
            Region[] var = this.predmgr.createPredicate(BDDTransferRelation.scopeVar(lhs), targetType, successor, this.bitsize, (VariableTrackingPrecision)this.precision);
            newState = newState.forget(var);
            return newState;
        }
        throw new AssertionError((Object)("unhandled assignment: " + this.edge.getRawStatement()));
    }

    private BDDState handleExternalFunctionCall(BDDState currentState, CFANode successor, List<CExpression> params) {
        for (CExpression param : params) {
            if (!(param instanceof CUnaryExpression) || CUnaryExpression.UnaryOperator.AMPER != ((CUnaryExpression)param).getOperator() || !(((CUnaryExpression)param).getOperand() instanceof CIdExpression)) continue;
            CIdExpression id = (CIdExpression)((CUnaryExpression)param).getOperand();
            Region[] var = this.predmgr.createPredicate(BDDTransferRelation.scopeVar(id), id.getExpressionType(), successor, this.bitsize, (VariableTrackingPrecision)this.precision);
            currentState = currentState.forget(var);
        }
        return (BDDState)this.state;
    }

    @Override
    protected BDDState handleDeclarationEdge(CDeclarationEdge cfaEdge, CDeclaration decl) {
        if (decl instanceof CVariableDeclaration) {
            CVariableDeclaration vdecl = (CVariableDeclaration)decl;
            CInitializer initializer = vdecl.getInitializer();
            CExpression init = null;
            if (initializer instanceof CInitializerExpression) {
                init = ((CInitializerExpression)initializer).getExpression();
            }
            VariableClassification.Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
            Region[] var = this.predmgr.createPredicate(vdecl.getQualifiedName(), vdecl.getType(), cfaEdge.getSuccessor(), this.getBitsize(partition, vdecl.getType()), (VariableTrackingPrecision)this.precision);
            BDDState newState = ((BDDState)this.state).forget(var);
            if (init != null) {
                Region[] rhs = this.evaluateVectorExpression(partition, init, vdecl.getType(), cfaEdge.getSuccessor());
                newState = newState.addAssignment(var, rhs);
                return newState;
            }
        }
        return (BDDState)this.state;
    }

    @Override
    protected BDDState handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> args, List<CParameterDeclaration> params, String calledFunction) {
        BDDState newState = (BDDState)this.state;
        assert (args.size() >= params.size());
        for (int i = 0; i < params.size(); ++i) {
            String varName = params.get(i).getQualifiedName();
            CType targetType = params.get(i).getType();
            VariableClassification.Partition partition = this.varClass.getPartitionForParameterOfEdge(cfaEdge, i);
            Region[] var = this.predmgr.createPredicate(varName, targetType, cfaEdge.getSuccessor(), this.getBitsize(partition, targetType), (VariableTrackingPrecision)this.precision);
            Region[] arg = this.evaluateVectorExpression(partition, args.get(i), targetType, cfaEdge.getSuccessor());
            newState = newState.addAssignment(var, arg);
        }
        return newState;
    }

    @Override
    protected BDDState handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String outerFunctionName) {
        BDDState newState = (BDDState)this.state;
        VariableClassification.Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
        if (summaryExpr instanceof CFunctionCallAssignmentStatement) {
            String returnVar = ((CVariableDeclaration)fnkCall.getFunctionEntry().getReturnVariable().get()).getQualifiedName();
            CFunctionCallAssignmentStatement cAssignment = (CFunctionCallAssignmentStatement)summaryExpr;
            CLeftHandSide lhs = cAssignment.getLeftHandSide();
            int size = this.getBitsize(partition, lhs.getExpressionType());
            Region[] var = this.predmgr.createPredicate(BDDTransferRelation.scopeVar(lhs), lhs.getExpressionType(), cfaEdge.getSuccessor(), size, (VariableTrackingPrecision)this.precision);
            newState = newState.forget(var);
            Region[] retVar = this.predmgr.createPredicate(returnVar, summaryExpr.getFunctionCallExpression().getExpressionType(), cfaEdge.getSuccessor(), size, (VariableTrackingPrecision)this.precision);
            newState = newState.addAssignment(var, retVar);
            if (this.predmgr.getTrackedVars().containsKey(returnVar)) {
                newState = newState.forget(this.predmgr.createPredicateWithoutPrecisionCheck(returnVar, this.predmgr.getTrackedVars().get(returnVar)));
            }
        } else assert (summaryExpr instanceof CFunctionCallStatement);
        return newState;
    }

    @Override
    protected BDDState handleReturnStatementEdge(CReturnStatementEdge cfaEdge) {
        BDDState newState = (BDDState)this.state;
        String returnVar = "";
        if (cfaEdge.getExpression().isPresent()) {
            returnVar = ((CIdExpression)((CAssignment)cfaEdge.asAssignment().get()).getLeftHandSide()).getDeclaration().getQualifiedName();
            VariableClassification.Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
            CType functionReturnType = ((CFunctionDeclaration)cfaEdge.getSuccessor().getEntryNode().getFunctionDefinition()).getType().getReturnType();
            Region[] regRHS = this.evaluateVectorExpression(partition, (CExpression)cfaEdge.getExpression().get(), functionReturnType, cfaEdge.getSuccessor());
            Region[] retvar = this.predmgr.createPredicate(returnVar, functionReturnType, cfaEdge.getSuccessor(), this.getBitsize(partition, functionReturnType), (VariableTrackingPrecision)this.precision);
            newState = newState.forget(retvar);
            newState = newState.addAssignment(retvar, regRHS);
        }
        for (String var : this.predmgr.getTrackedVars().keySet()) {
            if (!BDDTransferRelation.isLocalVariableForFunction(var, this.functionName) || returnVar.equals(var)) continue;
            newState = newState.forget(this.predmgr.createPredicateWithoutPrecisionCheck(var, this.predmgr.getTrackedVars().get(var)));
        }
        return newState;
    }

    @Override
    protected BDDState handleBlankEdge(BlankEdge cfaEdge) {
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode) {
            assert ("default return".equals(cfaEdge.getDescription()) || "skipped unnecessary edges".equals(cfaEdge.getDescription()));
            BDDState newState = (BDDState)this.state;
            for (String var : this.predmgr.getTrackedVars().keySet()) {
                if (!BDDTransferRelation.isLocalVariableForFunction(var, this.functionName)) continue;
                newState = newState.forget(this.predmgr.createPredicateWithoutPrecisionCheck(var, this.predmgr.getTrackedVars().get(var)));
            }
            return newState;
        }
        return (BDDState)this.state;
    }

    @Override
    protected BDDState handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) {
        Region newRegion;
        VariableClassification.Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
        Region[] operand = this.evaluateVectorExpression(partition, expression, CNumericTypes.INT, cfaEdge.getSuccessor());
        if (operand == null) {
            return (BDDState)this.state;
        }
        Region evaluated = this.bvmgr.makeOr(operand);
        if (!truthAssumption) {
            evaluated = this.rmgr.makeNot(evaluated);
        }
        if ((newRegion = this.rmgr.makeAnd(((BDDState)this.state).getRegion(), evaluated)).isFalse()) {
            return null;
        }
        return new BDDState(this.rmgr, this.bvmgr, newRegion);
    }

    @Nullable
    private Region[] evaluateVectorExpression(VariableClassification.Partition partition, CExpression exp, CType targetType, CFANode location) {
        boolean compress;
        boolean bl = compress = partition != null && this.compressIntEqual && this.varClass.getIntEqualPartitions().contains(partition);
        if (this.varClass.getIntBoolPartitions().contains(partition)) {
            Region[] regionArray;
            Region booleanResult = exp.accept(new BDDBooleanExpressionVisitor(this.predmgr, this.rmgr, (VariableTrackingPrecision)this.precision, location));
            if (booleanResult == null) {
                regionArray = null;
            } else {
                Region[] regionArray2 = new Region[1];
                regionArray = regionArray2;
                regionArray2[0] = booleanResult;
            }
            return regionArray;
        }
        if (compress) {
            return exp.accept(new BDDCompressExpressionVisitor(this.predmgr, (VariableTrackingPrecision)this.precision, this.getBitsize(partition, null), location, this.bvmgr, partition));
        }
        Region[] value = exp.accept(new BDDVectorCExpressionVisitor(this.predmgr, (VariableTrackingPrecision)this.precision, this.bvmgr, this.machineModel, location));
        if (value != null) {
            CType sourceType = exp.getExpressionType().getCanonicalType();
            value = this.bvmgr.toBitsize(this.machineModel.getSizeof(targetType) * this.machineModel.getSizeofCharInBits(), sourceType instanceof CSimpleType && this.machineModel.isSigned((CSimpleType)sourceType), value);
        }
        return value;
    }

    private static boolean isUsedInExpression(String varName, CExpression exp) {
        return exp.accept(new VarCExpressionVisitor(varName));
    }

    private static String scopeVar(CExpression exp) {
        if (exp instanceof CIdExpression) {
            return ((CIdExpression)exp).getDeclaration().getQualifiedName();
        }
        return exp.toASTString();
    }

    private static boolean isLocalVariableForFunction(String scopedVarName, String function) {
        return scopedVarName.startsWith(function + "::");
    }

    protected int getBitsize(@Nullable VariableClassification.Partition partition, @Nullable CType type) {
        if (partition == null) {
            return 0;
        }
        if (this.varClass.getIntBoolPartitions().contains(partition)) {
            return 1;
        }
        if (this.compressIntEqual && this.varClass.getIntEqualPartitions().contains(partition)) {
            Set<BigInteger> values = partition.getValues();
            int N = values.size();
            if (!values.contains(BigInteger.ZERO)) {
                ++N;
            }
            if (!values.contains(BigInteger.ONE)) {
                ++N;
            }
            int M = partition.getVars().size();
            return (int)Math.ceil(Math.log(N + M) / Math.log(2.0));
        }
        return this.machineModel.getSizeof(type) * this.machineModel.getSizeofCharInBits();
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState state, List<AbstractState> states, CFAEdge cfaEdge, Precision precision) {
        return null;
    }

    void printStatistics(PrintStream out) {
        Set<VariableClassification.Partition> intBool = this.varClass.getIntBoolPartitions();
        int numOfBooleans = this.varClass.getIntBoolVars().size();
        int numOfIntEquals = 0;
        Set<VariableClassification.Partition> intEq = this.varClass.getIntEqualPartitions();
        for (VariableClassification.Partition p : intEq) {
            numOfIntEquals += p.getVars().size();
        }
        int numOfIntAdds = 0;
        Set<VariableClassification.Partition> intAdd = this.varClass.getIntAddPartitions();
        for (VariableClassification.Partition p : intAdd) {
            numOfIntAdds += p.getVars().size();
        }
        TreeSet<String> trackedIntBool = new TreeSet<String>();
        TreeSet<String> trackedIntEq = new TreeSet<String>();
        TreeSet<String> trackedIntAdd = new TreeSet<String>();
        for (String var : this.predmgr.getTrackedVars().keySet()) {
            if (this.varClass.getIntBoolVars().contains(var)) {
                trackedIntBool.add(var);
                continue;
            }
            if (this.varClass.getIntEqualVars().contains(var)) {
                trackedIntEq.add(var);
                continue;
            }
            if (!this.varClass.getIntAddVars().contains(var)) continue;
            trackedIntAdd.add(var);
        }
        if (this.dumpfile != null) {
            try (Writer w = Files.openOutputFile((Path)this.dumpfile, (FileWriteMode[])new FileWriteMode[0]);){
                w.append("Boolean\n\n");
                w.append(((Object)trackedIntBool).toString());
                w.append("\n\nIntEq\n\n");
                w.append(((Object)trackedIntEq).toString());
                w.append("\n\nIntAdd\n\n");
                w.append(((Object)trackedIntAdd).toString());
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write tracked variables for BDDCPA to file");
            }
        }
        out.println(String.format("Number of boolean vars:           %d (of %d)", trackedIntBool.size(), numOfBooleans));
        out.println(String.format("Number of intEqual vars:          %d (of %d)", trackedIntEq.size(), numOfIntEquals));
        out.println(String.format("Number of intAdd vars:            %d (of %d)", trackedIntAdd.size(), numOfIntAdds));
        out.println(String.format("Number of all vars:               %d", trackedIntBool.size() + trackedIntEq.size() + trackedIntAdd.size()));
        out.println("Number of intBool partitions:     " + intBool.size());
        out.println("Number of intEq partitions:       " + intEq.size());
        out.println("Number of intAdd partitions:      " + intAdd.size());
        out.println("Number of all partitions:         " + this.varClass.getPartitions().size());
        this.rmgr.printStatistics(out);
    }

    private static class VarCExpressionVisitor
    extends DefaultCExpressionVisitor<Boolean, RuntimeException> {
        private String varName;

        VarCExpressionVisitor(String var) {
            this.varName = var;
        }

        private Boolean handle(CExpression exp) {
            return this.varName.equals(exp.toASTString());
        }

        @Override
        public Boolean visit(CArraySubscriptExpression exp) {
            return this.handle(exp);
        }

        @Override
        public Boolean visit(CBinaryExpression exp) {
            return exp.getOperand1().accept(this) != false || exp.getOperand2().accept(this) != false;
        }

        @Override
        public Boolean visit(CCastExpression exp) {
            return exp.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CComplexCastExpression exp) {
            return exp.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CFieldReference exp) {
            return this.handle(exp);
        }

        @Override
        public Boolean visit(CIdExpression exp) {
            return this.varName.equals(exp.getDeclaration().getQualifiedName());
        }

        @Override
        public Boolean visit(CUnaryExpression exp) {
            return exp.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CPointerExpression exp) {
            return exp.getOperand().accept(this);
        }

        @Override
        protected Boolean visitDefault(CExpression pExp) {
            return false;
        }
    }
}

