/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.math.BigInteger;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

public class BDDVectorCExpressionVisitor
extends DefaultCExpressionVisitor<Region[], RuntimeException> {
    private final MachineModel machineModel;
    private final PredicateManager predMgr;
    private final VariableTrackingPrecision precision;
    protected final BitvectorManager bvmgr;
    private final CFANode location;

    protected BDDVectorCExpressionVisitor(PredicateManager pPredMgr, VariableTrackingPrecision pPrecision, BitvectorManager pBVmgr, MachineModel pMachineModel, CFANode pLocation) {
        this.predMgr = pPredMgr;
        this.precision = pPrecision;
        this.bvmgr = pBVmgr;
        this.machineModel = pMachineModel;
        this.location = pLocation;
    }

    @Override
    protected Region[] visitDefault(CExpression pExp) {
        return null;
    }

    @Override
    public Region[] visit(CBinaryExpression pE) {
        Region[] lVal = pE.getOperand1().accept(this);
        Region[] rVal = pE.getOperand2().accept(this);
        if (lVal == null || rVal == null) {
            return null;
        }
        return BDDVectorCExpressionVisitor.calculateBinaryOperation(lVal, rVal, this.bvmgr, pE, this.machineModel);
    }

    public static Region[] calculateBinaryOperation(Region[] lVal, Region[] rVal, BitvectorManager bvmgr, CBinaryExpression binaryExpr, MachineModel machineModel) {
        Region[] result;
        CBinaryExpression.BinaryOperator binaryOperator = binaryExpr.getOperator();
        CType calculationType = binaryExpr.getCalculationType();
        lVal = BDDVectorCExpressionVisitor.castCValue(lVal, calculationType, bvmgr, machineModel);
        if (binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_LEFT && binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_RIGHT) {
            rVal = BDDVectorCExpressionVisitor.castCValue(rVal, calculationType, bvmgr, machineModel);
        }
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULO: 
            case MULTIPLY: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                result = BDDVectorCExpressionVisitor.arithmeticOperation(lVal, rVal, bvmgr, binaryOperator, calculationType, machineModel);
                result = BDDVectorCExpressionVisitor.castCValue(result, binaryExpr.getExpressionType(), bvmgr, machineModel);
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                CSimpleType st;
                Region tmp = BDDVectorCExpressionVisitor.booleanOperation(lVal, rVal, bvmgr, binaryOperator, calculationType, machineModel);
                int size = 32;
                if (calculationType instanceof CSimpleType && ((st = (CSimpleType)calculationType).getType() == CBasicType.INT || st.getType() == CBasicType.CHAR)) {
                    int bitPerByte = machineModel.getSizeofCharInBits();
                    int numBytes = machineModel.getSizeof(st);
                    size = bitPerByte * numBytes;
                }
                result = bvmgr.wrapLast(tmp, size);
                break;
            }
            default: {
                throw new AssertionError((Object)"unhandled binary operator");
            }
        }
        return result;
    }

    private static Region[] arithmeticOperation(Region[] l, Region[] r, BitvectorManager bvmgr, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel) {
        switch (op) {
            case PLUS: {
                return bvmgr.makeAdd(l, r);
            }
            case MINUS: {
                return bvmgr.makeSub(l, r);
            }
            case DIVIDE: 
            case MODULO: 
            case MULTIPLY: {
                return null;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                return null;
            }
            case BINARY_AND: {
                return bvmgr.makeBinaryAnd(l, r);
            }
            case BINARY_OR: {
                return bvmgr.makeBinaryOr(l, r);
            }
            case BINARY_XOR: {
                return bvmgr.makeXor(l, r);
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    protected static Region booleanOperation(Region[] l, Region[] r, BitvectorManager bvmgr, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel) {
        boolean signed = true;
        if (calculationType instanceof CSimpleType) {
            signed = !((CSimpleType)calculationType).isUnsigned();
        }
        switch (op) {
            case EQUALS: {
                return bvmgr.makeLogicalEqual(l, r);
            }
            case NOT_EQUALS: {
                return bvmgr.makeNot(bvmgr.makeLogicalEqual(l, r));
            }
            case GREATER_THAN: {
                return bvmgr.makeLess(r, l, signed);
            }
            case GREATER_EQUAL: {
                return bvmgr.makeLessOrEqual(r, l, signed);
            }
            case LESS_THAN: {
                return bvmgr.makeLess(l, r, signed);
            }
            case LESS_EQUAL: {
                return bvmgr.makeLessOrEqual(l, r, signed);
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    @Override
    public Region[] visit(CCastExpression pE) {
        return BDDVectorCExpressionVisitor.castCValue(pE.getOperand().accept(this), pE.getExpressionType(), this.bvmgr, this.machineModel);
    }

    @Override
    public Region[] visit(CCharLiteralExpression pE) {
        return this.bvmgr.makeNumber(pE.getCharacter(), this.getSize(pE.getExpressionType()));
    }

    @Override
    public Region[] visit(CIntegerLiteralExpression pE) {
        return this.bvmgr.makeNumber(pE.asLong(), this.getSize(pE.getExpressionType()));
    }

    @Override
    public Region[] visit(CImaginaryLiteralExpression pE) {
        return pE.getValue().accept(this);
    }

    @Override
    public Region[] visit(CTypeIdExpression pE) {
        CTypeIdExpression.TypeIdOperator idOperator = pE.getOperator();
        CType innerType = pE.getType();
        switch (idOperator) {
            case SIZEOF: {
                return this.getSizeof(innerType);
            }
        }
        return null;
    }

    @Override
    public Region[] visit(CIdExpression idExp) {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            if (enumerator.hasValue()) {
                return this.bvmgr.makeNumber(enumerator.getValue(), this.getSize(idExp.getExpressionType()));
            }
            return null;
        }
        return this.predMgr.createPredicate(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.location, this.getSize(idExp.getExpressionType()), this.precision);
    }

    @Override
    public Region[] visit(CUnaryExpression unaryExpression) {
        CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        CExpression unaryOperand = unaryExpression.getOperand();
        if (unaryOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
            return this.getSizeof(unaryOperand.getExpressionType());
        }
        Region[] value = unaryOperand.accept(this);
        if (value == null) {
            return null;
        }
        switch (unaryOperator) {
            case MINUS: {
                return this.bvmgr.makeSub(this.bvmgr.makeNumber(BigInteger.ZERO, value.length), value);
            }
            case SIZEOF: {
                throw new AssertionError((Object)"SIZEOF should be handled before!");
            }
            case AMPER: {
                return this.getSizeof(unaryOperand.getExpressionType());
            }
        }
        return null;
    }

    private Region[] getSizeof(CType pType) {
        return this.bvmgr.makeNumber(this.machineModel.getSizeof(pType), this.machineModel.getSizeofInt());
    }

    private int getSize(CType pType) {
        return this.machineModel.getSizeof(pType) * this.machineModel.getSizeofCharInBits();
    }

    public Region[] evaluate(CExpression pExp, CType pTargetType) throws UnrecognizedCCodeException {
        return BDDVectorCExpressionVisitor.castCValue(pExp.accept(this), pTargetType, this.bvmgr, this.machineModel);
    }

    public static Region[] castCValue(@Nullable Region[] value, CType targetType, BitvectorManager bvmgr, MachineModel machineModel) {
        CSimpleType st;
        if (value == null) {
            return null;
        }
        CType type = targetType.getCanonicalType();
        if (type instanceof CSimpleType && ((st = (CSimpleType)type).getType() == CBasicType.INT || st.getType() == CBasicType.CHAR)) {
            int bitPerByte = machineModel.getSizeofCharInBits();
            int numBytes = machineModel.getSizeof(st);
            int size = bitPerByte * numBytes;
            Region[] result = bvmgr.toBitsize(size, st.isSigned(), value);
            return result;
        }
        return value;
    }
}

