/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Collection;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.bdd.BDDCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.Precisions;

public class BddRefiner
extends AbstractARGBasedRefiner
implements Statistics,
StatisticsProvider {
    private final ValueAnalysisPathInterpolator interpolatingRefiner;
    private final CFA cfa;
    private final LogManager logger;
    private final Configuration config;
    private int previousErrorPathId = -1;
    private int numberOfValueAnalysisRefinements = 0;
    private int numberOfSuccessfulValueAnalysisRefinements = 0;

    public static BddRefiner create(ConfigurableProgramAnalysis cpa) throws CPAException, InvalidConfigurationException {
        if (!(cpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(BddRefiner.class.getSimpleName() + " could not find the BDDCPA");
        }
        WrapperCPA wrapperCpa = (WrapperCPA)((Object)cpa);
        BDDCPA bddCpa = wrapperCpa.retrieveWrappedCpa(BDDCPA.class);
        if (bddCpa == null) {
            throw new InvalidConfigurationException(BddRefiner.class.getSimpleName() + " needs a BDDCPA");
        }
        BddRefiner refiner = BddRefiner.initialiseValueAnalysisRefiner(cpa, bddCpa);
        return refiner;
    }

    private static BddRefiner initialiseValueAnalysisRefiner(ConfigurableProgramAnalysis cpa, BDDCPA pBddCpa) throws CPAException, InvalidConfigurationException {
        Configuration config = pBddCpa.getConfiguration();
        LogManager logger = pBddCpa.getLogger();
        pBddCpa.injectRefinablePrecision();
        return new BddRefiner(config, logger, pBddCpa.getShutdownNotifier(), cpa, pBddCpa.getCFA());
    }

    protected BddRefiner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ConfigurableProgramAnalysis pCpa, CFA pCfa) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        this.interpolatingRefiner = new ValueAnalysisPathInterpolator(pConfig, pLogger, pShutdownNotifier, pCfa);
        this.config = pConfig;
        this.cfa = pCfa;
        this.logger = pLogger;
    }

    @Override
    protected CounterexampleInfo performRefinement(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        MutableARGPath errorPath = pErrorPath.mutableCopy();
        if (!this.isPathFeasable(pErrorPath) && this.performValueAnalysisRefinement(reached, errorPath)) {
            return CounterexampleInfo.spurious();
        }
        return CounterexampleInfo.feasible(pErrorPath, Model.empty());
    }

    private boolean performValueAnalysisRefinement(ARGReachedSet reached, MutableARGPath errorPath) throws CPAException, InterruptedException {
        ++this.numberOfValueAnalysisRefinements;
        int currentErrorPathId = errorPath.toString().hashCode();
        if (currentErrorPathId == this.previousErrorPathId) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, errorPath.immutableCopy());
        }
        this.previousErrorPathId = currentErrorPathId;
        UnmodifiableReachedSet reachedSet = reached.asReachedSet();
        Precision precision = reachedSet.getPrecision(reachedSet.getLastState());
        VariableTrackingPrecision bddPrecision = (VariableTrackingPrecision)Precisions.asIterable(precision).filter(VariableTrackingPrecision.isMatchingCPAClass(BDDCPA.class)).get(0);
        Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment = this.interpolatingRefiner.determinePrecisionIncrement(errorPath);
        Pair<ARGState, CFAEdge> refinementRoot = this.interpolatingRefiner.determineRefinementRoot(errorPath, increment, false);
        if (increment.isEmpty()) {
            return false;
        }
        VariableTrackingPrecision refinedBDDPrecision = bddPrecision.withIncrement(increment);
        ++this.numberOfSuccessfulValueAnalysisRefinements;
        reached.removeSubtree((ARGState)refinementRoot.getFirst(), refinedBDDPrecision, VariableTrackingPrecision.isMatchingCPAClass(BDDCPA.class));
        return true;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
        pStatsCollection.add(this.interpolatingRefiner);
    }

    @Override
    public String getName() {
        return "BddDelegatingRefiner";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        out.println("  number of value analysis refinements:                " + this.numberOfValueAnalysisRefinements);
        out.println("  number of successful valueAnalysis refinements:      " + this.numberOfSuccessfulValueAnalysisRefinements);
    }

    boolean isPathFeasable(ARGPath path) throws CPAException {
        try {
            ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(this.logger, this.cfa, this.config);
            return checker.isFeasible(path);
        }
        catch (InterruptedException | InvalidConfigurationException e) {
            throw new CPAException("counterexample-check failed: ", e);
        }
    }
}

