/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.math.BigInteger;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

public class BitvectorManager {
    private final RegionManager rmgr;

    public BitvectorManager(Configuration config, RegionManager pRmgr) throws InvalidConfigurationException {
        this.rmgr = pRmgr;
    }

    private int getBitSize(Region[] r1, Region[] r2) {
        assert (r1.length == r2.length) : "bitvectors must have equal length";
        return r1.length;
    }

    public Region makeOr(Region[] regions) {
        Region tmp = this.rmgr.makeFalse();
        for (Region r : regions) {
            tmp = this.rmgr.makeOr(tmp, r);
        }
        return tmp;
    }

    public Region[] makeNumber(long n, int size) {
        return this.makeNumber(BigInteger.valueOf(n), size);
    }

    public Region[] makeNumber(BigInteger n, int size) {
        if (n.signum() == -1) {
            n = BigInteger.ONE.shiftLeft(size).add(n);
        }
        Region[] newRegions = new Region[size];
        for (int i = 0; i < size; ++i) {
            newRegions[i] = n.testBit(i) ? this.rmgr.makeTrue() : this.rmgr.makeFalse();
        }
        return newRegions;
    }

    public Region makeNot(Region ... regions) {
        Region tmp = this.rmgr.makeFalse();
        for (Region r : regions) {
            tmp = this.rmgr.makeOr(tmp, r);
        }
        return this.rmgr.makeNot(tmp);
    }

    public Region[] makeBinaryAnd(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeAnd(r1[i], r2[i]);
        }
        return newRegions;
    }

    @Deprecated
    public Region makeLogicalAnd(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region tmp1 = this.rmgr.makeFalse();
        Region tmp2 = this.rmgr.makeFalse();
        for (int i = 0; i < bitsize; ++i) {
            tmp1 = this.rmgr.makeOr(tmp1, r1[i]);
            tmp2 = this.rmgr.makeOr(tmp2, r2[i]);
        }
        return this.rmgr.makeAnd(tmp1, tmp2);
    }

    public Region[] makeBinaryOr(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeOr(r1[i], r2[i]);
        }
        return newRegions;
    }

    @Deprecated
    public Region makeLogicalOr(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region tmp1 = this.rmgr.makeFalse();
        Region tmp2 = this.rmgr.makeFalse();
        for (int i = 0; i < bitsize; ++i) {
            tmp1 = this.rmgr.makeOr(tmp1, r1[i]);
            tmp2 = this.rmgr.makeOr(tmp2, r2[i]);
        }
        return this.rmgr.makeOr(tmp1, tmp2);
    }

    public Region[] makeBinaryEqual(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeEqual(r1[i], r2[i]);
        }
        return newRegions;
    }

    public Region makeLogicalEqual(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region equality = this.rmgr.makeTrue();
        for (int i = 0; i < bitsize; ++i) {
            Region equalPos = this.rmgr.makeEqual(r1[i], r2[i]);
            equality = this.rmgr.makeAnd(equality, equalPos);
        }
        return equality;
    }

    public Region[] makeXor(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeUnequal(r1[i], r2[i]);
        }
        return newRegions;
    }

    public Region[] makeAdd(Region[] r1, Region[] r2) {
        Region carrier = this.rmgr.makeFalse();
        return this.fullAdder(r1, r2, carrier);
    }

    public Region[] makeSub(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] r2tmp = this.makeBinaryEqual(r2, this.makeNumber(BigInteger.ZERO, bitsize));
        Region carrier = this.rmgr.makeTrue();
        return this.fullAdder(r1, r2tmp, carrier);
    }

    private Region[] fullAdder(Region[] r1, Region[] r2, Region carrier) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            Region xor = this.rmgr.makeUnequal(r1[i], r2[i]);
            Region and = this.rmgr.makeAnd(r1[i], r2[i]);
            newRegions[i] = this.rmgr.makeUnequal(carrier, xor);
            Region tmp = this.rmgr.makeAnd(carrier, xor);
            carrier = this.rmgr.makeOr(tmp, and);
        }
        return newRegions;
    }

    public Region makeLess(Region[] A, Region[] B, boolean signed) {
        return this.makeLess(A, B, false, signed);
    }

    public Region makeLessOrEqual(Region[] A, Region[] B, boolean signed) {
        return this.makeLess(A, B, true, signed);
    }

    private Region makeLess(Region[] A, Region[] B, boolean equal, boolean signed) {
        Region equalFirst;
        int bitsize = this.getBitSize(A, B);
        Region less = equal ? this.rmgr.makeTrue() : this.rmgr.makeFalse();
        for (int i = 0; i < (signed ? bitsize - 1 : bitsize); ++i) {
            Region lessFirst = this.rmgr.makeAnd(this.rmgr.makeNot(A[i]), B[i]);
            equalFirst = this.rmgr.makeEqual(A[i], B[i]);
            less = this.rmgr.makeOr(lessFirst, this.rmgr.makeAnd(equalFirst, less));
        }
        if (signed) {
            int firstPos = bitsize - 1;
            Region invLessFirst = this.rmgr.makeAnd(A[firstPos], this.rmgr.makeNot(B[firstPos]));
            equalFirst = this.rmgr.makeEqual(A[firstPos], B[firstPos]);
            less = this.rmgr.makeOr(invLessFirst, this.rmgr.makeAnd(equalFirst, less));
        }
        return less;
    }

    public Region[] wrapLast(Region r, int size) {
        return this.toBitsize(size, false, r);
    }

    public Region[] toBitsize(int bitsize, boolean signed, Region ... regions) {
        assert (regions != null) : "can not expand NULL";
        int min = Math.min(regions.length, bitsize);
        Region[] newRegions = new Region[bitsize];
        System.arraycopy(regions, 0, newRegions, 0, min);
        for (int i = min; i < bitsize; ++i) {
            newRegions[i] = signed ? regions[regions.length - 1] : this.rmgr.makeFalse();
        }
        return newRegions;
    }
}

