/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

public class BitvectorManagerTest {
    private LogManager logger;
    private RegionManager rmgr;
    private BitvectorManager bvmgr;
    private Region[] zero;
    private Region[] one;
    private Region[] two;
    private Region[] n15;

    @Before
    public void init() throws InvalidConfigurationException {
        Configuration config = Configuration.defaultConfiguration();
        this.logger = TestLogManager.getInstance();
        this.rmgr = new BDDManagerFactory(config, this.logger).createRegionManager();
        this.bvmgr = new BitvectorManager(config, this.rmgr);
        this.zero = this.bvmgr.makeNumber(BigInteger.ZERO, 4);
        this.one = this.bvmgr.makeNumber(BigInteger.ONE, 4);
        this.two = this.bvmgr.makeNumber(BigInteger.valueOf(2L), 4);
        this.n15 = this.bvmgr.makeNumber(BigInteger.valueOf(15L), 4);
    }

    private void assertIsTrue(Region r) {
        Assert.assertTrue((boolean)r.isTrue());
    }

    private void assertIsFalse(Region r) {
        Assert.assertTrue((boolean)r.isFalse());
    }

    private void assertEqual(Region[] r1, Region[] r2) {
        Assert.assertTrue((r1.length == r2.length ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])r1, (Object[])r2);
    }

    private void assertDistinct(Region[] r1, Region[] r2) {
        Assert.assertTrue((r1.length == r2.length ? 1 : 0) != 0);
        boolean distinct = false;
        for (int i = 0; i < r1.length; ++i) {
            distinct |= r1[i].equals(r2[i]);
        }
        Assert.assertTrue((boolean)distinct);
    }

    @Test
    public void selfTest() {
        int i;
        this.assertDistinct(this.zero, this.one);
        this.assertDistinct(this.n15, this.one);
        for (i = 0; i < 4; ++i) {
            this.assertIsFalse(this.zero[i]);
        }
        this.assertIsTrue(this.one[0]);
        for (i = 1; i < 4; ++i) {
            this.assertIsFalse(this.one[i]);
        }
    }

    @Test(expected=AssertionError.class)
    public void differentLen() {
        this.bvmgr.makeAdd(this.bvmgr.makeNumber(BigInteger.ONE, 3), this.bvmgr.makeNumber(BigInteger.ONE, 4));
    }

    @Test
    public void addsub() {
        this.assertEqual(this.zero, this.bvmgr.makeAdd(this.zero, this.zero));
        this.assertEqual(this.one, this.bvmgr.makeAdd(this.zero, this.one));
        this.assertEqual(this.two, this.bvmgr.makeAdd(this.one, this.one));
        this.assertEqual(this.two, this.bvmgr.makeAdd(this.two, this.zero));
        this.assertEqual(this.one, this.bvmgr.makeSub(this.one, this.zero));
        this.assertEqual(this.two, this.bvmgr.makeSub(this.two, this.zero));
        this.assertEqual(this.n15, this.bvmgr.makeSub(this.n15, this.zero));
        this.assertEqual(this.zero, this.bvmgr.makeSub(this.zero, this.zero));
        this.assertEqual(this.zero, this.bvmgr.makeSub(this.one, this.one));
        this.assertEqual(this.zero, this.bvmgr.makeSub(this.n15, this.n15));
        this.assertEqual(this.two, this.bvmgr.makeSub(this.two, this.zero));
        this.assertEqual(this.n15, this.bvmgr.makeSub(this.n15, this.zero));
        for (Region[] n : Lists.newArrayList((Object[])new Region[][]{this.zero, this.one, this.two, this.n15})) {
            this.assertEqual(this.zero, this.bvmgr.makeSub(this.bvmgr.makeAdd(this.zero, n), n));
            this.assertEqual(this.one, this.bvmgr.makeSub(this.bvmgr.makeAdd(this.one, n), n));
            this.assertEqual(this.n15, this.bvmgr.makeSub(this.bvmgr.makeAdd(this.n15, n), n));
            this.assertEqual(this.zero, this.bvmgr.makeSub(this.bvmgr.makeAdd(this.zero, n), n));
            this.assertEqual(this.one, this.bvmgr.makeSub(this.bvmgr.makeAdd(this.one, n), n));
            this.assertEqual(this.n15, this.bvmgr.makeSub(this.bvmgr.makeAdd(this.n15, n), n));
            this.assertEqual(this.zero, this.bvmgr.makeAdd(this.bvmgr.makeSub(this.zero, n), n));
            this.assertEqual(this.one, this.bvmgr.makeAdd(this.bvmgr.makeSub(this.one, n), n));
            this.assertEqual(this.n15, this.bvmgr.makeAdd(this.bvmgr.makeSub(this.n15, n), n));
        }
    }

    @Test
    public void bool() {
        this.assertIsFalse(this.bvmgr.makeNot(this.one));
        this.assertIsFalse(this.bvmgr.makeNot(this.two));
        this.assertIsTrue(this.bvmgr.makeNot(this.zero));
        this.assertEqual(this.zero, this.bvmgr.makeBinaryAnd(this.one, this.two));
        this.assertEqual(this.zero, this.bvmgr.makeBinaryAnd(this.one, this.zero));
        this.assertEqual(this.one, this.bvmgr.makeBinaryAnd(this.one, this.one));
        this.assertEqual(this.one, this.bvmgr.makeBinaryAnd(this.one, this.bvmgr.makeAdd(this.one, this.two)));
        this.assertIsTrue(this.bvmgr.makeLogicalEqual(this.one, this.one));
        this.assertIsTrue(this.bvmgr.makeLogicalEqual(this.two, this.two));
        this.assertEqual(this.bvmgr.makeBinaryEqual(this.one, this.one), this.bvmgr.makeSub(this.zero, this.one));
        this.assertEqual(this.bvmgr.makeBinaryEqual(this.zero, this.zero), this.bvmgr.makeSub(this.one, this.two));
        this.assertEqual(this.bvmgr.makeXor(this.one, this.two), this.bvmgr.makeAdd(this.one, this.two));
        this.assertEqual(this.bvmgr.makeXor(this.one, this.zero), this.one);
    }

    @Test
    public void signedLen4() {
        this.assertEqual(this.zero, this.bvmgr.makeAdd(this.n15, this.one));
        this.assertEqual(this.one, this.bvmgr.makeAdd(this.n15, this.two));
        this.assertEqual(this.n15, this.bvmgr.makeSub(this.zero, this.one));
        this.assertEqual(this.n15, this.bvmgr.makeSub(this.one, this.two));
        Region[] sum = this.one;
        for (int i = 0; i < 4; ++i) {
            sum = this.bvmgr.makeAdd(sum, sum);
        }
        this.assertEqual(this.zero, sum);
    }

    @Test
    public void lessSigned() {
        this.assertIsFalse(this.bvmgr.makeLess(this.one, this.zero, true));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.one, true));
        this.assertIsFalse(this.bvmgr.makeLess(this.zero, this.zero, true));
        this.assertIsFalse(this.bvmgr.makeLess(this.two, this.two, true));
        this.assertIsTrue(this.bvmgr.makeLess(this.n15, this.zero, true));
        this.assertIsFalse(this.bvmgr.makeLess(this.zero, this.n15, true));
        this.assertIsFalse(this.bvmgr.makeLess(this.n15, this.n15, true));
    }

    @Test
    public void lessUnsigned() {
        this.assertIsFalse(this.bvmgr.makeLess(this.one, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.one, false));
        this.assertIsFalse(this.bvmgr.makeLess(this.zero, this.zero, false));
        this.assertIsFalse(this.bvmgr.makeLess(this.two, this.two, false));
        this.assertIsFalse(this.bvmgr.makeLess(this.n15, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.n15, false));
        this.assertIsFalse(this.bvmgr.makeLess(this.n15, this.n15, false));
    }

    @Test
    public void lessOrEqualSigned() {
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.one, this.zero, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.one, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.zero, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.two, this.two, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.n15, this.zero, true));
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.zero, this.n15, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.n15, this.n15, true));
    }

    @Test
    public void lessOrEqualUnsigned() {
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.one, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.one, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.two, this.two, false));
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.n15, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.n15, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.n15, this.n15, false));
    }
}

