/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDPartitionOrderer;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;

@Options(prefix="cpa.bdd")
public class PredicateManager {
    @Option(secure=true, description="declare first bit of all vars, then second bit,...")
    private boolean initBitwise = true;
    @Option(secure=true, description="declare the bits of a var from 0 to N or from N to 0")
    private boolean initBitsIncreasing = true;
    @Option(secure=true, description="declare partitions ordered")
    private boolean initPartitionsOrdered = true;
    @Option(secure=true, description="declare vars partitionwise")
    private boolean initPartitions = true;
    protected static final String TMP_VARIABLE = "__CPAchecker_tmp_var";
    private final Map<Collection<String>, String> varsToTmpVar = new HashMap<Collection<String>, String>();
    private final Map<String, Integer> trackedVars = new HashMap<String, Integer>();
    private final NamedRegionManager rmgr;

    public PredicateManager(Configuration config, NamedRegionManager pRmgr, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.rmgr = pRmgr;
        if (this.initPartitions) {
            this.initVars(pCfa);
        }
    }

    public Map<String, Integer> getTrackedVars() {
        return this.trackedVars;
    }

    public String getTmpVariableForVars(Collection<String> vars) {
        if (this.initPartitions) {
            return this.varsToTmpVar.get(vars);
        }
        return TMP_VARIABLE;
    }

    protected void initVars(CFA cfa) {
        Collection<VariableClassification.Partition> partitions;
        if (this.initPartitionsOrdered) {
            BDDPartitionOrderer d = new BDDPartitionOrderer(cfa);
            partitions = d.getOrderedPartitions();
        } else {
            assert (cfa.getVarClassification().isPresent());
            partitions = ((VariableClassification)cfa.getVarClassification().get()).getPartitions();
        }
        MachineModel machineModel = cfa.getMachineModel();
        for (VariableClassification.Partition partition : partitions) {
            this.createPredicates(partition.getVars(), machineModel.getSizeofLongLongInt() * machineModel.getSizeofCharInBits());
        }
    }

    public void createPredicates(Collection<String> vars, int bitsize) {
        block7: {
            String tmpVar;
            block6: {
                assert (bitsize >= 1) : "you need at least one bit for a variable.";
                tmpVar = "__CPAchecker_tmp_var_" + this.varsToTmpVar.size();
                this.varsToTmpVar.put(vars, tmpVar);
                if (!this.initBitwise) break block6;
                boolean isTrackingSomething = false;
                for (int i = 0; i < bitsize; ++i) {
                    int index = this.initBitsIncreasing ? i : bitsize - i - 1;
                    for (String var : vars) {
                        this.createPredicateDirectly(var, index);
                        isTrackingSomething = true;
                    }
                    if (!isTrackingSomething) continue;
                    this.createPredicateDirectly(tmpVar, index);
                }
                break block7;
            }
            boolean isTrackingSomething = false;
            for (String var : vars) {
                for (int i = 0; i < bitsize; ++i) {
                    int index = this.initBitsIncreasing ? i : bitsize - i - 1;
                    this.createPredicateDirectly(var, index);
                    isTrackingSomething = true;
                }
            }
            if (!isTrackingSomething) break block7;
            for (int i = 0; i < bitsize; ++i) {
                int index = this.initBitsIncreasing ? i : bitsize - i - 1;
                this.createPredicateDirectly(tmpVar, index);
            }
        }
    }

    private Region createPredicateDirectly(String varName, int index) {
        return this.rmgr.createPredicate(varName + "@" + index);
    }

    protected Region[] createPredicateWithoutPrecisionCheck(String varName, int size) {
        this.trackedVars.put(varName, size);
        Region[] newRegions = new Region[size];
        for (int i = size - 1; i >= 0; --i) {
            newRegions[i] = this.createPredicateDirectly(varName, i);
        }
        return newRegions;
    }

    protected Region[] createPredicate(String varName, CType varType, CFANode location, int size, VariableTrackingPrecision precision) {
        if (precision != null && !precision.isTracking(ValueAnalysisState.MemoryLocation.valueOf(varName), varType, location)) {
            return null;
        }
        return this.createPredicateWithoutPrecisionCheck(varName, size);
    }
}

