/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackPCCAbstractDomain;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackReducer;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class CallstackCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    private final Reducer reducer = new CallstackReducer();
    private final CFA cfa;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(CallstackCPA.class);
    }

    public CallstackCPA(Configuration config, LogManager pLogger, CFA pCFA) throws InvalidConfigurationException {
        super("sep", "sep", new DomainInitializer(config).initializeDomain(), new CallstackTransferRelation(config, pLogger));
        this.cfa = pCFA;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        LoopStructure.Loop singleLoop;
        LoopStructure loopStructure;
        ImmutableCollection<LoopStructure.Loop> artificialLoops;
        if (this.cfa.getLoopStructure().isPresent() && !(artificialLoops = (loopStructure = (LoopStructure)this.cfa.getLoopStructure().get()).getLoopsForFunction(" ")).isEmpty() && (singleLoop = (LoopStructure.Loop)Iterables.getOnlyElement(artificialLoops)).getLoopNodes().contains((Object)pNode)) {
            return new CallstackState(null, " ", pNode);
        }
        return new CallstackState(null, pNode.getFunctionName(), pNode);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> computedSuccessors = this.getTransferRelation().getAbstractSuccessorsForEdge(pElement, SingletonPrecision.getInstance(), pCfaEdge);
        if (!(pSuccessors instanceof Set) || !(computedSuccessors instanceof Set) || pSuccessors.size() != computedSuccessors.size()) {
            return false;
        }
        for (AbstractState abstractState : pSuccessors) {
            boolean found = false;
            for (AbstractState abstractState2 : computedSuccessors) {
                if (!((CallstackState)abstractState).sameStateInProofChecking((CallstackState)abstractState2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        return this.getAbstractDomain().isLessOrEqual(pElement, pOtherElement) || ((CallstackState)pElement).sameStateInProofChecking((CallstackState)pOtherElement);
    }

    @Options(prefix="cpa.callstack")
    private static class DomainInitializer {
        @Option(secure=true, name="domain", toUppercase=true, values={"FLAT", "FLATPCC"}, description="which abstract domain to use for callstack cpa, typically FLAT which is faster since it uses only object equivalence")
        private String domainType = "FLAT";

        public DomainInitializer(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }

        public AbstractDomain initializeDomain() throws InvalidConfigurationException {
            switch (this.domainType) {
                case "FLAT": {
                    return new FlatLatticeDomain();
                }
                case "FLATPCC": {
                    return new CallstackPCCAbstractDomain();
                }
            }
            throw new InvalidConfigurationException("Unknown domain type for callstack cpa.");
        }
    }
}

