/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;

public class CallstackReducer
implements Reducer {
    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pContext, CFANode callNode) {
        CallstackState element = (CallstackState)pExpandedState;
        return this.copyCallstackUpToCallNode(element, callNode);
    }

    private CallstackState copyCallstackUpToCallNode(CallstackState element, CFANode callNode) {
        if (element.getCurrentFunction().equals(callNode.getFunctionName())) {
            return new CallstackState(null, element.getCurrentFunction(), callNode);
        }
        assert (element.getPreviousState() != null);
        CallstackState recursiveResult = this.copyCallstackUpToCallNode(element.getPreviousState(), callNode);
        return new CallstackState(recursiveResult, element.getCurrentFunction(), element.getCallNode());
    }

    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        CallstackState rootState = (CallstackState)pRootState;
        CallstackState reducedState = (CallstackState)pReducedState;
        return this.copyCallstackExceptLast(rootState, reducedState);
    }

    private CallstackState copyCallstackExceptLast(CallstackState target, CallstackState source) {
        if (source.getDepth() == 1) {
            assert (source.getPreviousState() == null);
            assert (source.getCurrentFunction().equals(target.getCurrentFunction())) : "names of functions do not match: '" + source.getCurrentFunction() + "' != '" + target.getCurrentFunction() + "'";
            return target;
        }
        CallstackState recursiveResult = this.copyCallstackExceptLast(target, source.getPreviousState());
        return new CallstackState(recursiveResult, source.getCurrentFunction(), source.getCallNode());
    }

    private static boolean isEqual(CallstackState reducedTargetElement, CallstackState candidateElement) {
        if (reducedTargetElement.getDepth() != candidateElement.getDepth()) {
            return false;
        }
        while (reducedTargetElement != null) {
            if (!reducedTargetElement.getCallNode().equals(candidateElement.getCallNode()) || !reducedTargetElement.getCurrentFunction().equals(candidateElement.getCurrentFunction())) {
                return false;
            }
            reducedTargetElement = reducedTargetElement.getPreviousState();
            candidateElement = candidateElement.getPreviousState();
        }
        return true;
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        return new CallstackStateWithEquals((CallstackState)pElementKey);
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        return pPrecision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        return reducedPrecision;
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        return 0;
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        return this.getVariableReducedState(pExpandedState, pContext, pCallNode);
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        return this.getVariableExpandedState(pRootState, pReducedContext, pReducedState);
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState rootState, AbstractState entryState, AbstractState expandedState, CFANode exitLocation) {
        return expandedState;
    }

    private static class CallstackStateWithEquals {
        private final CallstackState state;

        public CallstackStateWithEquals(CallstackState pElement) {
            this.state = pElement;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CallstackStateWithEquals)) {
                return false;
            }
            return CallstackReducer.isEqual(this.state, ((CallstackStateWithEquals)other).state);
        }

        public int hashCode() {
            return (this.state.getDepth() * 17 + this.state.getCurrentFunction().hashCode()) * 31 + this.state.getCallNode().hashCode();
        }
    }
}

