/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public final class CallstackState
implements AbstractState,
Partitionable,
AbstractQueryableState,
Serializable {
    private static final long serialVersionUID = 3629687385150064994L;
    private final CallstackState previousState;
    private final String currentFunction;
    private transient CFANode callerNode;
    private final int depth;

    CallstackState(CallstackState previousElement, @Nonnull String function, @Nonnull CFANode callerNode) {
        this.previousState = previousElement;
        this.currentFunction = (String)Preconditions.checkNotNull((Object)function);
        this.callerNode = (CFANode)Preconditions.checkNotNull((Object)callerNode);
        this.depth = previousElement == null ? 1 : previousElement.getDepth() + 1;
    }

    public CallstackState getPreviousState() {
        return this.previousState;
    }

    public String getCurrentFunction() {
        return this.currentFunction;
    }

    public CFANode getCallNode() {
        return this.callerNode;
    }

    public int getDepth() {
        return this.depth;
    }

    private List<String> getStack() {
        ArrayList<String> stack = new ArrayList<String>();
        for (CallstackState state = this; state != null; state = state.getPreviousState()) {
            stack.add(state.getCurrentFunction());
        }
        return Lists.reverse(stack);
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    public String toString() {
        return "Function " + this.getCurrentFunction() + " called from node " + this.getCallNode() + ", stack depth " + this.getDepth() + " [" + Integer.toHexString(super.hashCode()) + "], stack " + this.getStack();
    }

    public boolean sameStateInProofChecking(CallstackState pOther) {
        return pOther.callerNode == this.callerNode && pOther.depth == this.depth && pOther.currentFunction.equals(this.currentFunction) && (pOther.previousState == this.previousState || this.previousState != null && pOther.previousState != null && this.previousState.sameStateInProofChecking(pOther.previousState));
    }

    @Override
    public String getCPAName() {
        return "Callstack";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        return false;
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.compareToIgnoreCase("caller") == 0) {
            if (this.callerNode != null) {
                return this.callerNode.getFunctionName();
            }
            return "";
        }
        throw new InvalidQueryException(String.format("Evaluating %s not supported by %s", pProperty, this.getClass().getCanonicalName()));
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("modifyProperty not implemented by " + this.getClass().getCanonicalName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.callerNode.getNodeNumber());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int nodeNumber = in.readInt();
        this.callerNode = ((CFAInfo)GlobalInfo.getInstance().getCFAInfo().get()).getNodeByNodeNumber(nodeNumber);
    }
}

