/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssumeEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="cpa.callstack")
public class CallstackTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, name="depth", description="depth of recursion bound")
    protected int recursionBoundDepth = 0;
    @Option(secure=true, name="skipRecursion", description="Skip recursion (this is unsound). Treat function call as a statement (the same as for functions without bodies)")
    protected boolean skipRecursion = false;
    @Option(secure=true, description="Skip recursion if it happens only by going via a function pointer (this is unsound). Imprecise function pointer tracking often lead to false recursions.")
    protected boolean skipFunctionPointerRecursion = false;
    @Option(secure=true, description="Skip recursion if it happens only by going via a void function (this is unsound).")
    protected boolean skipVoidRecursion = false;
    protected final LogManagerWithoutDuplicates logger;

    public CallstackTransferRelation(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pEdge) throws CPATransferException {
        CallstackState e = (CallstackState)pElement;
        CFANode pred = pEdge.getPredecessor();
        CFANode succ = pEdge.getSuccessor();
        String predFunction = pred.getFunctionName();
        String succFunction = succ.getFunctionName();
        switch (pEdge.getEdgeType()) {
            case StatementEdge: {
                if (!(pEdge instanceof CFunctionSummaryStatementEdge) || this.shouldGoByFunctionSummaryStatement(e, (CFunctionSummaryStatementEdge)pEdge)) break;
                return Collections.emptySet();
            }
            case AssumeEdge: {
                boolean isFunctionTransition;
                boolean successorIsInCallstackContext = succFunction.equals(e.getCurrentFunction());
                boolean isArtificialPCVEdge = pEdge instanceof ProgramCounterValueAssumeEdge;
                boolean isSuccessorAritificialPCNode = succFunction.equals(" ");
                boolean isPredecessorAritificialPCNode = predFunction.equals(" ");
                boolean bl = isFunctionTransition = !succFunction.equals(predFunction);
                if (successorIsInCallstackContext || e.getCurrentFunction().equals(" ") || (isSuccessorAritificialPCNode || !isArtificialPCVEdge) && (!isPredecessorAritificialPCNode || !isFunctionTransition)) break;
                return Collections.emptySet();
            }
            case FunctionCallEdge: {
                String calledFunction = succ.getFunctionName();
                CFANode callerNode = pred;
                if (this.hasRecursion(e, calledFunction)) {
                    if (this.skipRecursiveFunctionCall(e, (FunctionCallEdge)pEdge)) {
                        this.logger.logOnce(Level.WARNING, new Object[]{"Skipping recursive function call from", pred.getFunctionName(), "to", calledFunction});
                        return Collections.emptySet();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Recursion detected, aborting. To ignore recursion, add -skipRecursion to the command line."});
                    throw new UnsupportedCCodeException("recursion", pEdge);
                }
                return Collections.singleton(new CallstackState(e, calledFunction, callerNode));
            }
            case FunctionReturnEdge: {
                CallstackState returnElement;
                String calledFunction = predFunction;
                String callerFunction = succFunction;
                CFANode callNode = succ.getEnteringSummaryEdge().getPredecessor();
                assert (calledFunction.equals(e.getCurrentFunction()) || e.getCurrentFunction().equals(" "));
                if (this.isWildcardState(e)) {
                    returnElement = e;
                } else {
                    if (!callNode.equals(e.getCallNode())) {
                        return Collections.emptySet();
                    }
                    returnElement = e.getPreviousState();
                    assert (callerFunction.equals(returnElement.getCurrentFunction()) || this.isWildcardState(returnElement));
                }
                return Collections.singleton(returnElement);
            }
        }
        return Collections.singleton(pElement);
    }

    protected boolean isWildcardState(CallstackState pState) {
        return pState.getCurrentFunction().equals(" ");
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, List<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }

    protected boolean skipRecursiveFunctionCall(CallstackState element, FunctionCallEdge callEdge) {
        if (this.skipRecursion) {
            return true;
        }
        if (this.skipFunctionPointerRecursion && this.hasFunctionPointerRecursion(element, callEdge)) {
            return true;
        }
        return this.skipVoidRecursion && this.hasVoidRecursion(element, callEdge);
    }

    protected boolean hasRecursion(CallstackState pCurrentState, String pCalledFunction) {
        int counter = 0;
        for (CallstackState e = pCurrentState; e != null; e = e.getPreviousState()) {
            if (!e.getCurrentFunction().equals(pCalledFunction) || ++counter <= this.recursionBoundDepth) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFunctionPointerRecursion(CallstackState element, FunctionCallEdge pCallEdge) {
        if (pCallEdge.getRawStatement().startsWith("pointer call(")) {
            return true;
        }
        String functionName = pCallEdge.getSuccessor().getFunctionName();
        for (CallstackState e = element; e != null; e = e.getPreviousState()) {
            if (e.getCurrentFunction().equals(functionName)) {
                return false;
            }
            FunctionCallEdge callEdge = this.findOutgoingCallEdge(element.getCallNode());
            if (!callEdge.getRawStatement().startsWith("pointer call(")) continue;
            return true;
        }
        throw new AssertionError();
    }

    protected boolean hasVoidRecursion(CallstackState element, FunctionCallEdge pCallEdge) {
        if (pCallEdge.getSummaryEdge().getExpression() instanceof AFunctionCallStatement) {
            return true;
        }
        String functionName = pCallEdge.getSuccessor().getFunctionName();
        for (CallstackState e = element; e != null; e = e.getPreviousState()) {
            if (e.getCurrentFunction().equals(functionName)) {
                return false;
            }
            FunctionSummaryEdge summaryEdge = element.getCallNode().getLeavingSummaryEdge();
            if (!(summaryEdge.getExpression() instanceof AFunctionCallStatement)) continue;
            return true;
        }
        throw new AssertionError();
    }

    protected boolean shouldGoByFunctionSummaryStatement(CallstackState element, CFunctionSummaryStatementEdge sumEdge) {
        String functionName = sumEdge.getFunctionName();
        FunctionCallEdge callEdge = this.findOutgoingCallEdge(sumEdge.getPredecessor());
        assert (functionName.equals(callEdge.getSuccessor().getFunctionName()));
        return this.hasRecursion(element, functionName) && this.skipRecursiveFunctionCall(element, callEdge);
    }

    protected FunctionCallEdge findOutgoingCallEdge(CFANode predNode) {
        for (CFAEdge edge : CFAUtils.leavingEdges(predNode)) {
            if (edge.getEdgeType() != CFAEdgeType.FunctionCallEdge) continue;
            return (FunctionCallEdge)edge;
        }
        throw new AssertionError((Object)"Missing function call edge for function call summary edge");
    }
}

