/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssumeEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="cpa.callstack")
public class CallstackTransferRelationBackwards
extends CallstackTransferRelation {
    public CallstackTransferRelationBackwards(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        super(pConfig, pLogger);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pEdge) throws CPATransferException {
        CallstackState e = (CallstackState)pElement;
        CFANode nextAnalysisLoc = pEdge.getPredecessor();
        CFANode prevAnalysisLoc = pEdge.getSuccessor();
        String prevAnalysisFunction = prevAnalysisLoc.getFunctionName();
        String nextAnalysisFunction = nextAnalysisLoc.getFunctionName();
        switch (pEdge.getEdgeType()) {
            case StatementEdge: {
                if (!(pEdge instanceof CFunctionSummaryStatementEdge) || this.shouldGoByFunctionSummaryStatement(e, (CFunctionSummaryStatementEdge)pEdge)) break;
                return Collections.emptySet();
            }
            case AssumeEdge: {
                if (!(pEdge instanceof ProgramCounterValueAssumeEdge)) break;
                throw new UnsupportedCCodeException("ProgramCounterValueAssumeEdge not yet supported for the backwards analysis!", pEdge);
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge edge = (FunctionReturnEdge)pEdge;
                CFANode correspondingCallNode = edge.getSummaryEdge().getPredecessor();
                if (this.hasRecursion(e, nextAnalysisFunction)) {
                    if (this.skipRecursion) {
                        this.logger.logOnce(Level.WARNING, new Object[]{"Skipping recursive function call from", prevAnalysisFunction, "to", nextAnalysisFunction});
                        return Collections.emptySet();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Recursion detected, aborting. To ignore recursion, add -skipRecursion to the command line."});
                    throw new UnsupportedCCodeException("recursion", pEdge);
                }
                return Collections.singleton(new CallstackState(e, nextAnalysisFunction, correspondingCallNode));
            }
            case FunctionCallEdge: {
                if (this.isWildcardState(e)) {
                    throw new UnsupportedCCodeException("ARTIFICIAL_PROGRAM_COUNTER not yet supported for the backwards analysis!", pEdge);
                }
                CallstackState nextStackState = e.getPreviousState();
                Set<Object> result = nextStackState == null ? Collections.singleton(new CallstackState(null, nextAnalysisFunction, nextAnalysisLoc)) : (e.getCallNode().equals(nextAnalysisLoc) ? Collections.singleton(nextStackState) : Collections.emptySet());
                return result;
            }
        }
        return Collections.singleton(pElement);
    }

    @Override
    protected FunctionCallEdge findOutgoingCallEdge(CFANode predNode) {
        for (CFAEdge edge : CFAUtils.leavingEdges(predNode)) {
            if (edge.getEdgeType() != CFAEdgeType.FunctionCallEdge) continue;
            return (FunctionCallEdge)edge;
        }
        throw new AssertionError((Object)"Missing function call edge for function call summary edge");
    }
}

