/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cfapath;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.cfapath.CFAPathState;

public class CFAPathStandardState
implements CFAPathState,
Iterable<CFAEdge> {
    private static final CFAPathStandardState sEmptyPath = new CFAPathStandardState();
    private final CFAPathStandardState mPredecessor;
    private final CFAEdge mCFAEdge;
    private final int mLength;

    public static CFAPathStandardState getEmptyPath() {
        return sEmptyPath;
    }

    private CFAPathStandardState() {
        this.mPredecessor = null;
        this.mCFAEdge = null;
        this.mLength = 0;
    }

    public CFAPathStandardState(CFAPathStandardState pPredecessor, CFAEdge pCFAEdge) {
        if (pPredecessor == null) {
            throw new IllegalArgumentException();
        }
        if (pCFAEdge == null) {
            throw new IllegalArgumentException();
        }
        this.mPredecessor = pPredecessor;
        this.mCFAEdge = pCFAEdge;
        this.mLength = pPredecessor.getLength() + 1;
    }

    public int getLength() {
        return this.mLength;
    }

    public CFAEdge get(int lIndex) {
        if (lIndex >= this.mLength || lIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (lIndex + 1 == this.mLength) {
            return this.mCFAEdge;
        }
        return this.mPredecessor.get(lIndex);
    }

    @Override
    public Iterator<CFAEdge> iterator() {
        return new CFAEdgeIterator(this);
    }

    public CFAEdge[] toArray() {
        CFAEdge[] lPath = new CFAEdge[this.mLength];
        CFAPathStandardState lElement = this;
        for (int lIndex = this.mLength - 1; lIndex >= 0; --lIndex) {
            lPath[lIndex] = lElement.mCFAEdge;
            lElement = lElement.mPredecessor;
        }
        return lPath;
    }

    public String toString() {
        if (this.getLength() == 0) {
            return "<>";
        }
        if (this.getLength() == 1) {
            return "< " + this.mCFAEdge.toString() + " >";
        }
        return "< ... " + this.mCFAEdge.toString() + " >";
    }

    private static class CFAEdgeIterator
    implements Iterator<CFAEdge> {
        private CFAPathStandardState crrentState;

        public CFAEdgeIterator(CFAPathStandardState pLastElement) {
            this.crrentState = pLastElement;
        }

        @Override
        public boolean hasNext() {
            return this.crrentState != sEmptyPath;
        }

        @Override
        public CFAEdge next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CFAEdge lNextCFAEdge = this.crrentState.mCFAEdge;
            this.crrentState = this.crrentState.mPredecessor;
            return lNextCFAEdge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

