/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.chc.CHCDomain;
import org.sosy_lab.cpachecker.cpa.chc.CHCPrecision;
import org.sosy_lab.cpachecker.cpa.chc.CHCPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.chc.CHCState;
import org.sosy_lab.cpachecker.cpa.chc.CHCTransferRelation;
import org.sosy_lab.cpachecker.cpa.chc.ConstraintManager;

@Options(prefix="cpa.chc")
public class CHCCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider {
    @Option(secure=true, name="firingRelation", values={"Always", "Maxcoeff", "Sumcoeff", "Homeocoeff"}, description="firing relation to be used in the precision adjustment operator")
    private String firingRelation = "Always";
    @Option(secure=true, name="generalizationOperator", values={"Top", "Widen", "WidenMax", "WidenSum"}, description="generalization operator to be used in the precision adjustment operator")
    private String generalizationOperator = "Widen";
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="merge operator to be used")
    private String mergeType = "SEP";
    private final AbstractDomain abstractDomain;
    private final Precision precision;
    private final PrecisionAdjustment precisionAdjustment;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final TransferRelation transferRelation;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(CHCCPA.class);
    }

    private CHCCPA(CFA cfa, Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.abstractDomain = new CHCDomain();
        this.mergeOperator = MergeSepOperator.getInstance();
        this.precision = new CHCPrecision();
        this.precisionAdjustment = new CHCPrecisionAdjustment(logger);
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = new CHCTransferRelation(logger);
        if (!ConstraintManager.init(this.firingRelation, this.generalizationOperator, logger)) {
            logger.log(Level.WARNING, new Object[]{"CLP interpreter initialization failure."});
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        CHCState initialState = new CHCState();
        initialState.setNodeNumber(1);
        return initialState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            }

            @Override
            public String getName() {
                return "CLPCPA";
            }
        });
    }
}

