/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import java.util.ArrayList;
import java.util.HashMap;
import jpl.Term;
import org.sosy_lab.cpachecker.cpa.chc.ConstraintManager;

public class Constraint {
    private ArrayList<Term> cns = null;
    private HashMap<String, Term> vars = null;

    public Constraint() {
        this.cns = new ArrayList();
        this.vars = new HashMap();
    }

    public Constraint(Constraint cn) {
        this.cns = new ArrayList<Term>(cn.getConstraint());
        this.vars = new HashMap<String, Term>(cn.getVars());
    }

    public Constraint(ArrayList<Term> cns, HashMap<String, Term> vars) {
        this.cns = cns;
        this.vars = vars;
    }

    public Constraint(ArrayList<Term> cns) {
        this.cns = cns;
        this.vars = new HashMap();
    }

    public Constraint(ArrayList<Term> cns, ArrayList<Term> vars) {
        this.cns = cns;
        this.createHashMap(vars);
    }

    public Constraint(Term cn, ArrayList<Term> vars) {
        this.cns = new ArrayList();
        this.cns.add(cn);
        this.createHashMap(vars);
    }

    public void addAtomicConstraint(Term t) {
        this.cns.add(t);
    }

    public void addVar(String var, Term t) {
        this.vars.put(var, t);
    }

    public void addVars(HashMap<String, Term> vars) {
        this.vars.putAll(vars);
    }

    public void removeVar(String var) {
        this.vars.remove(var);
    }

    public String toString() {
        if (this.cns == null) {
            return "false";
        }
        if (this.cns.isEmpty()) {
            return "true";
        }
        return this.cns.toString() + " (vars: " + this.vars.toString() + ")";
    }

    public ArrayList<Term> getConstraint() {
        return this.cns;
    }

    public HashMap<String, Term> getVars() {
        return this.vars;
    }

    public boolean isTrue() {
        return this.cns.isEmpty();
    }

    public boolean isFalse() {
        if (this.cns == null) {
            return true;
        }
        return this.cns.size() != 0 && this.cns.get(0).toString().equals("false");
    }

    public static boolean isFalse(String cr) {
        return cr.toString().equals("'.'(false, [])");
    }

    public void setTrue() {
        this.cns = new ArrayList();
    }

    public Constraint setFalse() {
        this.cns = null;
        return this;
    }

    public void and(Constraint cn) {
        this.cns.addAll(cn.getConstraint());
    }

    public Constraint setConstraint(ArrayList<Term> cns) {
        this.cns = cns;
        return this;
    }

    public void emptyVar() {
        this.vars = new HashMap();
    }

    private void createHashMap(ArrayList<Term> varTerms) {
        this.vars = new HashMap();
        for (Term v : varTerms) {
            this.vars.put(ConstraintManager.var2CVar(v.name()), v);
        }
    }
}

