/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import jpl.Compound;
import jpl.JPL;
import jpl.Query;
import jpl.Term;
import jpl.Util;
import jpl.Variable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.chc.Constraint;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class ConstraintManager {
    private static LogManager logger;

    public static boolean init(String firingRelation, String generalizationOperator, LogManager logM) {
        String[] initstr = new String[]{"swipl", "-x", "./lib/native/x86_64-linux/chc_lib", "-g", "true", "-nosignals"};
        boolean init = JPL.init((String[])initstr);
        ConstraintManager.initFiringRelation(firingRelation);
        ConstraintManager.initGeneralizationOperator(generalizationOperator);
        logger = logM;
        return init;
    }

    public static Constraint simplify(ArrayList<Term> cn, HashMap<String, Term> vars) {
        Term constraint = Util.termArrayToList((Term[])cn.toArray(new Term[0]));
        Term varList = Util.termArrayToList((Term[])vars.values().toArray(new Term[0]));
        Term[] args = new Term[]{constraint, varList, new Variable("S")};
        Query q = new Query("solve", args);
        logger.log(Level.FINEST, new Object[]{"\n * solve (w.r.t. " + varList.toString() + ")"});
        Hashtable sol = q.oneSolution();
        return ConstraintManager.normalize("S", sol);
    }

    public static boolean subsumes(Constraint cn1, Constraint cn2) {
        Term constraint1 = Util.termArrayToList((Term[])cn1.getConstraint().toArray(new Term[0]));
        Term constraint2 = Util.termArrayToList((Term[])cn2.getConstraint().toArray(new Term[0]));
        Term[] args = new Term[]{constraint1, constraint2};
        Query q = new Query("entails", args);
        logger.log(Level.FINEST, new Object[]{"\n * " + cn1.toString() + "\n * entails" + "\n * " + cn2.toString() + ")"});
        boolean res = q.hasSolution();
        logger.log(Level.FINEST, new Object[]{"\n * result: " + res});
        return res;
    }

    public static Constraint generalize(Constraint cn1, Constraint cn2, Precision p) {
        Term constraint1 = Util.termArrayToList((Term[])cn1.getConstraint().toArray(new Term[0]));
        Term constraint2 = Util.termArrayToList((Term[])cn2.getConstraint().toArray(new Term[0]));
        Term[] args = new Term[]{constraint1, constraint2, new Variable("G")};
        Query q = new Query("generalize", args);
        logger.log(Level.FINEST, new Object[]{"\n * definition: " + cn1.toString() + "\n * ancestor :  " + cn1.toString()});
        return ConstraintManager.normalize("G", q.oneSolution());
    }

    public static Constraint and(Constraint cn1, Constraint cn2) {
        ArrayList<Term> andCn = new ArrayList<Term>(cn1.getConstraint());
        andCn.addAll(cn2.getConstraint());
        logger.log(Level.FINEST, new Object[]{"\n * " + cn1.toString() + "\n * and \n * " + cn2.toString()});
        HashMap<String, Term> newVars = ConstraintManager.selectVariables(cn1.getVars(), cn2.getVars());
        Constraint andConstraint = ConstraintManager.simplify(andCn, newVars);
        logger.log(Level.FINEST, new Object[]{"\n * " + andConstraint.toString()});
        return andConstraint;
    }

    private static HashMap<String, Term> selectVariables(HashMap<String, Term> vars, HashMap<String, Term> pVars) {
        HashMap<String, Term> newVars = new HashMap<String, Term>(pVars);
        for (Map.Entry<String, Term> me : vars.entrySet()) {
            if (pVars.containsKey(me.getKey())) continue;
            newVars.put(me.getKey(), me.getValue());
        }
        return newVars;
    }

    private static Constraint normalize(String sol, Hashtable<String, Term> varMap) {
        Term cn = varMap.get(sol);
        String newConstraint = cn.toString();
        Constraint nres = new Constraint();
        if (Constraint.isFalse(newConstraint)) {
            return nres.setFalse();
        }
        Hashtable<String, Term> varSolMap = new Hashtable<String, Term>(varMap);
        varSolMap.remove(sol);
        for (Map.Entry<String, Term> me : varSolMap.entrySet()) {
            newConstraint = newConstraint.replaceAll(me.getValue().toString(), ConstraintManager.primedVarToVar(me.getKey()));
            nres.addVar(ConstraintManager.var2CVar(ConstraintManager.primedVarToVar(me.getKey())), (Term)new Variable(ConstraintManager.primedVarToVar(me.getKey())));
        }
        nres.setConstraint(new ArrayList<Term>(Arrays.asList(Util.listToTermArray((Term)Util.textToTerm((String)newConstraint)))));
        logger.log(Level.FINEST, new Object[]{"\n * result: " + nres.toString()});
        return nres;
    }

    public static ArrayList<Constraint> getConstraint(AssumeEdge ae) {
        CBinaryExpression c = (CBinaryExpression)ae.getExpression();
        ArrayList<Constraint> cns = new ArrayList<Constraint>(2);
        if (ae.getTruthAssumption()) {
            Collection<Pair<Term, ArrayList<Term>>> acList = ConstraintManager.expressionToCLP(c);
            for (Pair<Term, ArrayList<Term>> p : acList) {
                cns.add(new Constraint((Term)p.getFirst(), (ArrayList<Term>)((ArrayList)p.getSecond())));
            }
        } else {
            CBinaryExpression negbe = ConstraintManager.getNegatedRelOperator(c);
            Collection<Pair<Term, ArrayList<Term>>> acList = ConstraintManager.expressionToCLP(negbe);
            for (Pair<Term, ArrayList<Term>> p : acList) {
                cns.add(new Constraint((Term)p.getFirst(), (ArrayList<Term>)((ArrayList)p.getSecond())));
            }
        }
        return cns;
    }

    public static Constraint getConstraint(CAssignment ca) {
        Constraint c = new Constraint();
        CLeftHandSide lhs = ca.getLeftHandSide();
        CRightHandSide rhs = ca.getRightHandSide();
        CExpression exp = (CExpression)rhs;
        c.addVar(lhs.toString(), (Term)ConstraintManager.CVar2PrologPrimedVar(lhs.toString()));
        if (lhs instanceof AIdExpression) {
            for (Pair<Term, ArrayList<Term>> t : ConstraintManager.expressionToCLP(exp)) {
                Term[] operands = new Term[]{c.getVars().get(lhs.toString()), (Term)t.getFirst()};
                ArrayList<Term> list = new ArrayList<Term>();
                list.add((Term)new Compound("=:=", operands));
                c.setConstraint(list);
            }
        } else {
            throw new AssertionError((Object)("unhandled assignment " + ca.toString()));
        }
        return c;
    }

    public static Constraint getConstraint(CExpression exp) {
        ArrayList<Term> tlist = new ArrayList<Term>();
        ArrayList<Term> vlist = new ArrayList<Term>();
        for (Pair<Term, ArrayList<Term>> t : ConstraintManager.expressionToCLP(exp)) {
            tlist.add((Term)t.getFirst());
            vlist.addAll((Collection)t.getSecond());
        }
        return new Constraint(tlist, vlist);
    }

    public static ArrayList<Constraint> getConstraint(List<CExpression> exp) {
        ArrayList<Constraint> clist = new ArrayList<Constraint>();
        for (CExpression c : exp) {
            clist.add(ConstraintManager.getConstraint(c));
        }
        return clist;
    }

    public static Constraint getConstraint(ADeclarationEdge ae) {
        CDeclaration decl = (CDeclaration)ae.getDeclaration();
        Constraint ac = new Constraint();
        if (decl instanceof CVariableDeclaration) {
            CVariableDeclaration vdecl = (CVariableDeclaration)decl;
            CInitializer initializer = vdecl.getInitializer();
            String varName = vdecl.getName();
            Variable lhs = ConstraintManager.CVar2PrologPrimedVar(varName);
            if (initializer != null && initializer instanceof CInitializerExpression) {
                CExpression expression = ((CInitializerExpression)initializer).getExpression();
                Collection<Pair<Term, ArrayList<Term>>> at = ConstraintManager.expressionToCLP(expression);
                for (Pair<Term, ArrayList<Term>> t : at) {
                    Term rhs = (Term)t.getFirst();
                    ArrayList<Term> acList = new ArrayList<Term>();
                    acList.add((Term)new Compound("=:=", new Term[]{lhs, rhs}));
                    ac.setConstraint(acList);
                }
            }
            ac.addVar(varName, (Term)lhs);
        }
        return ac;
    }

    public static Constraint getConstraint(AReturnStatementEdge aRetEdge) throws UnrecognizedCCodeException {
        CIntegerLiteralExpression expression = aRetEdge.getExpression().isPresent() ? (AExpression)aRetEdge.getExpression().get() : CIntegerLiteralExpression.ZERO;
        String varName = "FRET_" + aRetEdge.getSuccessor().getFunctionName();
        Variable lhs = ConstraintManager.CVar2PrologVar(varName);
        Constraint ac = new Constraint();
        Collection<Pair<Term, ArrayList<Term>>> at = ConstraintManager.expressionToCLP(expression);
        for (Pair<Term, ArrayList<Term>> t : at) {
            Term rhs = (Term)t.getFirst();
            ArrayList<Term> acList = new ArrayList<Term>();
            acList.add((Term)new Compound("=:=", new Term[]{lhs, rhs}));
            ac.setConstraint(acList);
        }
        ac.addVar(varName, (Term)lhs);
        return ac;
    }

    public static Constraint getConstraint(FunctionReturnEdge fretEdge) throws UnrecognizedCCodeException {
        FunctionSummaryEdge summaryEdge = fretEdge.getSummaryEdge();
        AFunctionCall exprOnSummary = summaryEdge.getExpression();
        if (exprOnSummary instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement assignExp = (AFunctionCallAssignmentStatement)exprOnSummary;
            ALeftHandSide op1 = assignExp.getLeftHandSide();
            if (op1 instanceof AIdExpression || op1 instanceof CFieldReference) {
                String varName = "FRET_" + fretEdge.getPredecessor().getFunctionName();
                Variable lhs = ConstraintManager.CVar2PrologPrimedVar(op1.toString());
                Variable rhs = ConstraintManager.CVar2PrologVar(varName);
                Constraint ac = new Constraint(new ArrayList<Compound>(Collections.singletonList(new Compound("=:=", new Term[]{lhs, rhs}))));
                ac.addVar(op1.toString(), (Term)lhs);
                return ac;
            }
            if (op1 instanceof CArraySubscriptExpression) {
                return new Constraint();
            }
            throw new UnrecognizedCCodeException("on function return", (CFAEdge)summaryEdge, null);
        }
        return new Constraint();
    }

    public static Constraint getConstraint(CExpression lhs, CFunctionCallExpression rhs) {
        Constraint c = new Constraint();
        if (rhs != null) {
            c.addVar(lhs.toString(), (Term)ConstraintManager.CVar2PrologPrimedVar(lhs.toString()));
            if (lhs instanceof AIdExpression) {
                Term[] operands = new Term[]{c.getVars().get(lhs.toString()), ConstraintManager.CVar2PrologVar(rhs.getFunctionNameExpression().toString())};
                ArrayList<Term> list = new ArrayList<Term>();
                list.add((Term)new Compound("=:=", operands));
                c.setConstraint(list);
            }
        }
        return c;
    }

    public static Collection<Constraint> getConstraint(List<String> names, List<? extends AExpression> expressions) {
        ArrayList<Constraint> cnList = new ArrayList<Constraint>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            AExpression expression = expressions.get(i);
            for (Pair<Term, ArrayList<Term>> p : ConstraintManager.paramExpressionToCLP(name, expression)) {
                cnList.add(new Constraint(new ArrayList<Term>(Arrays.asList(Util.listToTermArray((Term)((Term)p.getFirst())))), (ArrayList<Term>)((ArrayList)p.getSecond())));
            }
        }
        return cnList;
    }

    public static String var2CVar(String pv) {
        return pv.substring(4);
    }

    public static String primedVar2CVar(String ppv) {
        return ppv.substring(11);
    }

    public static Variable CVar2PrologVar(String cv) {
        return new Variable("CPA_" + cv);
    }

    public static Variable CVar2PrologPrimedVar(String cv) {
        return new Variable("Primed_CPA_" + cv);
    }

    private static String primedVarToVar(String pvar) {
        if (pvar.startsWith("Primed_")) {
            return pvar.replace("Primed_", "");
        }
        return pvar;
    }

    private static Collection<Pair<Term, ArrayList<Term>>> getNegatedConstraintList(Pair<Term, ArrayList<Term>> cn) {
        Compound atomCnT = (Compound)cn.getFirst();
        Compound negAtomCnT = null;
        switch (atomCnT.name()) {
            case "<": {
                negAtomCnT = new Compound(">=", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return Collections.singleton(Pair.of((Object)negAtomCnT, (Object)cn.getSecond()));
            }
            case "=<": {
                negAtomCnT = new Compound(">", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return Collections.singleton(Pair.of((Object)negAtomCnT, (Object)cn.getSecond()));
            }
            case ">": {
                negAtomCnT = new Compound("=<", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return Collections.singleton(Pair.of((Object)negAtomCnT, (Object)cn.getSecond()));
            }
            case ">=": {
                negAtomCnT = new Compound("<", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return Collections.singleton(Pair.of((Object)negAtomCnT, (Object)cn.getSecond()));
            }
            case "=:=": {
                return Arrays.asList(Pair.of((Object)new Compound("<", new Term[]{atomCnT.arg(1), atomCnT.arg(2)}), (Object)cn.getSecond()), Pair.of((Object)new Compound(">", new Term[]{atomCnT.arg(1), atomCnT.arg(2)}), (Object)cn.getSecond()));
            }
        }
        return null;
    }

    private static CBinaryExpression getNegatedRelOperator(CBinaryExpression be) {
        switch (be.getOperator()) {
            case EQUALS: {
                return new CBinaryExpression(be.getFileLocation(), be.getExpressionType(), be.getCalculationType(), be.getOperand1(), be.getOperand2(), CBinaryExpression.BinaryOperator.NOT_EQUALS);
            }
            case NOT_EQUALS: {
                return new CBinaryExpression(be.getFileLocation(), be.getExpressionType(), be.getCalculationType(), be.getOperand1(), be.getOperand2(), CBinaryExpression.BinaryOperator.EQUALS);
            }
            case LESS_THAN: {
                return new CBinaryExpression(be.getFileLocation(), be.getExpressionType(), be.getCalculationType(), be.getOperand1(), be.getOperand2(), CBinaryExpression.BinaryOperator.GREATER_EQUAL);
            }
            case LESS_EQUAL: {
                return new CBinaryExpression(be.getFileLocation(), be.getExpressionType(), be.getCalculationType(), be.getOperand1(), be.getOperand2(), CBinaryExpression.BinaryOperator.GREATER_THAN);
            }
            case GREATER_THAN: {
                return new CBinaryExpression(be.getFileLocation(), be.getExpressionType(), be.getCalculationType(), be.getOperand1(), be.getOperand2(), CBinaryExpression.BinaryOperator.LESS_EQUAL);
            }
            case GREATER_EQUAL: {
                return new CBinaryExpression(be.getFileLocation(), be.getExpressionType(), be.getCalculationType(), be.getOperand1(), be.getOperand2(), CBinaryExpression.BinaryOperator.LESS_THAN);
            }
        }
        return null;
    }

    private static Collection<Pair<Term, ArrayList<Term>>> expressionToCLP(AExpression ce) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (ce instanceof CIdExpression) {
            vars.add(ConstraintManager.CVar2PrologVar(ce.toString()));
            return Collections.singleton(Pair.of((Object)ConstraintManager.CVar2PrologVar(ce.toString()), vars));
        }
        if (ce instanceof CIntegerLiteralExpression) {
            return Collections.singleton(Pair.of((Object)Util.textToTerm((String)("rdiv(" + ce.toString() + ",1)")), vars));
        }
        if (ce instanceof CBinaryExpression) {
            CBinaryExpression bexp = (CBinaryExpression)ce;
            Collection<Pair<Term, ArrayList<Term>>> operand1 = ConstraintManager.expressionToCLP(bexp.getOperand1());
            Collection<Pair<Term, ArrayList<Term>>> operand2 = ConstraintManager.expressionToCLP(bexp.getOperand2());
            switch (bexp.getOperator()) {
                case PLUS: {
                    return ConstraintManager.addOperands("+", operand1, operand2);
                }
                case MINUS: {
                    return ConstraintManager.addOperands("-", operand1, operand2);
                }
                case MULTIPLY: {
                    return ConstraintManager.addOperands("*", operand1, operand2);
                }
                case DIVIDE: {
                    return ConstraintManager.addOperands("/", operand1, operand2);
                }
                case EQUALS: {
                    return ConstraintManager.addOperands("=:=", operand1, operand2);
                }
                case NOT_EQUALS: {
                    ArrayList<Pair<Term, ArrayList<Term>>> opUnion = new ArrayList<Pair<Term, ArrayList<Term>>>(ConstraintManager.addOperands(">", operand1, operand2));
                    opUnion.addAll(ConstraintManager.addOperands("<", operand1, operand2));
                    return opUnion;
                }
                case LESS_THAN: {
                    return ConstraintManager.addOperands("<", operand1, operand2);
                }
                case LESS_EQUAL: {
                    return ConstraintManager.addOperands("=<", operand1, operand2);
                }
                case GREATER_THAN: {
                    return ConstraintManager.addOperands(">", operand1, operand2);
                }
                case GREATER_EQUAL: {
                    return ConstraintManager.addOperands(">=", operand1, operand2);
                }
            }
            return null;
        }
        return null;
    }

    private static Collection<Pair<Term, ArrayList<Term>>> paramExpressionToCLP(String paramName, AExpression ce) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Variable paramVariable = ConstraintManager.CVar2PrologVar(paramName);
        vars.add(paramVariable);
        Variable expTerm = null;
        if (ce instanceof CIdExpression) {
            vars.add(ConstraintManager.CVar2PrologVar(ce.toString()));
            expTerm = ConstraintManager.CVar2PrologVar(ce.toString());
            Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, expTerm});
            return Collections.singleton(Pair.of((Object)Util.termArrayToList((Term[])new Term[]{paramAexpTerm}), vars));
        }
        if (ce instanceof CIntegerLiteralExpression) {
            expTerm = Util.textToTerm((String)("rdiv(" + ce.toString() + ",1)"));
            Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, expTerm});
            return Collections.singleton(Pair.of((Object)Util.termArrayToList((Term[])new Term[]{paramAexpTerm}), vars));
        }
        if (ce instanceof CBinaryExpression) {
            CBinaryExpression bexp = (CBinaryExpression)ce;
            Collection<Pair<Term, ArrayList<Term>>> aexpTerms = ConstraintManager.expressionToCLP(ce);
            ArrayList<Pair<Term, ArrayList<Term>>> paramAexpTerms = new ArrayList<Pair<Term, ArrayList<Term>>>(aexpTerms.size());
            switch (bexp.getOperator()) {
                case PLUS: 
                case MINUS: 
                case MULTIPLY: 
                case DIVIDE: {
                    for (Pair<Term, ArrayList<Term>> aexpTerm : aexpTerms) {
                        ArrayList<Variable> aexpTermVars = new ArrayList<Variable>((Collection)aexpTerm.getSecond());
                        aexpTermVars.add(paramVariable);
                        Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, (Term)aexpTerm.getFirst()});
                        paramAexpTerms.add((Pair<Term, ArrayList<Term>>)Pair.of((Object)Util.termArrayToList((Term[])new Term[]{paramAexpTerm}), aexpTermVars));
                    }
                    return paramAexpTerms;
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: {
                    for (Pair<Term, ArrayList<Term>> aexpTerm : aexpTerms) {
                        ArrayList<Variable> aexpTermVars = new ArrayList<Variable>((Collection)aexpTerm.getSecond());
                        aexpTermVars.add(paramVariable);
                        Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, Util.textToTerm((String)"rdiv(1,1)")});
                        paramAexpTerms.add((Pair<Term, ArrayList<Term>>)Pair.of((Object)Util.termArrayToList((Term[])new Term[]{paramAexpTerm, (Term)aexpTerm.getFirst()}), aexpTermVars));
                        paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, Util.textToTerm((String)"rdiv(0,1)")});
                        for (Pair<Term, ArrayList<Term>> negAexpTerm : ConstraintManager.getNegatedConstraintList(aexpTerm)) {
                            paramAexpTerms.add((Pair<Term, ArrayList<Term>>)Pair.of((Object)Util.termArrayToList((Term[])new Term[]{paramAexpTerm, (Term)negAexpTerm.getFirst()}), aexpTermVars));
                        }
                    }
                    return paramAexpTerms;
                }
            }
            return null;
        }
        return null;
    }

    private static Collection<Pair<Term, ArrayList<Term>>> addOperands(String operator, Collection<Pair<Term, ArrayList<Term>>> operand1, Collection<Pair<Term, ArrayList<Term>>> operand2) {
        ArrayList<Pair<Term, ArrayList<Term>>> termList = new ArrayList<Pair<Term, ArrayList<Term>>>();
        ArrayList vars = new ArrayList();
        for (Pair<Term, ArrayList<Term>> subop1 : operand1) {
            for (Pair<Term, ArrayList<Term>> subop2 : operand2) {
                vars.addAll((Collection)subop1.getSecond());
                vars.addAll((Collection)subop2.getSecond());
                termList.add((Pair<Term, ArrayList<Term>>)Pair.of((Object)new Compound(operator, new Term[]{(Term)subop1.getFirst(), (Term)subop2.getFirst()}), vars));
            }
        }
        return termList;
    }

    private static boolean initFiringRelation(String firingRelation) {
        String qStr = "assert((less(C1,C2)";
        switch (firingRelation) {
            case "Always": {
                break;
            }
            case "Maxcoeff": {
                qStr = qStr + ":-less_maxcoeff_cns(C1,C2)";
                break;
            }
            case "Sumcoeff": {
                qStr = qStr + ":-less_maxsum_cns(C1,C2)";
                break;
            }
            case "Homeocoeff": {
                qStr = qStr + ":-homeo_embedded_cns(C1,C2)";
                break;
            }
            default: {
                throw new AssertionError((Object)"Not valid value for the firing relation");
            }
        }
        qStr = qStr + "))";
        Query q = new Query(qStr);
        return q.hasSolution();
    }

    private static boolean initGeneralizationOperator(String generalizationOperator) {
        String qStr = "assert((generalize(C1,C2,C3)";
        switch (generalizationOperator) {
            case "Top": {
                break;
            }
            case "Widen": {
                qStr = qStr + ":-plain_cns_widening(C1,C2,C3)";
                break;
            }
            case "WidenMax": {
                qStr = qStr + ":-e_leq_maxcoeff(C1,C2,C3)";
                break;
            }
            case "WidenSum": {
                qStr = qStr + ":-e_leq_maxsum(C1,C2,C3)";
                break;
            }
            default: {
                throw new AssertionError((Object)"invalid value for the firing relation");
            }
        }
        qStr = qStr + "))";
        Query q = new Query(qStr);
        return q.hasSolution();
    }

    public static Constraint convexHull(Constraint cn1, Constraint cn2s) {
        return new Constraint();
    }

    private ConstraintManager() {
    }
}

