/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.composite.CompositeDomain;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreeOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreePredicatedAnalysisOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergePlainOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositeReducer;
import org.sosy_lab.cpachecker.cpa.composite.CompositeSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeStopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeTransferRelation;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class CompositeCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
WrapperCPA,
ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    private final AbstractDomain abstractDomain;
    private final CompositeTransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final CompositeStopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final Reducer reducer;
    private final ImmutableList<ConfigurableProgramAnalysis> cpas;

    public static CPAFactory factory() {
        return new CompositeCPAFactory();
    }

    protected CompositeCPA(AbstractDomain abstractDomain, CompositeTransferRelation transferRelation, MergeOperator mergeOperator, CompositeStopOperator stopOperator, PrecisionAdjustment precisionAdjustment, ImmutableList<ConfigurableProgramAnalysis> cpas) {
        this.abstractDomain = abstractDomain;
        this.transferRelation = transferRelation;
        this.mergeOperator = mergeOperator;
        this.stopOperator = stopOperator;
        this.precisionAdjustment = precisionAdjustment;
        this.cpas = cpas;
        ArrayList<Reducer> wrappedReducers = new ArrayList<Reducer>();
        for (ConfigurableProgramAnalysis cpa : cpas) {
            if (cpa instanceof ConfigurableProgramAnalysisWithBAM) {
                wrappedReducers.add(((ConfigurableProgramAnalysisWithBAM)cpa).getReducer());
                continue;
            }
            wrappedReducers.clear();
            break;
        }
        this.reducer = !wrappedReducers.isEmpty() ? new CompositeReducer(wrappedReducers) : null;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        Preconditions.checkNotNull((Object)pNode);
        ImmutableList.Builder initialStates = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : this.cpas) {
            initialStates.add((Object)sp.getInitialState(pNode, pPartition));
        }
        return new CompositeState((List<AbstractState>)initialStates.build());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition partition) {
        Preconditions.checkNotNull((Object)pNode);
        ImmutableList.Builder initialPrecisions = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : this.cpas) {
            initialPrecisions.add((Object)sp.getInitialPrecision(pNode, partition));
        }
        return new CompositePrecision((List<Precision>)initialPrecisions.build());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        for (ConfigurableProgramAnalysis cpa : this.cpas) {
            if (!(cpa instanceof StatisticsProvider)) continue;
            ((StatisticsProvider)((Object)cpa)).collectStatistics(pStatsCollection);
        }
        if (this.precisionAdjustment instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.precisionAdjustment)).collectStatistics(pStatsCollection);
        }
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        for (ConfigurableProgramAnalysis cpa : this.cpas) {
            T result;
            if (pType.isAssignableFrom(cpa.getClass())) {
                return (T)((ConfigurableProgramAnalysis)pType.cast(cpa));
            }
            if (!(cpa instanceof WrapperCPA) || (result = ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(pType)) == null) continue;
            return result;
        }
        return null;
    }

    public ImmutableList<ConfigurableProgramAnalysis> getWrappedCPAs() {
        return this.cpas;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        return this.transferRelation.areAbstractSuccessors(pElement, pCfaEdge, pSuccessors, (List<ConfigurableProgramAnalysis>)this.cpas);
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        return this.stopOperator.isCoveredBy(pElement, pOtherElement, (List<ConfigurableProgramAnalysis>)this.cpas);
    }

    private static class CompositeCPAFactory
    extends AbstractCPAFactory {
        private CFA cfa = null;
        private ImmutableList<ConfigurableProgramAnalysis> cpas = null;

        private CompositeCPAFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException {
            MergeOperator compositeMerge;
            Preconditions.checkState((this.cpas != null ? 1 : 0) != 0, (Object)"CompositeCPA needs wrapped CPAs!");
            Preconditions.checkState((this.cfa != null ? 1 : 0) != 0, (Object)"CompositeCPA needs CFA information!");
            CompositeOptions options = new CompositeOptions();
            this.getConfiguration().inject((Object)options);
            ImmutableList.Builder domains = ImmutableList.builder();
            ImmutableList.Builder transferRelations = ImmutableList.builder();
            ImmutableList.Builder mergeOperators = ImmutableList.builder();
            ImmutableList.Builder stopOperators = ImmutableList.builder();
            ImmutableList.Builder precisionAdjustments = ImmutableList.builder();
            ImmutableList.Builder simplePrecisionAdjustments = ImmutableList.builder();
            boolean mergeSep = true;
            boolean simplePrec = true;
            PredicateAbstractionManager abmgr = null;
            for (ConfigurableProgramAnalysis sp : this.cpas) {
                if (sp instanceof PredicateCPA) {
                    abmgr = ((PredicateCPA)sp).getPredicateManager();
                }
                domains.add((Object)sp.getAbstractDomain());
                transferRelations.add((Object)sp.getTransferRelation());
                stopOperators.add((Object)sp.getStopOperator());
                PrecisionAdjustment prec = sp.getPrecisionAdjustment();
                if (prec instanceof SimplePrecisionAdjustment) {
                    simplePrecisionAdjustments.add((Object)((SimplePrecisionAdjustment)prec));
                } else {
                    simplePrec = false;
                }
                precisionAdjustments.add((Object)prec);
                MergeOperator merge = sp.getMergeOperator();
                if (merge != MergeSepOperator.getInstance()) {
                    mergeSep = false;
                }
                mergeOperators.add((Object)merge);
            }
            ImmutableList stopOps = stopOperators.build();
            if (mergeSep) {
                compositeMerge = MergeSepOperator.getInstance();
            } else if (options.inPredicatedAnalysis) {
                if (!options.merge.equals("AGREE")) throw new InvalidConfigurationException("Merge PLAIN is currently not supported in predicated analysis");
                compositeMerge = new CompositeMergeAgreePredicatedAnalysisOperator((ImmutableList<MergeOperator>)mergeOperators.build(), (ImmutableList<StopOperator>)stopOps, abmgr);
            } else if (options.merge.equals("AGREE")) {
                compositeMerge = new CompositeMergeAgreeOperator((ImmutableList<MergeOperator>)mergeOperators.build(), (ImmutableList<StopOperator>)stopOps);
            } else {
                if (!options.merge.equals("PLAIN")) throw new AssertionError();
                compositeMerge = new CompositeMergePlainOperator((ImmutableList<MergeOperator>)mergeOperators.build());
            }
            CompositeDomain compositeDomain = new CompositeDomain((ImmutableList<AbstractDomain>)domains.build());
            CompositeTransferRelation compositeTransfer = new CompositeTransferRelation((ImmutableList<TransferRelation>)transferRelations.build(), options.inPredicatedAnalysis, this.getConfiguration());
            CompositeStopOperator compositeStop = new CompositeStopOperator((ImmutableList<StopOperator>)stopOps);
            PrecisionAdjustment compositePrecisionAdjustment = simplePrec ? new CompositeSimplePrecisionAdjustment((ImmutableList<SimplePrecisionAdjustment>)simplePrecisionAdjustments.build()) : new CompositePrecisionAdjustment((ImmutableList<PrecisionAdjustment>)precisionAdjustments.build());
            return new CompositeCPA(compositeDomain, compositeTransfer, compositeMerge, compositeStop, compositePrecisionAdjustment, this.cpas);
        }

        @Override
        public CPAFactory setChild(ConfigurableProgramAnalysis pChild) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Use CompositeCPA to wrap several CPAs!");
        }

        @Override
        public CPAFactory setChildren(List<ConfigurableProgramAnalysis> pChildren) {
            Preconditions.checkNotNull(pChildren);
            Preconditions.checkArgument((!pChildren.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((this.cpas == null ? 1 : 0) != 0);
            this.cpas = ImmutableList.copyOf(pChildren);
            return this;
        }

        @Override
        public <T> CPAFactory set(T pObject, Class<T> pClass) throws UnsupportedOperationException {
            if (pClass.equals(CFA.class)) {
                this.cfa = (CFA)pObject;
            }
            return super.set(pObject, pClass);
        }
    }

    @Options(prefix="cpa.composite")
    private static class CompositeOptions {
        @Option(secure=true, toUppercase=true, values={"PLAIN", "AGREE"}, description="which composite merge operator to use (plain or agree)\nBoth delegate to the component cpas, but agree only allows merging if all cpas agree on this. This is probably what you want.")
        private String merge = "AGREE";
        @Option(secure=true, description="inform Composite CPA if it is run in a predicated analysis because then it mustbehave differntly during merge.")
        private boolean inPredicatedAnalysis = false;

        private CompositeOptions() {
        }
    }
}

