/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.NonMergeableAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class CompositeMergeAgreePredicatedAnalysisOperator
implements MergeOperator {
    private static final Predicate<Object> NON_MERGEABLE_STATE = Predicates.instanceOf(NonMergeableAbstractState.class);
    private final ImmutableList<MergeOperator> mergeOperators;
    private final ImmutableList<StopOperator> stopOperators;
    private final PredicateAbstractionManager abmgr;

    public CompositeMergeAgreePredicatedAnalysisOperator(ImmutableList<MergeOperator> mergeOperators, ImmutableList<StopOperator> stopOperators, PredicateAbstractionManager pAbmgr) {
        this.mergeOperators = mergeOperators;
        this.stopOperators = stopOperators;
        this.abmgr = pAbmgr;
    }

    @Override
    public AbstractState merge(AbstractState successorState, AbstractState reachedState, Precision precision) throws CPAException, InterruptedException {
        CompositeState compSuccessorState = (CompositeState)successorState;
        CompositeState compReachedState = (CompositeState)reachedState;
        CompositePrecision compPrecision = (CompositePrecision)precision;
        boolean mergePredicatedAnalysis = false;
        assert (compSuccessorState.getNumberOfStates() == compReachedState.getNumberOfStates());
        PredicateAbstractState predSuccessorState = AbstractStates.extractStateByType(successorState, PredicateAbstractState.class);
        PredicateAbstractState predReachedState = AbstractStates.extractStateByType(reachedState, PredicateAbstractState.class);
        if (predSuccessorState != null && predReachedState != null && predSuccessorState.isAbstractionState() && predReachedState.isAbstractionState() && (predSuccessorState.getAbstractionFormula().asFormula() == predReachedState.getAbstractionFormula().asFormula() || this.abmgr.checkCoverage(predSuccessorState.getAbstractionFormula(), predReachedState.getAbstractionFormula()) && this.abmgr.checkCoverage(predReachedState.getAbstractionFormula(), predSuccessorState.getAbstractionFormula()))) {
            mergePredicatedAnalysis = true;
        }
        if (!mergePredicatedAnalysis && (FluentIterable.from((Iterable)compSuccessorState.getWrappedStates()).anyMatch(NON_MERGEABLE_STATE) || FluentIterable.from((Iterable)compReachedState.getWrappedStates()).anyMatch(NON_MERGEABLE_STATE))) {
            return reachedState;
        }
        ImmutableList.Builder mergedStates = ImmutableList.builder();
        UnmodifiableIterator stopIter = this.stopOperators.iterator();
        Iterator comp1Iter = compSuccessorState.getWrappedStates().iterator();
        Iterator comp2Iter = compReachedState.getWrappedStates().iterator();
        Iterator<Precision> precIter = compPrecision.getPrecisions().iterator();
        boolean identicalStates = true;
        for (MergeOperator mergeOp : this.mergeOperators) {
            AbstractState mergedState;
            AbstractState absSuccessorState = (AbstractState)comp1Iter.next();
            AbstractState absReachedState = (AbstractState)comp2Iter.next();
            if (mergePredicatedAnalysis && absReachedState instanceof PredicateAbstractState) {
                mergedStates.add((Object)absReachedState);
                precIter.next();
                stopIter.next();
                continue;
            }
            Precision prec = precIter.next();
            StopOperator stopOp = (StopOperator)stopIter.next();
            if (!stopOp.stop(absSuccessorState, Collections.singleton(mergedState = mergeOp.merge(absSuccessorState, absReachedState, prec)), prec)) {
                return reachedState;
            }
            if (mergedState != absReachedState) {
                identicalStates = false;
            }
            mergedStates.add((Object)mergedState);
        }
        if (identicalStates) {
            return reachedState;
        }
        return new CompositeState((List<AbstractState>)mergedStates.build());
    }
}

