/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositePrecisionAdjustment
implements PrecisionAdjustment {
    protected final ImmutableList<PrecisionAdjustment> precisionAdjustments;
    protected final ImmutableList<StateProjectionFunction> stateProjectionFunctions;
    protected final ImmutableList<PrecisionProjectionFunction> precisionProjectionFunctions;

    public CompositePrecisionAdjustment(ImmutableList<PrecisionAdjustment> precisionAdjustments) {
        this.precisionAdjustments = precisionAdjustments;
        ImmutableList.Builder stateProjectionFunctions = ImmutableList.builder();
        ImmutableList.Builder precisionProjectionFunctions = ImmutableList.builder();
        for (int i = 0; i < precisionAdjustments.size(); ++i) {
            stateProjectionFunctions.add((Object)new StateProjectionFunction(i));
            precisionProjectionFunctions.add((Object)new PrecisionProjectionFunction(i));
        }
        this.stateProjectionFunctions = stateProjectionFunctions.build();
        this.precisionProjectionFunctions = precisionProjectionFunctions.build();
    }

    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, AbstractState fullState) throws CPAException, InterruptedException {
        CompositeState comp = (CompositeState)pElement;
        CompositePrecision prec = (CompositePrecision)pPrecision;
        assert (comp.getWrappedStates().size() == prec.getPrecisions().size());
        int dim = comp.getWrappedStates().size();
        ImmutableList.Builder outElements = ImmutableList.builder();
        ImmutableList.Builder outPrecisions = ImmutableList.builder();
        boolean modified = false;
        PrecisionAdjustment.Action action = PrecisionAdjustment.Action.CONTINUE;
        for (int i = 0; i < dim; ++i) {
            UnmodifiableReachedSetView slice = new UnmodifiableReachedSetView(pElements, (Function<? super AbstractState, AbstractState>)((Function)this.stateProjectionFunctions.get(i)), (Function<? super Precision, Precision>)((Function)this.precisionProjectionFunctions.get(i)));
            PrecisionAdjustment precisionAdjustment = (PrecisionAdjustment)this.precisionAdjustments.get(i);
            AbstractState oldElement = comp.get(i);
            Precision oldPrecision = prec.get(i);
            PrecisionAdjustment.PrecisionAdjustmentResult out = precisionAdjustment.prec(oldElement, oldPrecision, slice, fullState);
            AbstractState newElement = out.abstractState();
            Precision newPrecision = out.precision();
            if (out.action() == PrecisionAdjustment.Action.BREAK) {
                action = PrecisionAdjustment.Action.BREAK;
            }
            if (newElement != oldElement || newPrecision != oldPrecision) {
                modified = true;
            }
            outElements.add((Object)newElement);
            outPrecisions.add((Object)newPrecision);
        }
        AbstractState outElement = modified ? new CompositeState((List<AbstractState>)outElements.build()) : pElement;
        Precision outPrecision = modified ? new CompositePrecision((List<Precision>)outPrecisions.build()) : pPrecision;
        return PrecisionAdjustment.PrecisionAdjustmentResult.create(outElement, outPrecision, action);
    }

    protected static class PrecisionProjectionFunction
    implements Function<Precision, Precision> {
        private final int dimension;

        public PrecisionProjectionFunction(int d) {
            this.dimension = d;
        }

        public Precision apply(Precision from) {
            return ((CompositePrecision)from).get(this.dimension);
        }
    }

    protected static class StateProjectionFunction
    implements Function<AbstractState, AbstractState> {
        private final int dimension;

        public StateProjectionFunction(int d) {
            this.dimension = d;
        }

        public AbstractState apply(AbstractState from) {
            return ((CompositeState)from).get(this.dimension);
        }
    }
}

