/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;

public class CompositeReducer
implements Reducer {
    private final List<Reducer> wrappedReducers;

    public CompositeReducer(List<Reducer> pWrappedReducers) {
        this.wrappedReducers = pWrappedReducers;
    }

    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pContext, CFANode pLocation) {
        ArrayList<AbstractState> result = new ArrayList<AbstractState>();
        int i = 0;
        for (AbstractState expandedState : ((CompositeState)pExpandedState).getWrappedStates()) {
            result.add(this.wrappedReducers.get(i++).getVariableReducedState(expandedState, pContext, pLocation));
        }
        return new CompositeState(result);
    }

    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        Iterable rootStates = ((CompositeState)pRootState).getWrappedStates();
        Iterable reducedStates = ((CompositeState)pReducedState).getWrappedStates();
        ArrayList<AbstractState> result = new ArrayList<AbstractState>();
        int i = 0;
        for (Pair p : Pair.zipList((Collection)rootStates, (Collection)reducedStates)) {
            result.add(this.wrappedReducers.get(i++).getVariableExpandedState((AbstractState)p.getFirst(), pReducedContext, (AbstractState)p.getSecond()));
        }
        return new CompositeState(result);
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        Iterable elements = ((CompositeState)pElementKey).getWrappedStates();
        List<Precision> precisions = ((CompositePrecision)pPrecisionKey).getPrecisions();
        ArrayList<Object> result = new ArrayList<Object>(elements.size());
        int i = 0;
        for (Pair p : Pair.zipList((Collection)elements, precisions)) {
            result.add(this.wrappedReducers.get(i++).getHashCodeForState((AbstractState)p.getFirst(), (Precision)p.getSecond()));
        }
        return result;
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        List<Precision> precisions = ((CompositePrecision)pPrecision).getPrecisions();
        ArrayList<Precision> result = new ArrayList<Precision>(precisions.size());
        int i = 0;
        for (Precision precision : precisions) {
            result.add(this.wrappedReducers.get(i++).getVariableReducedPrecision(precision, pContext));
        }
        return new CompositePrecision(result);
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        List<Precision> rootPrecisions = ((CompositePrecision)pRootPrecision).getPrecisions();
        List<Precision> reducedPrecisions = ((CompositePrecision)pReducedPrecision).getPrecisions();
        ArrayList<Precision> result = new ArrayList<Precision>(rootPrecisions.size());
        int i = 0;
        for (Precision rootPrecision : rootPrecisions) {
            result.add(this.wrappedReducers.get(i).getVariableExpandedPrecision(rootPrecision, pRootContext, reducedPrecisions.get(i)));
            ++i;
        }
        return new CompositePrecision(result);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        List<Precision> precisions = ((CompositePrecision)pPrecision).getPrecisions();
        List<Precision> otherPrecisions = ((CompositePrecision)pOtherPrecision).getPrecisions();
        int i = 0;
        int sum = 0;
        for (Precision rootPrecision : precisions) {
            sum += this.wrappedReducers.get(i).measurePrecisionDifference(rootPrecision, otherPrecisions.get(i));
            ++i;
        }
        return sum;
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        ArrayList<AbstractState> result = new ArrayList<AbstractState>();
        int i = 0;
        for (AbstractState expandedState : ((CompositeState)pExpandedState).getWrappedStates()) {
            result.add(this.wrappedReducers.get(i++).getVariableReducedStateForProofChecking(expandedState, pContext, pCallNode));
        }
        return new CompositeState(result);
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        Iterable rootStates = ((CompositeState)pRootState).getWrappedStates();
        Iterable reducedStates = ((CompositeState)pReducedState).getWrappedStates();
        ArrayList<AbstractState> result = new ArrayList<AbstractState>();
        int i = 0;
        for (Pair p : Pair.zipList((Collection)rootStates, (Collection)reducedStates)) {
            result.add(this.wrappedReducers.get(i++).getVariableExpandedStateForProofChecking((AbstractState)p.getFirst(), pReducedContext, (AbstractState)p.getSecond()));
        }
        return new CompositeState(result);
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState pRootState, AbstractState pEntryState, AbstractState pExpandedState, CFANode exitLocation) {
        Iterable rootStates = ((CompositeState)pRootState).getWrappedStates();
        Iterable entryStates = ((CompositeState)pEntryState).getWrappedStates();
        Iterable expandedStates = ((CompositeState)pExpandedState).getWrappedStates();
        ArrayList<AbstractState> results = new ArrayList<AbstractState>();
        for (int i = 0; i < rootStates.size(); ++i) {
            results.add(this.wrappedReducers.get(i).rebuildStateAfterFunctionCall((AbstractState)rootStates.get(i), (AbstractState)entryStates.get(i), (AbstractState)expandedStates.get(i), exitLocation));
        }
        return new CompositeState(results);
    }
}

