/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class CompositeSimplePrecisionAdjustment
extends SimplePrecisionAdjustment {
    private final ImmutableList<SimplePrecisionAdjustment> precisionAdjustments;

    public CompositeSimplePrecisionAdjustment(ImmutableList<SimplePrecisionAdjustment> precisionAdjustments) {
        this.precisionAdjustments = precisionAdjustments;
    }

    @Override
    public PrecisionAdjustment.Action prec(AbstractState pElement, Precision pPrecision) throws CPAException {
        CompositeState comp = (CompositeState)pElement;
        CompositePrecision prec = (CompositePrecision)pPrecision;
        assert (comp.getWrappedStates().size() == prec.getPrecisions().size());
        int dim = comp.getNumberOfStates();
        for (int i = 0; i < dim; ++i) {
            Precision oldPrecision;
            AbstractState oldElement;
            SimplePrecisionAdjustment precisionAdjustment = (SimplePrecisionAdjustment)this.precisionAdjustments.get(i);
            PrecisionAdjustment.Action action = precisionAdjustment.prec(oldElement = comp.get(i), oldPrecision = prec.get(i));
            if (action != PrecisionAdjustment.Action.BREAK) continue;
            return PrecisionAdjustment.Action.BREAK;
        }
        return PrecisionAdjustment.Action.CONTINUE;
    }
}

