/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;

public class CompositeState
implements AbstractWrapperState,
Targetable,
Partitionable,
Serializable,
Graphable {
    private static final long serialVersionUID = -5143296331663510680L;
    private final ImmutableList<AbstractState> states;
    private transient Object partitionKey;

    public CompositeState(List<AbstractState> elements) {
        this.states = ImmutableList.copyOf(elements);
    }

    public int getNumberOfStates() {
        return this.states.size();
    }

    @Override
    public boolean isTarget() {
        for (AbstractState element : this.states) {
            if (!(element instanceof Targetable) || !((Targetable)((Object)element)).isTarget()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getViolatedPropertyDescription() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isTarget());
        HashSet descriptions = Sets.newHashSetWithExpectedSize((int)this.states.size());
        for (AbstractState element : this.states) {
            if (!(element instanceof Targetable) || !((Targetable)((Object)element)).isTarget()) continue;
            descriptions.add(((Targetable)((Object)element)).getViolatedPropertyDescription());
        }
        descriptions.remove("");
        return Joiner.on((String)", ").join((Iterable)descriptions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (AbstractState element : this.states) {
            builder.append(element.getClass().getSimpleName());
            builder.append(": ");
            builder.append(element.toString());
            builder.append("\n ");
        }
        builder.replace(builder.length() - 1, builder.length(), ")");
        return builder.toString();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder builder = new StringBuilder();
        for (AbstractState element : this.states) {
            String label;
            if (!(element instanceof Graphable) || (label = ((Graphable)((Object)element)).toDOTLabel()).isEmpty()) continue;
            builder.append(element.getClass().getSimpleName());
            builder.append(": ");
            builder.append(label);
            builder.append("\\n ");
        }
        return builder.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        for (AbstractState element : this.states) {
            if (!(element instanceof Graphable) || !((Graphable)((Object)element)).shouldBeHighlighted()) continue;
            return true;
        }
        return false;
    }

    public AbstractState get(int idx) {
        return (AbstractState)this.states.get(idx);
    }

    public List<AbstractState> getWrappedStates() {
        return this.states;
    }

    @Override
    public Object getPartitionKey() {
        if (this.partitionKey == null) {
            Object[] keys = new Object[this.states.size()];
            int i = 0;
            for (AbstractState element : this.states) {
                if (element instanceof Partitionable) {
                    keys[i] = ((Partitionable)((Object)element)).getPartitionKey();
                }
                ++i;
            }
            this.partitionKey = new CompositePartitionKey(keys);
        }
        return this.partitionKey;
    }

    private static final class CompositePartitionKey {
        private final Object[] keys;

        private CompositePartitionKey(Object[] pElements) {
            this.keys = pElements;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof CompositePartitionKey)) {
                return false;
            }
            return Arrays.equals(this.keys, ((CompositePartitionKey)pObj).keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }

        public String toString() {
            return "[" + Joiner.on((String)", ").skipNulls().join(this.keys) + "]";
        }
    }
}

