/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCoveringStopOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompositeStopOperator
implements StopOperator,
ForcedCoveringStopOperator {
    protected final ImmutableList<StopOperator> stopOperators;

    public CompositeStopOperator(ImmutableList<StopOperator> stopOperators) {
        this.stopOperators = stopOperators;
    }

    @Override
    public boolean stop(AbstractState element, Collection<AbstractState> reached, Precision precision) throws CPAException, InterruptedException {
        CompositeState compositeState = (CompositeState)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        for (AbstractState e : reached) {
            if (!this.stop(compositeState, (CompositeState)e, compositePrecision)) continue;
            return true;
        }
        return false;
    }

    private boolean stop(CompositeState compositeState, CompositeState compositeReachedState, CompositePrecision compositePrecision) throws CPAException, InterruptedException {
        Iterable compositeElements = compositeState.getWrappedStates();
        Preconditions.checkArgument((compositeElements.size() == this.stopOperators.size() ? 1 : 0) != 0, (Object)"State with wrong number of component states given");
        Iterable compositeReachedStates = compositeReachedState.getWrappedStates();
        List<Precision> compositePrecisions = compositePrecision.getPrecisions();
        for (int idx = 0; idx < compositeElements.size(); ++idx) {
            StopOperator stopOp = (StopOperator)this.stopOperators.get(idx);
            AbstractState absElem1 = (AbstractState)compositeElements.get(idx);
            AbstractState absElem2 = (AbstractState)compositeReachedStates.get(idx);
            Precision prec = compositePrecisions.get(idx);
            if (stopOp.stop(absElem1, Collections.singleton(absElem2), prec)) continue;
            return false;
        }
        return true;
    }

    boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement, List<ConfigurableProgramAnalysis> cpas) throws CPAException, InterruptedException {
        CompositeState compositeState = (CompositeState)pElement;
        CompositeState compositeOtherElement = (CompositeState)pOtherElement;
        Iterable componentElements = compositeState.getWrappedStates();
        Iterable componentOtherElements = compositeOtherElement.getWrappedStates();
        if (componentElements.size() != cpas.size()) {
            return false;
        }
        for (int idx = 0; idx < componentElements.size(); ++idx) {
            AbstractState absElem2;
            AbstractState absElem1;
            ProofChecker componentProofChecker = (ProofChecker)((Object)cpas.get(idx));
            if (componentProofChecker.isCoveredBy(absElem1 = (AbstractState)componentElements.get(idx), absElem2 = (AbstractState)componentOtherElements.get(idx))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isForcedCoveringPossible(AbstractState pElement, AbstractState pReachedState, Precision pPrecision) throws CPAException, InterruptedException {
        CompositeState compositeState = (CompositeState)pElement;
        CompositeState compositeReachedState = (CompositeState)pReachedState;
        CompositePrecision compositePrecision = (CompositePrecision)pPrecision;
        Iterable compositeElements = compositeState.getWrappedStates();
        Iterable compositeReachedStates = compositeReachedState.getWrappedStates();
        List<Precision> compositePrecisions = compositePrecision.getPrecisions();
        for (int idx = 0; idx < compositeElements.size(); ++idx) {
            StopOperator stopOp = (StopOperator)this.stopOperators.get(idx);
            AbstractState wrappedState = (AbstractState)compositeElements.get(idx);
            AbstractState wrappedReachedState = (AbstractState)compositeReachedStates.get(idx);
            Precision prec = compositePrecisions.get(idx);
            boolean possible = stopOp instanceof ForcedCoveringStopOperator ? ((ForcedCoveringStopOperator)stopOp).isForcedCoveringPossible(wrappedState, wrappedReachedState, prec) : stopOp.stop(wrappedState, Collections.singleton(wrappedReachedState), prec);
            if (possible) continue;
            return false;
        }
        return true;
    }
}

