/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageTransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="cpa.composite")
public final class CompositeTransferRelation
implements TransferRelation {
    @Option(secure=true, description="Split MultiEdges and pass each inner edge to the component CPAs to allow strengthen calls after each single edge. Does not work with backwards analysis!")
    private boolean splitMultiEdges = false;
    private final ImmutableList<TransferRelation> transferRelations;
    private final int size;
    private int assumptionIndex = -1;
    private int predicatesIndex = -1;
    private final boolean isErrorStateDetectableInStrengthening;

    public CompositeTransferRelation(ImmutableList<TransferRelation> transferRelations, boolean pErrorDetctableInStrengthen, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.transferRelations = transferRelations;
        this.size = transferRelations.size();
        this.isErrorStateDetectableInStrengthening = pErrorDetctableInStrengthen;
        for (int i = 0; i < this.size; ++i) {
            TransferRelation t = (TransferRelation)transferRelations.get(i);
            if (t instanceof PredicateTransferRelation) {
                this.predicatesIndex = i;
            }
            if (!(t instanceof AssumptionStorageTransferRelation)) continue;
            this.assumptionIndex = i;
        }
    }

    public Collection<CompositeState> getAbstractSuccessors(AbstractState element, Precision precision) throws CPATransferException, InterruptedException {
        CompositeState compositeState = (CompositeState)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        AbstractStateWithLocation locState = AbstractStates.extractStateByType(compositeState, AbstractStateWithLocation.class);
        if (locState == null) {
            throw new CPATransferException("Analysis without any CPA tracking locations is not supported, please add one to the configuration (e.g., LocationCPA).");
        }
        ArrayList<CompositeState> results = new ArrayList<CompositeState>(2);
        for (CFAEdge edge : locState.getOutgoingEdges()) {
            this.getAbstractSuccessorForEdge(compositeState, compositePrecision, edge, results);
        }
        return results;
    }

    public Collection<CompositeState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        CompositeState compositeState = (CompositeState)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        ArrayList<CompositeState> results = new ArrayList<CompositeState>(1);
        this.getAbstractSuccessorForEdge(compositeState, compositePrecision, cfaEdge, results);
        return results;
    }

    private void getAbstractSuccessorForEdge(CompositeState compositeState, CompositePrecision compositePrecision, CFAEdge cfaEdge, Collection<CompositeState> compositeSuccessors) throws CPATransferException, InterruptedException {
        if (this.splitMultiEdges && cfaEdge instanceof MultiEdge) {
            Collection<CompositeState> currentStates = new ArrayList<CompositeState>(1);
            currentStates.add(compositeState);
            for (CFAEdge simpleEdge : ((MultiEdge)cfaEdge).getEdges()) {
                ArrayList<CompositeState> successorStates = new ArrayList<CompositeState>(currentStates.size());
                for (CompositeState currentState : currentStates) {
                    this.getAbstractSuccessorForSimpleEdge(currentState, compositePrecision, simpleEdge, successorStates);
                }
                assert (!FluentIterable.from(successorStates).anyMatch(AbstractStates.IS_TARGET_STATE));
                currentStates = Collections.unmodifiableCollection(successorStates);
            }
            compositeSuccessors.addAll(currentStates);
        } else {
            this.getAbstractSuccessorForSimpleEdge(compositeState, compositePrecision, cfaEdge, compositeSuccessors);
        }
    }

    private void getAbstractSuccessorForSimpleEdge(CompositeState compositeState, CompositePrecision compositePrecision, CFAEdge cfaEdge, Collection<CompositeState> compositeSuccessors) throws CPATransferException, InterruptedException {
        Precision lCurrentPrecision;
        AbstractState lCurrentElement;
        TransferRelation lCurrentTransfer;
        Collection<? extends AbstractState> componentSuccessors;
        assert (cfaEdge != null);
        int resultCount = 1;
        Iterable componentElements = compositeState.getWrappedStates();
        Preconditions.checkArgument((componentElements.size() == this.size ? 1 : 0) != 0, (Object)"State with wrong number of component states given");
        ArrayList<Collection<? extends AbstractState>> allComponentsSuccessors = new ArrayList<Collection<? extends AbstractState>>(this.size);
        for (int i = 0; i < this.size && (resultCount *= (componentSuccessors = (lCurrentTransfer = (TransferRelation)this.transferRelations.get(i)).getAbstractSuccessorsForEdge(lCurrentElement = (AbstractState)componentElements.get(i), lCurrentPrecision = compositePrecision.get(i), cfaEdge)).size()) != 0; ++i) {
            allComponentsSuccessors.add(componentSuccessors);
        }
        Collection<List<AbstractState>> allResultingElements = CompositeTransferRelation.createCartesianProduct(allComponentsSuccessors, resultCount);
        AbstractState foundInStrengthen = null;
        for (List<AbstractState> lReachedState : allResultingElements) {
            ArrayList<Collection<? extends AbstractState>> lStrengthenResults = new ArrayList<Collection<? extends AbstractState>>(this.size);
            resultCount = 1;
            for (int i = 0; i < this.size; ++i) {
                Precision lCurrentPrecision2;
                AbstractState lCurrentElement2;
                TransferRelation lCurrentTransfer2 = (TransferRelation)this.transferRelations.get(i);
                Collection<? extends AbstractState> lResultsList = lCurrentTransfer2.strengthen(lCurrentElement2 = lReachedState.get(i), lReachedState, cfaEdge, lCurrentPrecision2 = compositePrecision.get(i));
                if (lResultsList == null) {
                    lStrengthenResults.add(Collections.singleton(lCurrentElement2));
                    continue;
                }
                if ((resultCount *= lResultsList.size()) == 0) break;
                if (this.isErrorStateDetectableInStrengthening && foundInStrengthen == null && lCurrentElement2 instanceof AutomatonState) {
                    for (AbstractState abstractState : lResultsList) {
                        if (!((Targetable)((Object)abstractState)).isTarget()) continue;
                        foundInStrengthen = abstractState;
                        break;
                    }
                }
                lStrengthenResults.add(lResultsList);
            }
            if (this.predicatesIndex >= 0 && this.assumptionIndex >= 0 && resultCount > 0) {
                AbstractState predElement = (AbstractState)Iterables.getOnlyElement((Iterable)((Iterable)lStrengthenResults.get(this.predicatesIndex)));
                AbstractState assumptionElement = (AbstractState)Iterables.getOnlyElement((Iterable)((Iterable)lStrengthenResults.get(this.assumptionIndex)));
                Precision predPrecision = compositePrecision.get(this.predicatesIndex);
                TransferRelation predTransfer = (TransferRelation)this.transferRelations.get(this.predicatesIndex);
                Collection<? extends AbstractState> predResult = predTransfer.strengthen(predElement, Collections.singletonList(assumptionElement), cfaEdge, predPrecision);
                resultCount *= predResult.size();
                lStrengthenResults.set(this.predicatesIndex, predResult);
            }
            if (this.predicatesIndex >= 0 && foundInStrengthen != null && resultCount > 0) {
                AbstractState predElement = (AbstractState)Iterables.getOnlyElement((Iterable)((Iterable)lStrengthenResults.get(this.predicatesIndex)));
                Precision predPrecision = compositePrecision.get(this.predicatesIndex);
                TransferRelation predTransfer = (TransferRelation)this.transferRelations.get(this.predicatesIndex);
                Collection<? extends AbstractState> predResult = predTransfer.strengthen(predElement, Collections.singletonList(foundInStrengthen), cfaEdge, predPrecision);
                resultCount *= predResult.size();
                lStrengthenResults.set(this.predicatesIndex, predResult);
            }
            Collection<List<AbstractState>> lResultingElements = CompositeTransferRelation.createCartesianProduct(lStrengthenResults, resultCount);
            for (List<AbstractState> lList : lResultingElements) {
                compositeSuccessors.add(new CompositeState(lList));
            }
        }
    }

    protected static Collection<List<AbstractState>> createCartesianProduct(List<Collection<? extends AbstractState>> allComponentsSuccessors, int resultCount) {
        Collection<List<AbstractState>> allResultingElements;
        switch (resultCount) {
            case 0: {
                allResultingElements = Collections.emptySet();
                break;
            }
            case 1: {
                ArrayList<Object> resultingElements = new ArrayList<Object>(allComponentsSuccessors.size());
                for (Collection<? extends AbstractState> componentSuccessors : allComponentsSuccessors) {
                    resultingElements.add(Iterables.getOnlyElement(componentSuccessors));
                }
                allResultingElements = Collections.singleton(resultingElements);
                break;
            }
            default: {
                List<AbstractState> initialPrefix = Collections.emptyList();
                allResultingElements = new ArrayList(resultCount);
                CompositeTransferRelation.createCartesianProduct0(allComponentsSuccessors, initialPrefix, allResultingElements);
            }
        }
        assert (resultCount == allResultingElements.size());
        return allResultingElements;
    }

    private static void createCartesianProduct0(List<Collection<? extends AbstractState>> allComponentsSuccessors, List<AbstractState> prefix, Collection<List<AbstractState>> allResultingElements) {
        if (prefix.size() == allComponentsSuccessors.size()) {
            allResultingElements.add(prefix);
        } else {
            int depth = prefix.size();
            Collection<? extends AbstractState> myComponentsSuccessors = allComponentsSuccessors.get(depth);
            for (AbstractState abstractState : myComponentsSuccessors) {
                ArrayList<AbstractState> newPrefix = new ArrayList<AbstractState>(prefix);
                newPrefix.add(abstractState);
                CompositeTransferRelation.createCartesianProduct0(allComponentsSuccessors, newPrefix, allResultingElements);
            }
        }
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }

    boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors, List<ConfigurableProgramAnalysis> cpas) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)pCfaEdge);
        CompositeState compositeState = (CompositeState)pElement;
        int resultCount = 1;
        boolean result = true;
        for (int i = 0; i < this.size; ++i) {
            HashSet<AbstractState> componentSuccessors = new HashSet<AbstractState>();
            for (AbstractState abstractState : pSuccessors) {
                CompositeState compositeSuccessor = (CompositeState)abstractState;
                if (compositeSuccessor.getNumberOfStates() != this.size) {
                    return false;
                }
                componentSuccessors.add(compositeSuccessor.get(i));
            }
            resultCount *= componentSuccessors.size();
            ProofChecker proofChecker = (ProofChecker)((Object)cpas.get(i));
            if (!proofChecker.areAbstractSuccessors(compositeState.get(i), pCfaEdge, componentSuccessors)) {
                result = false;
                continue;
            }
            if (!componentSuccessors.isEmpty()) continue;
            assert (pSuccessors.isEmpty());
            return true;
        }
        if (resultCount > pSuccessors.size()) {
            return false;
        }
        HashSet<Iterable> states = new HashSet<Iterable>();
        for (AbstractState abstractState : pSuccessors) {
            states.add(((CompositeState)abstractState).getWrappedStates());
        }
        if (resultCount != states.size()) {
            return false;
        }
        return result;
    }
}

