/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="cpa.conditions.path.assignments")
public class AssignmentsInPathCondition
implements PathCondition,
Statistics {
    @Option(secure=true, description="This option sets the soft threshold for assignments (-1 for infinite). The semantics are that variables are tracked up to this threshold, even if not being contained in the precison yet, and are removed once there are more assignments for a variable then defined by this threshold. Once the variable is found to be relevant, e.g., through refinement and interpolation, the variable is tracked again, until reaching the  hard threshold.")
    @IntegerOption(min=-1L)
    private int softThreshold = -1;
    @Option(secure=true, description="This option sets the hard threshold for assignments (-1 for infinite). A variable reaching this assignment threshold is not tracked anymore, even if it is contained in the precision.")
    @IntegerOption(min=-1L)
    private int hardThreshold = -1;
    @Option(secure=true, description="This option determines if there should be a single assignment state per transition (more precise) or per path segment between assume edges (more efficient).")
    private boolean precise = true;
    private int maxNumberOfAssignments = 0;

    public AssignmentsInPathCondition(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.softThreshold == -1) {
            logger.log(Level.INFO, new Object[]{AssignmentsInPathCondition.class.getSimpleName() + " in use" + " with softThreshold set to infinite (-1), so only state information will be collected," + " while no thresholds will be enforced."});
        }
    }

    @Override
    public AvoidanceReportingState getInitialState(CFANode node) {
        return new UniqueAssignmentsInPathConditionState();
    }

    @Override
    public AvoidanceReportingState getAbstractSuccessor(AbstractState pElement, CFAEdge pEdge) {
        UniqueAssignmentsInPathConditionState current = (UniqueAssignmentsInPathConditionState)pElement;
        this.maxNumberOfAssignments = Math.max(this.maxNumberOfAssignments, current.getMaximum());
        if (this.precise || pEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
            return new UniqueAssignmentsInPathConditionState(current.maximum, (Multimap<ValueAnalysisState.MemoryLocation, Value>)HashMultimap.create((Multimap)current.mapping));
        }
        return current;
    }

    @Override
    public boolean adjustPrecision() {
        this.softThreshold *= 2;
        this.hardThreshold *= 2;
        return true;
    }

    @Override
    public String getName() {
        return "unique assignments in path condition";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reachedSet) {
        out.println("Threshold value (soft):     " + this.softThreshold);
        out.println("Threshold value (hard):     " + this.hardThreshold);
        out.println("Max. number of assignments: " + this.maxNumberOfAssignments);
    }

    public class UniqueAssignmentsInPathConditionState
    implements AbstractState,
    AvoidanceReportingState {
        private Multimap<ValueAnalysisState.MemoryLocation, Value> mapping = HashMultimap.create();
        private int maximum;

        private UniqueAssignmentsInPathConditionState() {
            this(0, (Multimap<ValueAnalysisState.MemoryLocation, Value>)HashMultimap.create());
        }

        public UniqueAssignmentsInPathConditionState(int pMaximum, Multimap<ValueAnalysisState.MemoryLocation, Value> pMapping) {
            this.maximum = pMaximum;
            this.mapping = pMapping;
        }

        public int getMaximum() {
            return this.maximum;
        }

        @Override
        public BooleanFormula getReasonFormula(FormulaManagerView formulaManager) {
            return PreventingHeuristic.ASSIGNMENTSINPATH.getFormula(formulaManager, this.maximum);
        }

        @Override
        public boolean mustDumpAssumptionForAvoidance() {
            return AssignmentsInPathCondition.this.softThreshold != -1 && this.maximum > AssignmentsInPathCondition.this.softThreshold;
        }

        public boolean wouldExceedSoftThreshold(ValueAnalysisState state, ValueAnalysisState.MemoryLocation memoryLocation) {
            if (AssignmentsInPathCondition.this.softThreshold == -1) {
                return false;
            }
            int increment = this.mapping.containsEntry((Object)memoryLocation, (Object)state.getValueFor(memoryLocation)) ? 0 : 1;
            return this.mapping.get((Object)memoryLocation).size() + increment > AssignmentsInPathCondition.this.softThreshold;
        }

        public boolean exceedsHardThreshold(ValueAnalysisState.MemoryLocation memoryLocation) {
            return AssignmentsInPathCondition.this.hardThreshold > -1 && this.mapping.containsKey((Object)memoryLocation) && this.mapping.get((Object)memoryLocation).size() > AssignmentsInPathCondition.this.hardThreshold;
        }

        public void updateAssignmentInformation(ValueAnalysisState.MemoryLocation memoryLocation, Value value) {
            this.mapping.put((Object)memoryLocation, (Object)value);
            this.maximum = Math.max(this.maximum, this.mapping.get((Object)memoryLocation).size());
        }

        public String toString() {
            return this.mapping.toString() + " [max: " + this.maximum + "]";
        }

        public Set<ValueAnalysisState.MemoryLocation> getMemoryLocationsExceedingHardThreshold() {
            HashSet<ValueAnalysisState.MemoryLocation> exceedingMemoryLocations = new HashSet<ValueAnalysisState.MemoryLocation>();
            for (ValueAnalysisState.MemoryLocation memoryLocation : this.mapping.keys()) {
                if (this.mapping.get((Object)memoryLocation).size() <= AssignmentsInPathCondition.this.hardThreshold) continue;
                exceedingMemoryLocations.add(memoryLocation);
            }
            return exceedingMemoryLocations;
        }
    }
}

