/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import java.io.PrintStream;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="cpa.conditions.path.length")
public class PathLengthCondition
implements PathCondition,
Statistics {
    @Option(secure=true, description="maximum path length (-1 for infinite)", name="limit")
    @IntegerOption(min=-1L)
    private int threshold = -1;
    private int increaseThresholdBy = 0;
    private int maxPathLength = 0;

    public PathLengthCondition(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public AvoidanceReportingState getInitialState(CFANode pNode) {
        return new PathLengthConditionState(0, false);
    }

    @Override
    public AvoidanceReportingState getAbstractSuccessor(AbstractState pState, CFAEdge pEdge) {
        PathLengthConditionState current = (PathLengthConditionState)pState;
        if (current.thresholdReached) {
            return current;
        }
        int pathLength = current.pathLength + 1;
        boolean thresholdReached = this.threshold >= 0 && pathLength >= this.threshold;
        this.maxPathLength = Math.max(pathLength, this.maxPathLength);
        return new PathLengthConditionState(pathLength, thresholdReached);
    }

    @Override
    public boolean adjustPrecision() {
        if (this.threshold == -1) {
            this.threshold = this.maxPathLength / 5;
            this.increaseThresholdBy = this.threshold / 4;
        } else {
            this.threshold += this.increaseThresholdBy;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Path length condition";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        out.println("Maximum length of a path: " + this.maxPathLength);
        out.println("Threshold value:          " + this.threshold);
    }

    private static class PathLengthConditionState
    implements AbstractState,
    AvoidanceReportingState {
        private final int pathLength;
        private final boolean thresholdReached;

        private PathLengthConditionState(int pPathLength, boolean pThresholdReached) {
            this.pathLength = pPathLength;
            this.thresholdReached = pThresholdReached;
        }

        @Override
        public boolean mustDumpAssumptionForAvoidance() {
            return this.thresholdReached;
        }

        @Override
        public BooleanFormula getReasonFormula(FormulaManagerView pMgr) {
            return PreventingHeuristic.PATHLENGTH.getFormula(pMgr, this.pathLength);
        }

        public String toString() {
            return "path length: " + this.pathLength + (this.thresholdReached ? " (threshold reached)" : "");
        }
    }
}

