/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dominator.parametric;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;

public class DominatorState
implements AbstractStateWithLocation,
AbstractState {
    private AbstractState dominatedState;
    private Set<AbstractState> dominators = new HashSet<AbstractState>();

    public DominatorState(AbstractState dominatedElement) {
        if (dominatedElement == null) {
            throw new IllegalArgumentException("dominatedState is null!");
        }
        this.dominatedState = dominatedElement;
    }

    public DominatorState(AbstractState dominatedElement, Set<AbstractState> dominators) {
        this(dominatedElement);
        if (dominators == null) {
            throw new IllegalArgumentException("dominators is null!");
        }
        this.dominators.addAll(dominators);
    }

    protected DominatorState() {
        this.dominatedState = null;
    }

    public DominatorState(DominatorState other) {
        this(other.dominatedState, other.dominators);
    }

    public DominatorState(AbstractState dominatedElement, DominatorState other) {
        this(dominatedElement, other.dominators);
    }

    public void update(AbstractState dominator) {
        if (dominator == null) {
            throw new IllegalArgumentException("dominator is null!");
        }
        this.dominators.add(dominator);
    }

    public AbstractState getDominatedState() {
        return this.dominatedState;
    }

    public Iterator<AbstractState> getIterator() {
        return this.dominators.iterator();
    }

    public boolean isDominatedBy(AbstractState dominator) {
        return this.dominators.contains(dominator);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DominatorState)) {
            return false;
        }
        DominatorState other_element = (DominatorState)other;
        if (!this.dominatedState.equals(other_element.dominatedState)) {
            return false;
        }
        if (this.dominators.size() != other_element.dominators.size()) {
            return false;
        }
        for (AbstractState dominator : this.dominators) {
            if (other_element.isDominatedBy(dominator)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("( " + this.dominatedState.toString() + ", {");
        boolean first = true;
        for (AbstractState dominator : this.dominators) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(dominator.toString());
        }
        builder.append("})");
        return builder.toString();
    }

    @Override
    public CFANode getLocationNode() {
        return ((AbstractStateWithLocation)this.dominatedState).getLocationNode();
    }

    @Override
    public Iterable<CFAEdge> getOutgoingEdges() {
        return ((AbstractStateWithLocation)this.dominatedState).getOutgoingEdges();
    }

    public int hashCode() {
        return this.dominatedState.hashCode();
    }
}

