/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.edgeexclusion;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.interfaces.Precision;

public class EdgeExclusionPrecision
implements Precision {
    private static final EdgeExclusionPrecision EMPTY = new EdgeExclusionPrecision((ImmutableSet<CFAEdge>)ImmutableSet.of());
    private final ImmutableSet<CFAEdge> excludedEdges;

    public static EdgeExclusionPrecision getEmptyPrecision() {
        return EMPTY;
    }

    private EdgeExclusionPrecision(ImmutableSet<CFAEdge> pExcludedEdges) {
        this.excludedEdges = pExcludedEdges;
    }

    public EdgeExclusionPrecision excludeMoreEdges(Iterable<CFAEdge> pAdditionalExcludedEdges) {
        if (pAdditionalExcludedEdges instanceof Collection) {
            return this.excludeMoreEdges((Collection)pAdditionalExcludedEdges);
        }
        return this.excludeMoreEdges((Collection<CFAEdge>)FluentIterable.from(pAdditionalExcludedEdges).toSet());
    }

    public EdgeExclusionPrecision excludeMoreEdges(Collection<CFAEdge> pAdditionalExcludedEdges) {
        if (this.excludedEdges.containsAll(pAdditionalExcludedEdges)) {
            return this;
        }
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        setBuilder.addAll(this.excludedEdges);
        ArrayDeque<CFAEdge> waitlist = new ArrayDeque<CFAEdge>(pAdditionalExcludedEdges);
        while (!waitlist.isEmpty()) {
            CFAEdge current = (CFAEdge)waitlist.poll();
            if (current instanceof MultiEdge) {
                for (CFAEdge edge : (MultiEdge)current) {
                    waitlist.offer(edge);
                }
            }
            setBuilder.add((Object)current);
        }
        return new EdgeExclusionPrecision((ImmutableSet<CFAEdge>)setBuilder.build());
    }

    public boolean isExcluded(CFAEdge pEdge) {
        if (this.excludedEdges.contains((Object)pEdge)) {
            return true;
        }
        if (pEdge instanceof MultiEdge) {
            for (CFAEdge edge : (MultiEdge)pEdge) {
                if (!this.isExcluded(edge)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.excludedEdges.isEmpty() ? "no precision" : this.excludedEdges.toString();
    }
}

