/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.interval")
public class IntervalAnalysisCPA
implements ConfigurableProgramAnalysis,
ProofChecker {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which type of merge operator to use for IntervalAnalysisCPA")
    private String mergeType = "SEP";
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private TransferRelation transferRelation;
    private PrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(IntervalAnalysisCPA.class);
    }

    private IntervalAnalysisCPA(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        this.mergeOperator = this.mergeType.equals("SEP") ? MergeSepOperator.getInstance() : new MergeJoinOperator(this.abstractDomain);
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = new IntervalAnalysisTransferRelation(config);
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new IntervalAnalysisState();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        try {
            Collection<? extends AbstractState> computedSuccessors = this.transferRelation.getAbstractSuccessorsForEdge(pState, SingletonPrecision.getInstance(), pCfaEdge);
            for (AbstractState abstractState : computedSuccessors) {
                boolean found = false;
                for (AbstractState abstractState2 : pSuccessors) {
                    if (!this.isCoveredBy(abstractState, abstractState2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        catch (CPAException e) {
            throw new CPATransferException("Cannot compare abstract successors", e);
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        return this.abstractDomain.isLessOrEqual(pState, pOtherState);
    }
}

